% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SC.MEB.R
\name{gmrfICMEM}
\alias{gmrfICMEM}
\title{gmrfICMEM.}
\usage{
gmrfICMEM(
  y,
  x_int,
  Adj,
  mu_int,
  sigma_int,
  alpha,
  beta,
  PX,
  maxIter_ICM,
  maxIter
)
}
\arguments{
\item{y}{is a matrix of PCs containing gene expression.}

\item{x_int}{is a vector of initial cluster label.}

\item{Adj}{is a matrix containing neighborhood information generated by find_neighbors2.}

\item{mu_int}{is a initial mean vector. we often generated it by Gaussian mixture model.}

\item{sigma_int}{is a initial co-variance matrix. we often generated it by Gaussian mixture model.}

\item{alpha}{is a intercept.}

\item{beta}{is a smoothing parameter that can be specified by user.}

\item{PX}{is a logical value specifying the parameter expansion in EM algorithm.}

\item{maxIter_ICM}{is the maximum iteration of ICM algorithm.}

\item{maxIter}{is the maximum iteration of EM algorithm.}
}
\value{
a list.

The item 'x' is the clustering result. 

The item 'gam' is the posterior probability matrix.
 
The item 'ell' is the opposite log-likelihood. 

The item 'mu' is the mean of each component.

The item 'sigma' is the variance of each component.
}
\description{
gmrfICMEM was used to conduct spatial clustering with hidden Markov random field for fixed beta and fixed number of clusters
}
\details{
gmrfICMEM was used to conduct spatial clustering with hidden Markov random field for fixed beta and fixed number of clusters
}
\examples{
## read the simulated data 
data(PC)
data(sce)
## find the neighborhood of spot
platform = "ST"
Adj <- find_neighbors2(sce, platform)
## set the initial value
fit_int = mclust::Mclust(PC, G=2, verbose = FALSE)
mu_int <- unname(fit_int$parameter$mean)
sigma_int <- unname(fit_int$parameter$variance$sigma)
x_int <- fit_int$classification
alpha <- -log(fit_int$parameter$pro) * 0
bet = 1
maxIter_ICM = 10
maxIter = 50
## run the gmrfICMEM function
out = gmrfICMEM(PC, x_int, Adj, mu_int, sigma_int, alpha, beta = bet, PX = TRUE, 
maxIter_ICM = maxIter_ICM, maxIter = maxIter)
}
