% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_table.R
\name{slice_time}
\alias{slice_time}
\title{Slices a data object based on time / date}
\usage{
slice_time(.data, slice_ts, from_ts = from_ts, until_ts = until_ts)
}
\arguments{
\item{.data}{A data frame, a tibble, a data.table or a tbl.}

\item{slice_ts}{The time / date to slice by}

\item{from_ts}{The name of the column in .data specifying valid from time (note: must be unquoted)}

\item{until_ts}{The name of the column in .data specifying valid until time (note: must be unquoted)}
}
\value{
An object similar to .data
}
\description{
Slices a data object based on time / date
}
\examples{
conn <- get_connection(drv = RSQLite::SQLite())

m <- mtcars |>
  dplyr::mutate(from_ts = dplyr::if_else(dplyr::row_number() > 10,
                                         as.Date("2020-01-01"),
                                         as.Date("2021-01-01")),
                until_ts = as.Date(NA))

dplyr::copy_to(conn, m, name = "mtcars")

q <- dplyr::tbl(conn, id("mtcars", conn))

nrow(slice_time(q, "2020-01-01")) # 10
nrow(slice_time(q, "2021-01-01")) # nrow(mtcars)

close_connection(conn)
}
