% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotSCIR.R
\name{PlotSCIR}
\alias{PlotSCIR}
\title{Plot SCIntRuler}
\usage{
PlotSCIR(fullcluster, seuratlist, testres, legendtitle = NULL, title = NULL)
}
\arguments{
\item{fullcluster}{A list of clusters that generated by the function GetCluster.}

\item{seuratlist}{A list of Seurat objects, usually can be got by SplitObject().}

\item{testres}{Result from function PermTest()}

\item{legendtitle}{Title of legend, default to be NULL}

\item{title}{Title of figure, default to be NULL}
}
\value{
A ggplot2 object
}
\description{
Plot SCIntRuler
}
\examples{
\donttest{
data(sim_data_sce)
data(sim_result)
sim_data <- SCEtoSeurat(sim_data_sce)
seuratlist <- Seurat::SplitObject(sim_data, split.by = "Study")
PlotSCIR(sim_result[[1]], seuratlist, sim_result[[4]])
}
}
