% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_functions.R
\name{SDALGCPSSIPoint}
\alias{SDALGCPSSIPoint}
\title{SDALGCPSSIPoint function}
\usage{
SDALGCPSSIPoint(poly, delta, weighted = FALSE, pop_shp = NULL,
  lambdamax = NULL, pop = NULL, n = NULL, rho = NULL,
  giveup = NULL)
}
\arguments{
\item{poly}{polygon in which to generate the points.}

\item{delta}{distance between points.}

\item{weighted}{To specify if you want to use the population density, default to FALSE, i.e population density is not used.}

\item{pop_shp}{Optional, The raster of population density map for population weighted approach.}

\item{lambdamax}{the maximum value of the population density in the polygon.}

\item{pop}{the population density.}

\item{n}{optional; the number of points to create in the polygon, if not supplied, it is computed as \eqn{n = rho*|A|*4/(\pi*delta^2)}}

\item{rho}{Optional, The packing density, default set to 0.55.}

\item{giveup}{Number of rejected proposals after which the algorithm should terminate.}
}
\value{
It returns a list of the coordinates of the points created in each polygon.
}
\description{
This function generate a random point pattern using Simple Sequential Inhibition (SSI) process. An internal function for \code{\link{SDALGCP}} package.
}
\details{
This algorithm generates points inside the polygon using Simple Sequential Inhibition (SSI) process.
}
\examples{
data(PBCshp)
points <- SDALGCPSSIPoint(poly=PBCshp@polygons[[1]]@Polygons[[1]]@coords, delta=100)
}
\author{
Olatunji O. Johnson \email{o.johnson@lancaster.ac.uk}

Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
\keyword{internal}
