% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.SDTree}
\alias{print.SDTree}
\title{Print a SDTree}
\usage{
\method{print}{SDTree}(x, ...)
}
\arguments{
\item{x}{Fitted object of class \code{SDTree}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
No return value, called for side effects
}
\description{
Print contents of the SDTree.
}
\examples{

set.seed(1)
n <- 10
X <- matrix(rnorm(n * 5), nrow = n)
y <- sign(X[, 1]) * 3 + rnorm(n)
model <- SDTree(x = X, y = y, Q_type = 'no_deconfounding', cp = 0.5)
print(model)
}
\seealso{
\code{\link{SDTree}}
}
\author{
Markus Ulmer
}
