% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxentTh.R
\name{maxentTh}
\alias{maxentTh}
\title{MaxEnt Thresholds}
\usage{
maxentTh(model)
}
\arguments{
\item{model}{\linkS4class{SDMmodel} object trained using the "Maxent" method.}
}
\value{
data.frame with the thresholds.
}
\description{
Returns the value of the thresholds generated by the MaxEnt software.
}
\examples{
\donttest{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence locations
p_coords <- condor[, 1:2]

# Prepare background locations
bg_coords <- dismo::randomPoints(predictors, 5000)

# Create SWD object
presence <- prepareSWD(species = "Vultur gryphus", coords = p_coords,
                       env = predictors, categorical = "biome")
bg <- prepareSWD(species = "Vultur gryphus", coords = bg_coords,
                 env = predictors, categorical = "biome")

# Train a Maxent model
model <- train(method = "Maxent", p = presence, a = bg, fc = "l")
maxentTh(model)
}
}
\seealso{
\code{\link{maxentVarImp}}
}
\author{
Sergio Vignali
}
