% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresholds.R
\name{thresholds}
\alias{thresholds}
\title{Thresholds}
\usage{
thresholds(model, type, test = NULL)
}
\arguments{
\item{model}{\linkS4class{SDMmodel} object.}

\item{type}{character. The output type, possible values are "cloglog" and
"logistic", default is "cloglog".}

\item{test}{\linkS4class{SWD} test locations, if not provided it returns the
training and test thresholds, default is \code{NULL}.}
}
\value{
data.frame with the thresholds.
}
\description{
Compute three threshold values: minimum training presence, equal training
sensitivity and specificity and maximum training sensitivity plus
specificity together with fractional predicted area and the omission rate. If
a test dataset is provided it returns also the equal test sensitivity and
specificity and maximum test sensitivity plus specificity thresholds and the
p-values of the one-tailed binomial exact test.
}
\details{
The equal training sensitivity and specificity minimizes the
difference between sensitivity and specificity. The one-tailed binomial test
checks that test points are predicted no better than by a random prediction
with the same fractional predicted area.
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence locations
p_coords <- condor[, 1:2]

# Prepare background locations
bg_coords <- dismo::randomPoints(predictors, 5000)

# Create SWD object
presence <- prepareSWD(species = "Vultur gryphus", coords = p_coords,
                       env = predictors, categorical = "biome")
bg <- prepareSWD(species = "Vultur gryphus", coords = bg_coords,
                 env = predictors, categorical = "biome")

# Split presence locations in training (80\%) and testing (20\%) datasets
datasets <- trainValTest(presence, test = 0.2)
train <- datasets[[1]]
test <- datasets[[2]]

# Train a model
model <- train(method = "Maxnet", p = train, a = bg, fc = "l")

# Get the cloglog thresholds
thresholds(model, type = "cloglog")

# Get the logistic thresholds passing the test dataset
thresholds(model, type = "logistic", test = test)
}
\author{
Sergio Vignali
}
