% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tss.R
\name{tss}
\alias{tss}
\title{True Skill Statistics}
\usage{
tss(model, test = NULL)
}
\arguments{
\item{model}{\linkS4class{SDMmodel} or \linkS4class{SDMmodelCV} object.}

\item{test}{\linkS4class{SWD} object when \code{model} is an
\linkS4class{SDMmodel} object; logical or \linkS4class{SWD} object when
\code{model} is an \linkS4class{SDMmodelCV} object. If not provided it computes
the training TSS, see details.}
}
\value{
The value of the TSS of the given model.
}
\description{
Compute the max TSS of a given model.
}
\details{
For \linkS4class{SDMmodelCV} objects, the function computes the
mean of the training TSS values of the k-folds. If \code{test = TRUE} it computes
the mean of the testing TSS values for the k-folds. If test is an
\linkS4class{SWD} object, it computes the mean TSS values for the provided
testing dataset.
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd",
                    full.names = TRUE)

predictors <- terra::rast(files)

# Prepare presence and background locations
p_coords <- virtualSp$presence
bg_coords <- virtualSp$background

# Create SWD object
data <- prepareSWD(species = "Virtual species",
                   p = p_coords,
                   a = bg_coords,
                   env = predictors,
                   categorical = "biome")

# Split presence locations in training (80\%) and testing (20\%) datasets
datasets <- trainValTest(data,
                         test = 0.2,
                         only_presence = TRUE)
train <- datasets[[1]]
test <- datasets[[2]]

# Train a model
model <- train(method = "Maxnet",
               data = train,
               fc = "l")

# Compute the training TSS
tss(model)

# Compute the testing TSS
tss(model,
    test = test)

\donttest{# Same example but using cross validation instead of training and
# testing datasets. Create 4 random folds splitting only the presence
# locations
folds = randomFolds(train,
                    k = 4,
                    only_presence = TRUE)

model <- train(method = "Maxnet",
               data = train,
               fc = "l",
               folds = folds)

# Compute the training TSS
tss(model)

# Compute the testing TSS
tss(model,
    test = TRUE)

# Compute the TSS for the held apart testing dataset
tss(model,
    test = test)}
}
\references{
Allouche O., Tsoar A., Kadmon R., (2006). Assessing the accuracy of species
distribution models: prevalence, kappa and the true skill statistic (TSS).
Journal of Applied Ecology, 43(6), 1223–1232.
}
\seealso{
\link{aicc} and \link{auc}.
}
\author{
Sergio Vignali
}
