% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/leerDatos.R
\name{addKeelRegister}
\alias{addKeelRegister}
\title{Add one or a set of instances to a KEEL dataset.}
\usage{
addKeelRegister(items, dataset)
}
\arguments{
\item{items}{Vector or list of instance/s}

\item{dataset}{The \code{keel} dataset to insert the data.}
}
\value{
Returns the new dataset with data introduced. This dataset is a list with a vectors of every instace.
This dataset should be stored into the \code{$data}
field of a \code{keel} class variable.
}
\description{
Take a data vector or a list of data vectors and inserts at the end of a \code{keel} data set.
}
\details{
You can add the data in four ways:
\itemize{
 \item A single element, using a vector.
   \itemize{
     \item Coded.
     \item Uncoded.
   }
 \item More than one element, using a list of vectors.
  \itemize{
     \item Coded.
     \item Uncoded.
   }
}

Coded means that vectors of data are all numeric (including class) and, obviously,
all values are within the bounds stablished. This way is the returned after a \code{read.keel()} call
and it is the ideal for introduce data from one dataset to another, for example.

 Uncoded means that vectors of data are characters, because it has at least one value that is a string (class value) and values are valid. This is common when we read
 a csv file or we introduce data manually, for example.
}
\author{
Angel M. Garcia <amgv0009@red.ujaen.es>
}
\references{
J. Alcala-Fdez, A. Fernandez, J. Luengo, J. Derrac, S. Garcia, L. Sanchez, F. Herrera. KEEL Data-Mining Software Tool: Data Set Repository, Integration of Algorithms and Experimental Analysis Framework. Journal of Multiple-Valued Logic and Soft Computing 17:2-3 (2011) 255-287.
}
\seealso{
KEEL Dataset Repository (Standard Classification): \url{http://sci2s.ugr.es/keel/category.php?cat=clas}
}

