% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bas.line.r
\name{bas.line}
\alias{bas.line}
\title{Draws a Balanced Acceptance Sample (BAS) from a linear resource (line).}
\usage{
bas.line(x, n, balance = "1D", init.n.factor = 10)
}
\arguments{
\item{x}{A \code{SpatialLines} or \code{SpatialLinesDataFrame} object. This object must
contain at least 1 line.  If it contains more than 1 line, the BAS sample is
drawn from the union of all lines.}

\item{n}{Sample size.  Number of locations to draw from the set of all lines
contained in \code{x}.}

\item{balance}{Option specifying how spatial balance is maintained. The options
are "1D" or "2D".  

Under "1D" all lines in \code{x} are stretched straight 
and laid end-to-end in the order they appear in \code{x} and a 1-dimensional 
BAS sample is taken from the amalgamated line.  1D sample locations on the 
amalgomated line are  
mapped back to two dimensional space for output and 
appear on the original lines.  This
method maintains 1D spatial balance, but not necessarily 2D balance.  Spatially 
balanced samples in 1D may not look spatially balanced when plotted 
in 2 dimensions.   

Under "2D" a systematic sample of points along the union of all lines 
in \code{x} is drawn first, and a 2-dimensional BAS sample of the points
is drawn (see \code{init.n.factor} below and \code{\link{bas.point}}).  
This maintains 2D spatial balance of sample locations on the lines. Depending 
on \code{init.n.factor}, the "2D" balance option can take significantly 
longer to run than the "1D" option.}

\item{init.n.factor}{If \code{balance == "2D"}, this is a 
scalar controlling the number of points to
place on the lines before drawing the 2D BAS sample.  
Number of points created on the line is
\code{n*init.n.factor}, so this number can grow quickly.  On average, this
is the number of unselected points between each selected point.  See
Details.

If one desires an underlying grid spaced \emph{w} meters appart, set 
\code{init.n.factor} to \emph{L/(w*n)}, where \emph{L} is total length 
of all lines in \code{x} and \emph{n} is sample size.}
}
\value{
A \code{SpatialPointsDataFrame} containing locations in the BAS sample, 
in BAS order.
 Attributes of the sample points are: 
\itemize{
  \item \code{sampleID}: A unique identifier for every sample point.  This 
  encodes the BAS order.  \code{return[order(return$sampleID),]} will sort the 
  returned object in BAS order.
  
  \item \code{geometryID}: The ID of the line in \code{x} on which each 
  sample point falls.  The 
  ID of lines in \code{x} are \code{row.names(x)}. 
  \item Any attributes of the original lines (in \code{x}). 
}

Additional attributes of the output object, beyond those which 
make it a \code{SpatialPointsDataFrame}, are:
\itemize{
   \item \code{frame}: Name of the input sampling frame.
   \item \code{frame.type}: Type of resource in sampling frame. (i.e., "line").
   \item \code{sample.type}: Type of sample drawn. (i.e., "BAS").
   \item \code{balance}: The type of balance ("1d" or "2d").
   \item \code{random.start}: The random seed for the random-start 
   1D or 2D Halton sequence 
   that produced the sample.  
   If \code{balance=="1D"}, this is a single uniform random 
   integer between 0 and \code{\link{maxU}}. If \code{balance=="2D"}, this is 
   a vector of two uniform random 
   integers between 0 and \code{\link{maxU}}.  
   
   \item \code{bas.bbox}: If \code{balance=="2D"}, this is the square 
   bounding box surrounding \code{x}
   used to scale Halton points.  A scaled Halton sequence of n points
   used to sample points on the lines of \code{x} is 
   \code{bas.bbox[,"min"] + t(halton(n,2,random.start)) * 
   rep( max(diff(t(bas.bbox))), 2)}.
   If \code{balance=="1D"}, this is a vector containing the 1D 
   bounding box. The 1D bounding box is 0 to the total 
   length of all lines in \code{x}.  In this case, Halton points 
   are scaled as \code{bas.bbox[,"min"] + halton(n,1,random.start) * 
   diff(bas.bbox)} which is equivalent to \code{halton(n,1,random.start) * 
   bas.bbox[2]} because \code{bas.bbox[1]} is zero in this case.
}
}
\description{
Draws a BAS sample from a \code{SpatialLines*} object.
}
\details{
If a "1D" sample is requested, spatial balance is maintained on the 
lines when laid end-to-end in the order they appear.  Points far apart 
in 1 dimension may be close together in 2 dimensions, and vice versa. 
Thus the sample may not look spatially balanced on a 2D map. This is a 
true infinite sample in that any of an infinite number of points 
along the lines could be selected.

If a "2D" BAS sample is requested, spatial balance is maintained 
in 2 dimensions.  Points are well balance on a 2D map.  This is 
done by discretization of lines with a dense systematic 
sample of points (with 
random start) where density of the systematic points is controled 
by \code{init.n.factor}.  After
discretization of the line, points are selected 
using \code{\link{bas.point}}.  The BAS method for points places
a small square (pixel) around each and samples the set of squares
using the BAS method for polygons (see \code{\link{bas.polygon}}).  The BAS
method of polygons computes Halton points until \code{n} fall
inside the squares surrounding discretization points.  When a 
Halton
point falls in a square, the square is selected and the 
sample location is the center of the square (which falls somewhere on the
original lines).
}
\examples{

#   Draw sample of Hawaii coastline
#   This takes approximately 60 seconds to run
samp <- bas.line( HI.coast, 50 )
plot(HI.coast)
points( samp, pch=16, col="red" )


}
\author{
Trent McDonald
}
\seealso{
\code{\link{bas.line}}, \code{\link{bas.polygon}}, \code{\link{sdraw}}
}
\keyword{design}
\keyword{survey}

