% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/halton.coefficients.R
\name{halton.coefficients}
\alias{halton.coefficients}
\title{halton.coefficients}
\usage{
halton.coefficients(samp, J, bases = c(2, 3))
}
\arguments{
\item{samp}{A vector of Halton indices.}

\item{J}{A vector of powers of the bases. This determines the 
level of hierarchy in the Halton boxes and the number of boxes.}

\item{bases}{The bases of the Halton sequence.}
}
\value{
An array of size \code{length(samp)} X \code{max(J)} X \code{length(J)} 
of coefficients.  Row i, column j, page k of this array is the jth coefficient
for the kth dimension of the ith index in \code{samp}.
}
\description{
Return the coefficients in the Halton equation 
for a list of Halton indices (boxes).
}
\details{
Let \code{digits = halton.coefficients(samp,J,bases)},
 \code{K = max(J)} and 
\code{places <- 1/matrix(rep(bases,each=K)^(1:K),K,length(J))}. 
The coordinate in [0,1) of the lower left corner of 
the Halton box with index \code{samp[i]} is 
\code{colSums(digits[i,,] * places, na.rm = T)}.
This is how you get the Halton sequence from this routine.
However, if you are interested in the Halton sequence alone,
not the coefficients, call function \code{halton()}.
}
\author{
Trent McDonald
}
