% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hip.lattice.polygon.r
\name{hip.lattice.polygon}
\alias{hip.lattice.polygon}
\title{Halton Iterative Partition lattice inside a \code{bbox} (bounding box) matrix object.}
\usage{
hip.lattice.polygon(box, J, bases = c(2, 3))
}
\arguments{
\item{box}{A \code{bbox} bounding box for the sample space.}

\item{J}{A 2X1 vector of base powers which determines the size and shape 
of the Halton boxes. See additional description in help for 
\code{\link{hip.polygon}} function.}

\item{bases}{A 2X1 vector of Halton bases.  These must be co-prime.}
}
\value{
A \code{list} of \code{matrices} containing locations in the Halton lattice of the 
partitioned boxes
}
\description{
Constructs an iteratively partitioned lattice of Halton boxes (a Halton lattice) inside a 
bounding box \code{bbox} of the sample space. This method does the 
hard work of partitioning the boxes to sample from. It is meant to be used internally by 
\code{hip.polygon} only.
}
\details{
This routine is called internally by \code{hip.polygon}, and is not 
normally called by the user. This should be avoided
}
\examples{

# Take a simple HIP lattice for illustration
# nboxes = 2^3 * 3^2 = 72 
lat1 <- hip.lattice.polygon(box = matrix(data = c(0,1,0,1), nrow = 2, byrow = TRUE),
                   J = c(3,2),
                   bases = c(2,3))

# legth lat1, should be 72
length(lat1)
# prep points for plotting
trans <- list()
i=1
for(mat in lat1) {
  trans[[i]] <-   t(mat)
  i=i+1
}
# plot points 
plot(c(0,1),c(0,1))

for(mat in trans) {
  points(mat[1,1],mat[1,2])
  points(mat[2,1],mat[2,2])
}


}
\seealso{
\code{\link{hip.polygon}}, \code{\link{hip.point}}
}
\author{
Michael J Kleinsasser
}
\keyword{design}
\keyword{survey}
