% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEMdnn.R
\name{predict.DNN}
\alias{predict.DNN}
\title{SEM-based out-of-sample prediction using layer-wise DNN}
\usage{
\method{predict}{DNN}(object, newdata, verbose = FALSE, ...)
}
\arguments{
\item{object}{A model fitting object from \code{SEMdnn()} function.}

\item{newdata}{A matrix containing new data with rows corresponding to
subjects, and columns to variables.}

\item{verbose}{Print predicted out-of-sample MSE values (default = FALSE).}

\item{...}{Currently ignored.}
}
\value{
A list of 2 objects:
\enumerate{
\item "PE", vector of the prediction error equal to the Mean Squared Error
(MSE) for each out-of-bag prediction. The first value of PE is the AMSE,
where we average over all (sink and mediators) graph nodes.
\item "Yhat", the matrix of continuous predicted values of graph nodes  
(excluding source nodes) based on out-of-bag samples. 
}
}
\description{
Predict method for DNN objects.
}
\examples{

\donttest{
if (torch::torch_is_installed()){

# Load Amyotrophic Lateral Sclerosis (ALS)
data<- alsData$exprs; dim(data)
data<- transformData(data)$data
ig<- alsData$graph; gplot(ig)
group<- alsData$group 

#...with train-test (0.5-0.5) samples
set.seed(123)
train<- sample(1:nrow(data), 0.5*nrow(data))

start<- Sys.time()
dnn0 <- SEMdnn(ig, data, train, cowt = FALSE, thr = NULL,
			#loss = "mse", hidden = 5*K, link = "selu",
			loss = "mse", hidden = c(10, 10, 10), link = "selu",
			validation = 0, bias = TRUE, lr = 0.01,
			epochs = 32, device = "cpu", verbose = TRUE)
end<- Sys.time()
print(end-start)
mse0 <- predict(dnn0, data[-train, ], verbose=TRUE)

# SEMrun vs. SEMdnn MSE comparison
sem0 <- SEMrun(ig, data[train, ], SE="none", limit=1000)
mse0 <- predict(sem0, data[-train,], verbose=TRUE)

#...with a binary outcome (1=case, 0=control)

ig1<- mapGraph(ig, type="outcome"); gplot(ig1)
outcome<- ifelse(group == 0, -1, 1); table(outcome)
data1<- cbind(outcome, data); data1[1:5,1:5]

start<- Sys.time()
dnn1 <- SEMdnn(ig1, data1, train, cowt = TRUE, thr = NULL,
			#loss = "mse", hidden = 5*K, link = "selu",
			loss = "mse", hidden = c(10, 10, 10), link = "selu",
			validation = 0, bias = TRUE, lr = 0.01,
			epochs = 32, device = "cpu", verbose = TRUE)
end<- Sys.time()
print(end-start)

mse1 <- predict(dnn1, data1[-train, ])
yobs <- group[-train]
yhat <- mse1$Yhat[ ,"outcome"]
benchmark(yobs, yhat, thr=0, F1=FALSE)
}
}

}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
