% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_design.R
\name{cluster.error}
\alias{cluster.error}
\title{Clustering error}
\usage{
cluster.error(design, X = NULL, alpha = 1)
}
\arguments{
\item{design}{a design matrix.}

\item{X}{candidate points in \eqn{[0,1]^p}. If X is not provided, Sobol points are generated as candidate points.}

\item{alpha}{power of the Euclidean distance.}
}
\value{
clustering error of the design.
}
\description{
This function computes the clustering error.
}
\details{
\code{cluster.error} computes the clustering error. The clustering error for a design \eqn{D=[\bm x_1, \dots, \bm x_n]^T} is defined as \eqn{\frac{1}{N}\sum_{i=1}^n\sum_{\bm x\in{V_i}}\|\bm x - \bm x_i\|^\alpha}, where \eqn{V_i} is the Voronoi cell of each design point \eqn{\bm x_i} for \eqn{i=1,\dots,n}, N is the size of X. When \eqn{\alpha=2}, we obtain K-means and when \eqn{\alpha=1}, we obtain K-medians.
}
\examples{
n = 20
p = 3
D = randomLHD(n, p)
cluster.error(D)

}
