% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R_utils_wC.R
\name{collect}
\alias{collect}
\title{collect function}
\usage{
collect(prefix = "")
}
\arguments{
\item{prefix}{(character) Prefix that was added to the output files name, this may include a path}
}
\value{
An object of the class 'SSI' for which methods \code{fitted}, \code{plot} and \code{summary} exist
}
\description{
Collects all outputs saved at the provided \code{saveAt} parameter from the SSI analysis when testing data was splited
according to argument \code{subset}.
}
\examples{
  require(SFSI)
  data(wheatHTP)
  
  X = scale(X[1:300,])/sqrt(ncol(X))   # Subset and scale markers
  G = tcrossprod(X)                    # Genomic relationship matrix
  y = as.vector(scale(Y[1:300,"YLD"])) # Subset response variable

  prefix <- paste0(tempdir(),"/testSSI")
  
  # Run the analysis into 4 subsets and save them at a given prefix
  fm <- SSI(y,K=G,tst=1:100,trn=101:length(y),subset=c(1,4),saveAt=prefix)
  fm <- SSI(y,K=G,tst=1:100,trn=101:length(y),subset=c(2,4),saveAt=prefix)
  fm <- SSI(y,K=G,tst=1:100,trn=101:length(y),subset=c(3,4),saveAt=prefix)
  fm <- SSI(y,K=G,tst=1:100,trn=101:length(y),subset=c(4,4),saveAt=prefix)

  # Collect all results after completion
  fm <- collect(prefix)
}

\author{
Marco Lopez-Cruz (\email{maraloc@gmail.com}) and Gustavo de los Campos
}
