% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worms_api_functions.R
\name{update_worms_taxonomy}
\alias{update_worms_taxonomy}
\title{Retrieve and organize WoRMS taxonomy for SHARK Aphia IDs}
\usage{
update_worms_taxonomy(aphia_id, aphiaid = deprecated())
}
\arguments{
\item{aphia_id}{A numeric vector containing Aphia IDs for which WoRMS taxonomy needs to be updated.}

\item{aphiaid}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \code{aphia_id} instead.}
}
\value{
A \code{tibble} containing updated WoRMS taxonomy information.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function was deprecated and replaced by a function with more accurate name. Use \code{\link[=add_worms_taxonomy]{add_worms_taxonomy()}} instead.

This function collects WoRMS (World Register of Marine Species) taxonomy information for a given set of Aphia IDs.
The data is organized into a full taxonomic table that can be joined with data downloaded from \href{https://shark.smhi.se/en/}{SHARK}.
}
\examples{
\donttest{
# Update WoRMS taxonomy for a set of Aphia IDs
updated_taxonomy <- update_worms_taxonomy(c(149619, 149122, 11))
print(updated_taxonomy)
}
}
\seealso{
\url{https://marinespecies.org/} for WoRMS website.

\code{\link{get_shark_data}}, \code{\link{update_dyntaxa_taxonomy}}, \href{https://www.marinespecies.org/rest/}{WoRMS API Documentation}, \url{https://CRAN.R-project.org/package=worrms}
}
\keyword{internal}
