% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfit.R
\name{plotfit}
\alias{plotfit}
\title{Plot the fitted density function for one or more experts}
\usage{
plotfit(fit, d = "best", int = FALSE, xl = -Inf, xu = Inf,
  ql = NA, qu = NA, lp = FALSE, ex = NA, sf = 3, ind = TRUE,
  lpw = 1, fs = 12, lwd = 1, xlab = "x",
  ylab = expression(f[X](x)), legend_full = TRUE,
  percentages = FALSE)
}
\arguments{
\item{fit}{An object of class \code{elicitation}.}

\item{d}{The distribution fitted to each expert's probabilities. Options are
\code{"normal"}, \code{"t"}, \code{"gamma"}, \code{"lognormal"},
\code{"logt"},\code{"beta"}, \code{"hist"} (for a histogram fit), and
\code{"best"} (for best fitting)}

\item{int}{Set \code{int = TRUE} to use interactive plotting (using the
shiny package). If plotting for a single expert, the argument \code{d} is
ignored, as distributions can be chosen within the display. If plotting for
multiple experts, feedback quantiles are not displayed, and the argument
\code{lp} is ignored, as the option to show a linear pool can be chosen
within the display.}

\item{xl}{The lower limit for the x-axis. The default is the 0.001 quantile
of the fitted distribution (or the 0.001 quantile of a fitted normal
distribution, if a histogram fit is chosen).}

\item{xu}{The upper limit for the x-axis. The default is the 0.999 quantile
of the fitted distribution (or the 0.999 quantile of a fitted normal
distribution, if a histogram fit is chosen).}

\item{ql}{A lower quantile to be indicated on the density function plot.
Only displayed when plotting the density function for a single expert.}

\item{qu}{An upper quantile to be indicated on the density function plot.
Only displayed when plotting the density function for a single expert.}

\item{lp}{For multiple experts, set \code{lp = TRUE} to plot a linear pool.}

\item{ex}{If judgements have been elicited from multiple experts, but a
density plot for one expert only is required, the expert to be used in the
plot.}

\item{sf}{The number of significant figures to be displayed for the
parameter values.}

\item{ind}{If plotting a linear pool, set \code{ind = FALSE} to suppress
plotting of the individual density functions.}

\item{lpw}{A vector of weights to be used in linear pool, if unequal
weighting is desired.}

\item{fs}{The font size used in the plot.}

\item{lwd}{The line width used in the plot.}

\item{xlab}{A string or expression giving the x-axis label.}

\item{ylab}{A string or expression giving the y-axis label.}

\item{legend_full}{If plotting a linear pool, set \code{ind = TRUE} for each expert
to be plotted with a different colour, and \code{ind = FALSE} for each expert to be 
plotted with the same colour, reducing the legend size.}

\item{percentages}{Set to \code{TRUE} to use percentages on the x-axis.}
}
\description{
Plots the fitted density function for one or more experts. Can also plot a
fitted linear pool if more than one expert. If plotting the density function
of one expert, or the linear pool only, can also indicated desired lower and
upper fitted quantiles.
}
\examples{

\dontrun{
# Two experts
# Expert 1 states P(X<30)=0.25, P(X<40)=0.5, P(X<50)=0.75
# Expert 2 states P(X<20)=0.25, P(X<25)=0.5, P(X<35)=0.75
# Both experts state 0<X<100. 

v <- matrix(c(30, 40, 50, 20, 25, 35), 3, 2)
p <- c(0.25, 0.5, 0.75)
myfit <- fitdist(vals = v, probs = p, lower = 0, upper = 100)

# Plot both fitted densities, using the best fitted distribution
plotfit(myfit)

# Plot a fitted beta distribution for expert 2, and show 5th and 95th percentiles
plotfit(myfit, d = "beta", ql = 0.05, qu = 0.95, ex = 2)

# Use interactive plotting for for expert 2, and show 5th and 95th percentiles
plotfit(myfit, int = T, ex = 2)

# Plot a linear pool, giving double weight to expert 1
plotfit(myfit,  lp = T, lpw = c(2,1))

# Use interactive plotting, giving double weight to expert 1, if a linear pool is displayed
plotfit(myfit,  int = T, lpw = c(2,1))

# Plot a linear pool, giving double weight to expert 1, 
# show 5th and 95th percentiles, supress plotting of individual distributions, 
# and force use of Beta distributions
plotfit(myfit, d = "beta",  lp = T, lpw = c(2,1), ql = 0.05, qu = 0.95, ind=FALSE )
}
}
\author{
Jeremy Oakley <j.oakley@sheffield.ac.uk>
}
