% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvar2.2012ZXC.R
\name{mvar2.2012ZXC}
\alias{mvar2.2012ZXC}
\title{Two-sample Simultaneous Test of Mean and Variance by Zhang, Xu, and Chen (2012)}
\usage{
mvar2.2012ZXC(x, y)
}
\arguments{
\item{x}{a length-\eqn{n} data vector.}

\item{y}{a length-\eqn{m} data vector.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given two univariate samples \eqn{x} and \eqn{y}, it tests
\deqn{H_0 : \mu_x = \mu_y, \sigma_x^2 = \sigma_y^2 \quad vs \quad H_1 : \textrm{ not } H_0}
using exact null distribution for likelihood ratio statistic.
}
\examples{
## CRAN-purpose small example
x = rnorm(10)
y = rnorm(10)
mvar2.2012ZXC(x, y)

\dontrun{
## empirical Type 1 error 
niter   = 1000
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  x = rnorm(100)  # sample x from N(0,1)
  y = rnorm(100)  # sample y from N(0,1)
  
  counter[i] = ifelse(mvar2.2012ZXC(x,y)$p.value < 0.05, 1, 0)
  print(paste("* mvar2.2012ZXC : iteration ",i,"/",niter," complete.",sep=""))
}

## print the result
cat(paste("\n* Example for 'mvar2.2012ZXC'\n","*\n",
"* number of rejections   : ", sum(counter),"\n",
"* total number of trials : ", niter,"\n",
"* empirical Type 1 error : ",round(sum(counter/niter),5),"\n",sep=""))
}

}
\references{
\insertRef{zhang_exact_2012}{SHT}
}
\concept{mvar}
