% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LF_linear.R
\name{LF}
\alias{LF}
\title{Inference for a linear combination of regression coefficients in high dimensional linear regression.}
\usage{
LF(
  X,
  y,
  loading,
  intercept = TRUE,
  init.Lasso = NULL,
  lambda = NULL,
  mu = NULL,
  step = NULL,
  resol = 1.5,
  maxiter = 6,
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{X}{Design matrix, of dimension \eqn{n} x \eqn{p}}

\item{y}{Outcome vector, of length \eqn{n}}

\item{loading}{Loading, of length \eqn{p}}

\item{intercept}{Should intercept(s) be fitted (default = \code{TRUE})}

\item{init.Lasso}{Initial LASSO estimator of the regression vector (default = \code{NULL})}

\item{lambda}{The tuning parameter in the construction of LASSO estimator of the regression vector (default = \code{NULL})}

\item{mu}{The dual tuning parameter used in the construction of the projection direction (default = \code{NULL})}

\item{step}{The step size used to compute \code{mu}; if set to \code{NULL} it is
computed to be the number of steps (< \code{maxiter}) to obtain the smallest \code{mu}
such that the dual optimization problem for constructing the projection direction converges (default = \code{NULL})}

\item{resol}{The factor by which \code{mu} is increased/decreased to obtain the smallest \code{mu}
such that the dual optimization problem for constructing the projection direction converges (default = 1.5)}

\item{maxiter}{Maximum number of steps along which \code{mu} is increased/decreased to obtain the smallest \code{mu}
such that the dual optimization problem for constructing the projection direction converges (default = 6)}

\item{alpha}{Level of significance to test the null hypothesis which claims that the linear combination of the regression coefficients
is less than or equal to zero (default = 0.05)}

\item{verbose}{Should inetrmediate message(s) be printed (default = \code{TRUE})}
}
\value{
\item{prop.est}{The bias-corrected estimator for the linear combination of regression coefficients}
\item{se}{The standard error of the bias-corrected estimator}
\item{CI}{The confidence interval for the linear combination}
\item{decision}{\code{decision}\eqn{=1} implies the linear combination is above zero \eqn{\newline}
\code{decision}\eqn{=0} implies the linear combination is not above zero}
\item{proj}{The projection direction, of length \eqn{p}}
\item{plug.in}{The plug-in LASSO estimator for the linear combination}
}
\description{
Computes the bias corrected estimator of the linear combination of regression coefficients and the corresponding standard error.
It also constructs the confidence interval for the linear combination and tests whether it is above zero or not.
}
\examples{
n <- 90
p <- 200
A1gen <- function(rho,p){
A1=matrix(0,p,p)
for(i in 1:p){
 for(j in 1:p){
   A1[i,j] <- rho^(abs(i-j))
 }
}
A1
}
mu <- rep(0,p)
rho <- 0.5
Cov <- (A1gen(rho,p))/2
beta <- rep(0,p)
beta[1:10] <- c(1:10)/5
X <- MASS::mvrnorm(n,mu,Cov)
y <- X\%*\%beta + rnorm(n)
loading <- c(1,rep(0,(p-1)))
Est <- LF(X = X, y = y, loading = loading, intercept = TRUE)
}
\references{
\insertRef{linlin}{SIHR}
}
