% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{reduceDroneGeno}
\alias{reduceDroneGeno}
\title{Reduce drones' genotype to a single haplotype}
\usage{
reduceDroneGeno(geno, pop)
}
\arguments{
\item{geno}{\code{\link{matrix-class}}}

\item{pop}{\code{\link{Pop-class}}}
}
\value{
matrix with genotype as one haplotype per drone instead of two - the
  order of individuals and the number of rows stays the same!
}
\description{
Level 0 function that reduces drone's genotype to a single
  haplotype, because we internally simulate them as diploid (doubled
  haploid). This is an internal utility function that you likely don't need
  to use.
}
\examples{
founderGenomes <- quickHaplo(nInd = 3, nChr = 1, segSites = 5)
SP <- SimParamBee$new(founderGenomes, csdChr = NULL)
basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(x = basePop[1], nInd = 2)

(tmp <- getSegSiteGeno(drones))
reduceDroneGeno(geno = tmp, pop = drones)

(tmp <- getSegSiteGeno(c(basePop, drones)))
reduceDroneGeno(geno = tmp, pop = c(basePop, drones))
}
