% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{calcColonyValue}
\alias{calcColonyValue}
\alias{calcColonyPheno}
\alias{calcColonyGv}
\alias{calcColonyBv}
\alias{calcColonyDd}
\alias{calcColonyAa}
\title{Calculate colony value(s)}
\usage{
calcColonyValue(x, FUN = NULL, simParamBee = NULL, ...)

calcColonyPheno(x, FUN = mapCasteToColonyPheno, simParamBee = NULL, ...)

calcColonyGv(x, FUN = mapCasteToColonyGv, simParamBee = NULL, ...)

calcColonyBv(x, FUN = mapCasteToColonyBv, simParamBee = NULL, ...)

calcColonyDd(x, FUN = mapCasteToColonyDd, simParamBee = NULL, ...)

calcColonyAa(x, FUN = mapCasteToColonyAa, simParamBee = NULL, ...)
}
\arguments{
\item{x}{\code{\link[SIMplyBee]{Colony-class}} or \code{\link[SIMplyBee]{MultiColony-class}}}

\item{FUN}{function, that calculates colony value from values of
colony members}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}

\item{...}{other arguments of \code{FUN}}
}
\value{
a matrix with one value or a row of values when \code{x} is
  \code{\link[SIMplyBee]{Colony-class}} and a row-named matrix when \code{x} is
  \code{\link[SIMplyBee]{MultiColony-class}}, where names are colony IDs
}
\description{
Level 0 function that calculate value(s) of a colony.
}
\section{Functions}{
\itemize{
\item \code{calcColonyPheno()}: Calculate colony phenotype value from caste individuals' phenotype values

\item \code{calcColonyGv()}: Calculate colony genetic value from caste individuals' genetic values

\item \code{calcColonyBv()}: Calculate colony breeding value from caste individuals' breeding values

\item \code{calcColonyDd()}: Calculate colony dominance value from caste individuals' dominance values

\item \code{calcColonyAa()}: Calculate colony epistasis value from caste individuals' epistasis value

}}
\examples{
founderGenomes <- quickHaplo(nInd = 5, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}

# Define two traits that collectively affect colony honey yield:
# 1) queen's effect on colony honey yield, say via pheromone secretion phenotype
# 2) workers' effect on colony honey yield, say via foraging ability phenotype
# The traits will have a negative genetic correlation of -0.5 and heritability
# of 0.25 (on an individual level)
nWorkers <- 10
mean <- c(10, 10 / nWorkers)
varA <- c(1, 1 / nWorkers)
corA <- matrix(data = c(
  1.0, -0.5,
  -0.5, 1.0
), nrow = 2, byrow = TRUE)
varE <- c(3, 3 / nWorkers)
varA / (varA + varE)
SP$addTraitADE(nQtlPerChr = 100,
               mean = mean,
               var = varA, corA = corA,
               meanDD = 0.1, varDD = 0.2, corD = corA,
               relAA = 0.1, corAA = corA)
SP$setVarE(varE = varE)

basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(x = basePop[1], nInd = 200)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create and cross Colony and MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(colony, nWorkers = nWorkers, nDrones = 3)
apiary <- createMultiColony(basePop[3:5], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(apiary, nWorkers = nWorkers, nDrones = 3)

# Colony value - shorthand version
# (using the default mapCasteToColony*() functions - you can provide yours instead!)
# Phenotype value
calcColonyPheno(colony)
calcColonyPheno(apiary)
# Genetic value
calcColonyGv(colony)
calcColonyGv(apiary)

# Colony value - long version
# (using the default mapCasteToColony*() function - you can provide yours instead!)
calcColonyValue(colony, FUN = mapCasteToColonyPheno)
calcColonyValue(apiary, FUN = mapCasteToColonyPheno)

# Colony value - long version - using a function stored in SimParamBee (SP)
# (using the default mapCasteToColony*() function - you can provide yours instead!)
SP$colonyValueFUN <- mapCasteToColonyPheno
calcColonyValue(colony)
calcColonyValue(apiary)

}
\seealso{
\code{\link[SIMplyBee]{mapCasteToColonyValue}} as an example of \code{FUN},
  \code{\link[SIMplyBee]{selectColonies}} for example for to select colonies based
  on these values, and
  \code{vignette(topic = "QuantitativeGenetics", package = "SIMplyBee")}
}
