% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L2_Colony.R
\name{replaceCastePop}
\alias{replaceCastePop}
\alias{replaceWorkers}
\alias{replaceDrones}
\alias{replaceVirginQueens}
\title{Replace a proportion of caste individuals with new ones}
\usage{
replaceCastePop(
  x,
  caste = NULL,
  p = 1,
  use = "rand",
  exact = TRUE,
  year = NULL,
  simParamBee = NULL
)

replaceWorkers(x, p = 1, use = "rand", exact = TRUE, simParamBee = NULL)

replaceDrones(x, p = 1, use = "rand", simParamBee = NULL)

replaceVirginQueens(x, p = 1, use = "rand", simParamBee = NULL)
}
\arguments{
\item{x}{\code{\link[SIMplyBee]{Colony-class}} or \code{\link[SIMplyBee]{MultiColony-class}}}

\item{caste}{character, "workers", "drones", or "virginQueens"}

\item{p}{numeric, proportion of caste individuals to be replaced with new ones;
if input is \code{\link[SIMplyBee]{MultiColony-class}},
the input could also be a vector of the same length as the number of colonies. If
a single value is provided, the same value will be applied to all the colonies}

\item{use}{character, all the options provided by \code{\link[AlphaSimR]{selectInd}} -
guides selection of caste individuals that stay when \code{p < 1}}

\item{exact}{logical, only relevant when adding workers - if the csd locus is turned
on and exact is \code{TRUE}, we replace the exact specified number of viable workers
(heterozygous at the csd locus). You probably want this set to TRUE since you want to
replace with the same number of workers.}

\item{year}{numeric, only relevant when replacing virgin queens,
year of birth for virgin queens}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}
}
\value{
\code{\link[SIMplyBee]{Colony-class}} or  or \code{\link[SIMplyBee]{MultiColony-class}} with
  replaced virgin queens
}
\description{
Level 2 function that replaces a proportion of caste individuals
  with new individuals from a Colony or MultiColony object. Useful after
  events like season change, swarming, supersedure, etc. due to the short life span
  honeybees.
}
\section{Functions}{
\itemize{
\item \code{replaceWorkers()}: Replaces some workers in a colony

\item \code{replaceDrones()}: Replaces some drones in a colony

\item \code{replaceVirginQueens()}: Replaces some virgin queens in a colony

}}
\examples{
founderGenomes <- quickHaplo(nInd = 5, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 100)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 5, nDrones = nFathersPoisson)

# Create and cross Colony and MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
apiary <- createMultiColony(basePop[4:5], n = 2)
apiary <- cross(apiary, drones = droneGroups[3:4])

# Add individuals
colony <- buildUp(colony, nWorkers = 5, nDrones = 2)
apiary <- buildUp(apiary, nWorkers = 5, nDrones = 2)

# Replace workers in a colony
getCasteId(colony, caste = "workers")
colony <- replaceCastePop(colony, caste = "workers", p = 0.5)
# You can also use an alias
replaceWorkers(colony, p = 0.5)
# Same aliases exist for all the castes!!!
getCasteId(colony, caste = "workers")

getCasteId(apiary, caste="workers")
apiary <- replaceWorkers(apiary, p = 0.5)
getCasteId(apiary, caste="workers")
}
