% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{GTFSagency}
\alias{GTFSagency}
\title{GTFS Agency table relevant to SIRI sample}
\format{A data frame with 1 observations on the following 7 variables:
\describe{
    \item{agency_id}{An ID that uniquely identifies a transit agency}
    \item{agency_name}{The agency_name field contains the full name of the transit agency.}
    \item{agency_url}{The URL of the transit agency.}
    \item{agency_timezone}{The timezone where the transit agency is located. }
    \item{agency_lang}{A two-letter ISO 639-1 code for the primary language used by this transit agency.}
    \item{agency_phone}{A single voice telephone number for the specified agency, NA in this case}
    \item{agency_fare_url}{The URL of a web page that allows a rider to purchase tickets or other fare instruments for that agency online.}
    }}
\source{
\url{https://developers.google.com/transit/gtfs/reference/#agencytxt}
}
\usage{
GTFSagency
}
\description{
Subset of the GTFS agency table for Israel for the SIRIsample data.
This is only a small subset of the Israeli GTFS agency table, extracted to be used with the SIRIsample data.
it shows only 1 agency since the SIRIsample data only includes 1 operator in the city of Be'er Sheva.
note that GTFS is a global standard and not all operators fill all of the columns.
}
\keyword{datasets}
