% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_cat.R
\name{DA.cat}
\alias{DA.cat}
\title{Estimation of single catalytic constant using the diffusion approximation}
\usage{
DA.cat(method = T, dat, enz, subs, MM, catal, nrepeat = 10000,
  jump = 1, burning = 0, catal_m_v = c(1, 10000), sig,
  scale_tun = 80)
}
\arguments{
\item{method}{method selection: T=TQ model, F=SQ model(default = T)}

\item{dat}{observed dataset ( time & trajectory columns)}

\item{enz}{enzyme concentration}

\item{subs}{substrate concentration}

\item{MM}{true value of MM constant}

\item{catal}{initial value of catalytic constant}

\item{nrepeat}{total number of iteration (default=10000)}

\item{jump}{length of distance (default =1)}

\item{burning}{lenth of burning period (default =0)}

\item{catal_m_v}{Catalytic prior gamma mean, variance(default=c(1,10000))}

\item{sig}{standard deviation of univariate Normal proposal distribution}

\item{scale_tun}{scale tunning constant for stochastic simulation}
}
\value{
A vector of posterior samples of catalytic constant
}
\description{
The function estimates single catalytic constant using single data set with
an initial enzyme concentrations and substrate concentration.
The diffusion approximation is utilized for the likelihood function.
}
\details{
The function DA.cat generates a set of MCMC simulation samples from
the conditional posterior distribution of catalytic constant of enzyme kinetics model.
As the catalytic constant is only parameter to be estimated in the function the user
should assign MM constant as well as initial enzyme concentration and
substrate concentration. The prior information for the parameter can be given.
The turning constant (scale_tun) and standard deviation (sig) can be set to controlled
proper mixing and acceptance ratio of the parameter from the conditional posterior
distribution. The posterior samples are only stored with fixed interval according to
set "jump" to reduce serial correlation. The initial iterations are removed for
convergence. The “burning” is set the length of initial iterations. The diffusion
approximation method is used for construction of the likelihood.
}
\examples{
\dontrun{
data('Chymo_low')
sk_DA=DA.cat(method=TRUE,dat=Chymo_low,enz=4.4e+7,subs = 4.4e+7,MM=4.4e+8,catal=0.05
                  ,nrepeat=10000,jump=1,burning = 0,catal_m_v=c(1,10000),sig=0.005)
}

}
