% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenBinaryFD.R
\name{GenBinaryFD}
\alias{GenBinaryFD}
\title{Generate binary functional data}
\usage{
GenBinaryFD(n, interval, sparse, regular, meanfun, score, eigfd)
}
\arguments{
\item{n}{An integer denoting the number of sample size.}

\item{interval}{A \code{vector} of length two denoting the supporting interval.}

\item{sparse}{A \code{vector} denoting the possible numbers of observation size. The elements are chosen with equal chance. The length of \code{sparse} must be one if \code{regular = TRUE}.}

\item{regular}{Logical; If \code{TRUE}, the observation grids are equally-spaced.}

\item{meanfun}{A function for the mean.}

\item{score}{A \emph{n} by \code{npc} \code{matrix} containing the FPC scores, where \code{npc} is the number of FPCs.}

\item{eigfd}{A \code{list} containing functional objects for the eigenfunctions.}
}
\value{
A \code{list} containing the following components:
\item{Lt}{A \code{list} of \emph{n} vectors, where \emph{n} is the sample size. Each entry contains the observation time in ascending order for each subject.}
\item{Lx}{A \code{list} of \emph{n} vectors, where \emph{n} is the sample size. Each entry contains vales of the latent process of each subject at the observation time correspond to \code{Lt}.}
\item{Ly}{A \code{list} of \emph{n} vectors, where \emph{n} is the sample size. Each entry contains the binary measurements of each subject at the observation time correspond to \code{Lt}.}
}
\description{
Generate binary functional data through latent process.
}
\examples{
n <- 100
npc <- 2
interval <- c(0, 10)
gridequal <- seq(0, 10, length.out = 51)
basis <- fda::create.bspline.basis(c(0, 10), nbasis = 13, norder = 4,
         breaks = seq(0, 10, length.out = 11))
meanfun <- function(t){2 * sin(pi * t/5)/sqrt(5)}
lambda_1 <- 3^2 #the first eigenvalue
lambda_2 <- 2^2 #the second eigenvalue
score <- cbind(rnorm(n, 0, sqrt(lambda_1)), rnorm(n, 0, sqrt(lambda_2)))
eigfun <- list()
eigfun[[1]] <- function(t){cos(pi * t/5)/sqrt(5)}
eigfun[[2]] <- function(t){sin(pi * t/5)/sqrt(5)}
eigfd <- list()
for(i in 1:npc){
  eigfd[[i]] <- fda::smooth.basis(gridequal, eigfun[[i]](gridequal), basis)$fd
}
DataNew <- GenBinaryFD(n, interval, sparse = 8:12, regular = FALSE,
           meanfun = meanfun, score, eigfd)


}
