% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLICER.R
\name{find_extreme_cells}
\alias{find_extreme_cells}
\title{Identify candidate start cells for the trajectory}
\usage{
find_extreme_cells(traj_graph, embedding)
}
\arguments{
\item{traj_graph}{Nearest neighbor graph built from LLE embedding}

\item{embedding}{Low-dimensional LLE embedding of cells}
}
\value{
Indices of potential starting cells
}
\description{
Plots the embedding generated by LLE and highlights
potential starting cells for the trajectory. The candidates
are chosen based on the longest shortest path through the
nearest neighbor graph.
}
\examples{
genes=1:200
cells=sample(1:500,30)
k=10
traj_lle = lle::lle(traj[cells,genes],m=2,k)$Y
traj_graph = conn_knn_graph(traj_lle,5)
find_extreme_cells(traj_graph,traj_lle)
}
