% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLICER.R
\name{process_distance}
\alias{process_distance}
\title{Determine the position of each cell within the trajectory}
\usage{
process_distance(traj_graph, start)
}
\arguments{
\item{traj_graph}{Nearest neighbor graph built from LLE embedding}

\item{start}{Index of starting cell}
}
\value{
Vector of distances
}
\description{
This function calculates the geodesic distance from the start
cell to each other cell. This value corresponds to the
distance a cell has migrated through the process described by
the cell trajectory.
}
\examples{
genes=1:200
cells=sample(1:500,30)
k=10
traj_lle = lle::lle(traj[cells,genes],m=2,k)$Y
traj_graph = conn_knn_graph(traj_lle,5)
start = 1
dists = process_distance(traj_graph,start)
}
