% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score.R
\name{score}
\alias{score}
\alias{score.GaussianSLOPE}
\alias{score.BinomialSLOPE}
\alias{score.MultinomialSLOPE}
\alias{score.PoissonSLOPE}
\title{Compute one of several loss metrics on a new data set}
\usage{
score(object, x, y, measure)

\method{score}{GaussianSLOPE}(object, x, y, measure = c("mse", "mae"))

\method{score}{BinomialSLOPE}(object, x, y, measure = c("mse", "mae", "deviance", "misclass", "auc"))

\method{score}{MultinomialSLOPE}(object, x, y, measure = c("mse", "mae", "deviance", "misclass"))

\method{score}{PoissonSLOPE}(object, x, y, measure = c("mse", "mae"))
}
\arguments{
\item{object}{an object of class \code{"SLOPE"}}

\item{x}{feature matrix}

\item{y}{response}

\item{measure}{type of target measure. \code{"mse"} returns mean squared error.
\code{"mae"} returns mean absolute error, \code{"misclass"} returns
misclassification rate, and \code{"auc"} returns area under the ROC curve.}
}
\value{
The measure along the regularization path depending on the
value in \code{measure}.
}
\description{
This function is a unified interface to return various types of loss for a
model fit with \code{\link[=SLOPE]{SLOPE()}}.
}
\examples{
x <- subset(infert, select = c("induced", "age", "pooled.stratum"))
y <- infert$case

fit <- SLOPE(x, y, family = "binomial")
score(fit, x, y, measure = "auc")
}
