% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SOAs.R
\name{SOAs}
\alias{SOAs}
\title{function to create SOAs of strength t with the GOA construction by He and Tang.}
\usage{
SOAs(
  oa,
  t = 3,
  m = NULL,
  noptim.rounds = 1,
  noptim.repeats = 1,
  optimize = TRUE,
  dmethod = "manhattan",
  p = 50
)
}
\arguments{
\item{oa}{matrix or data.frame that contains an ingoing symmetric OA. Levels must be denoted as 0 to s-1 or as 1 to s.}

\item{t}{the strength the SOA should have, can be 2, 3, 4, or 5. Must not
be larger than the strength of \code{oa}, but can be smaller. The resulting SOA will have s^t levels}

\item{m}{the requested number of columns (see details for permitted numbers of columns)}

\item{noptim.rounds}{the number of optimization rounds for each independent restart}

\item{noptim.repeats}{the number of independent restarts of optimizations with \code{noptim.rounds} rounds each}

\item{optimize}{logical, default \code{TRUE}; if \code{FALSE}, suppresses optimization}

\item{dmethod}{method for the calculation of \code{\link{phi_p}}, "manhattan" (default) or "euclidean"}

\item{p}{p for \code{\link{phi_p}} (the larger, the closer to maximin distance)}
}
\value{
matrix of class \code{SOA} with the attributes that are listed below. All attributes can be accessed using function \code{\link{attributes}}, or individual attributes can be accessed using function \code{\link{attr}}. These are the attributes:
\describe{
\item{type}{the type of array (\code{SOA} or \code{OSOA})}
\item{strength}{character string that gives the strength}
\item{phi_p}{the phi_p value (smaller=better)}
\item{optimized}{logical indicating whether optimization was applied}
\item{permpick}{matrix that lists the id numbers of the permutations used}
\item{perms2pickfrom}{optional element, when optimization was conducted: the
overall permutation list to which the numbers in permlist refer}
\item{call}{the call that created the object}
}
}
\description{
takes an OA(n,m,s,t) and creates an SOA(n,m',s^t',t') with t'<=t.
}
\details{
The resulting SOA will have at most m' columns in s^t levels and will be of
strength t. m'(m, t) is a function of the number of columns of \code{oa}
(denoted as m) and the strength t: m'(m,2)=m, m'(m,3)=m-1, m'(m,4)=floor(m/2),
m'(m,5)=floor((m-1)/2).

Suitable OAs for argument \code{oa} can e.g. be constructed with OA creation functions
from package \pkg{lhs} or can be obtained from arrays listed in R package \pkg{DoE.base}.
}
\examples{
aus <- SOAs(DoE.base::L27.3.4, optimize=FALSE)  ## t=3 is the default
dim(aus)
soacheck2D(aus, s=3, el=3) ## check for 2*
soacheck3D(aus, s=3, el=3) ## check for 3

aus2 <- SOAs(DoE.base::L27.3.4, t=2, optimize=FALSE)
## t can be smaller than the array strength
##     --> more columns with fewer levels each
dim(aus2)
soacheck2D(aus2, s=3, el=2, t=2) # check for 2
soacheck3D(aus2, s=3, el=2)      # t=3 is the default (check for 3-)
}
\references{
For full detail, see \code{\link{SOAs-package}}.

He and Tang (2013)\cr
Weng (2014)
}
\author{
Ulrike Groemping
}
