% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_wrapper.R
\name{convert_preva_to_intercept}
\alias{convert_preva_to_intercept}
\title{Convert the prevalence value to the intercept value beta0.}
\usage{
convert_preva_to_intercept(
  parameters,
  mode = "additive",
  covariate = "binary",
  seed = 123,
  B = 10000,
  searchSizeBeta0 = 8,
  searchSizeGamma0 = 8
)
}
\arguments{
\item{parameters}{A list of parameters that contains all the required parameters in the model. If response is "binary", this list needs to contain "prev" which denotes the prevalence of the disease (or case to control ratio for case-control sampling). If response is continuous, the list needs to contain "traitSD" and "traitMean" which represent the standard deviation and mean of the continuous trait.
If covariate is not "none", a parameter "gammaG" needs to be defined to capture the dependence between the SNP and the covariate (through linear regression model if covariate is continuous, and logistic model if covariate is binary). If covariate is "binary", list needs to contains "pE" that defines the frequency of the covariate. If it is continuous, list needs to contain "muE" and "sigmaE" to define
its mean and standard deviation. The MAF is defined as "pG", with HWE assumed to hold.}

\item{mode}{A string of either "additive", "dominant" or "recessive", indicating the genetic mode, by default is "additive".}

\item{covariate}{A string of either "binary", "continuous" or "none" indicating the type of covariate E in the model, by default is "binary".}

\item{seed}{An integer number that indicates the seed used for the simulation if needed, by default is 123.}

\item{B}{An integer number that indicates the number of simulated sample to use if needed, by default is 10000.}

\item{searchSizeBeta0}{The interval radius for the numerical search of beta0, by default is 8. Setting to higher values may solve some numerical problems at the cost of longer runtime.}

\item{searchSizeGamma0}{The interval radius for the numerical search of gamma0, by default is 8. Setting to higher values may solve some numerical problems at the cost of longer runtime.}
}
\value{
The corresponding gamma0, beta0 and residual variance of E (if applicable).
}
\description{
Convert the prevalence value to the intercept value beta0.
}
\examples{
convert_preva_to_intercept(parameters = list(preva = 0.2, betaG = 0.6, betaE = c(0.9),
gammaG = c(0.2), muE = c(0), sigmaE = c(1), pG = 0.3), covariate = "continuous")
}
