/*
 * Decompiled with CFR 0.152.
 */
package spotGui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FontUIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.apache.commons.lang.SystemUtils;
import spotGui.fileIO;
import spotGui.hlp;
import spotGui.tarFuncGenerator;

public class spotGuiMain {
    String SPOTGUIVERSION = "1.3";
    Properties setupProperties = new Properties();
    private boolean setupPropertieExist = false;
    private File pathFile_SetupProperties = new File("");
    private File path_JAR = new File("");
    private File pathFile_HelpPdf = new File("");
    private File pathFile_R = new File("");
    private File pathFile_ImportSettigns = new File("");
    private File pathFile_ExportSettigns = new File("");
    private File path_Project = new File("");
    private File pathFile_ProjectConf = new File("");
    private File pathFile_ProjectRoi = new File("");
    private File pathFile_AlgorithmScript = new File("");
    private File pathFile_APD = new File("");
    private File pathFile_LoadROI = new File("");
    private File pathFile_ReportScript = new File("");
    private File pathFCDefaultRPATH = new File("");
    private File pathFCDefaultImportSettigns = new File("");
    private File pathFCDefaultExportSettigns = new File("");
    private File pathFCDefaultCONFproject = new File("");
    private File pathFCDefaultCONFalgorithmScript = new File("");
    private File pathFCDefaultReportScript = new File("");
    private File pathFCDefaultAPD = new File("");
    private int roiTableMinDim = 1;
    private int roiTableMaxDim = 100;
    private int roiTableDimInit;
    private int roiTableDim = this.roiTableDimInit = 5;
    private String[] roiTableColumnNames = new String[]{"Parametername", "Lower bound", "Upper bound", "Datatype"};
    private String[] roiTableTypes = new String[]{"INT", "FLOAT", "FACTOR"};
    private String[][] roiTableData = new String[this.roiTableMaxDim][this.roiTableColumnNames.length];
    private String roiTableDefaultMinValue = "0";
    private String roiTableDefaultMaxValue = "10";
    private String roiTableDefaultTypeValue = this.roiTableTypes[1];
    private String conf_algPath = "";
    private String conf_algName = "";
    private String conf_algPdFile = "";
    private String conf_model = "";
    private String conf_design_type = "";
    private String conf_init_design_size = "";
    private String conf_seq_design_size = "";
    private String conf_auto_loop_steps = "";
    private String conf_auto_loop_nevals = "";
    private String relativePathFileString_algPath = "";
    private String relativePathFileString_algPd = "";
    private String sepLineSettings = "[---SETTINGSFILESEPARATOR---]";
    private String sepRoiFile = " ";
    private String reportFunction = "";
    private boolean confAPDSelectedCheck = false;
    private boolean confAPDExistCheck = false;
    boolean IS_OS_WINDOWS = false;
    boolean IS_OS_LINUX = false;
    boolean IS_OS_MAC = false;
    String FILE_SEPERATOR = "";
    String LINE_SEPERATOR = "";
    ImageIcon iconCheckValid = new ImageIcon(this.getClass().getResource("icon_check_valid.gif"));
    ImageIcon iconCheckInvalid = new ImageIcon(this.getClass().getResource("icon_check_invalid.gif"));
    ImageIcon iconCheckUnknown = new ImageIcon(this.getClass().getResource("icon_check_unknown.gif"));
    ImageIcon iconLogo = new ImageIcon(this.getClass().getResource("spotOfficial.jpg"));
    String[] designTypeStrings = new String[]{"spotCreateDesignBasicDoe", "spotCreateDesignDoeR3", "spotCreateDesignLhd", "spotCreateDesignLhs", "spotCreateDesignFrF2"};
    String[] modelStrings = new String[]{"spotPredictTree", "spotPredictRandomForest", "spotPredictRandomForestMlegp", "spotPredictLm", "spotPredictTgp", "spotPredictMlegp", "spotPredictForrester", "spotPredictGausspr", "spotPredictKsvm", "spotPredictPsvm", "spotPredictQrnn", "spotPredictEarth"};
    String[] algnameStrings = new String[]{"spotFuncStartBranin", "spotFuncStartSixHump", "spotFuncStartSphere", "spotAlgStartSann", "spotAlgStartEs"};
    String[] analyzeFunctionStrings = new String[]{"spotReportDefault", "spotReportSens", "spotReport3d", "spotReportContour"};
    private JFileChooser jFileChooser_importSettings;
    private JFileChooser jFileChooser_import2Settings;
    private JFileChooser jFileChooser_import3Settings;
    private JFileChooser jFileChooser_exportSettings;
    private JFileChooser jFileChooser_rPath;
    private JFileChooser jFileChooser_algorithmSelect;
    private JFileChooser jFileChooser_CONFprojectPath;
    private JFileChooser jFileChooser_APD;
    private FileFilter fileFilterExe = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().toLowerCase().endsWith(".exe");
        }

        @Override
        public String getDescription() {
            return "Executable files (*.exe)";
        }
    };
    private FileFilter fileFilterAlgo = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String tmp = f.getName().toLowerCase();
            return tmp.endsWith(".r") || tmp.endsWith(".bat") || tmp.endsWith(".sh");
        }

        @Override
        public String getDescription() {
            return "Algorithm script files (*.r, *.bat, *.sh)";
        }
    };
    private FileFilter fileFilterAll = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return !f.getName().isEmpty();
        }

        @Override
        public String getDescription() {
            return "All files (*.*)";
        }
    };
    private FileFilter fileFilterR = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().toLowerCase().endsWith(".r");
        }

        @Override
        public String getDescription() {
            return "R script files (*.r)";
        }
    };
    private FileFilter fileFilterROI = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().toLowerCase().endsWith(".roi");
        }

        @Override
        public String getDescription() {
            return "ROI files (*.roi)";
        }
    };
    private FileFilter fileFilterCONF = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().toLowerCase().endsWith(".conf");
        }

        @Override
        public String getDescription() {
            return "CONF files (*.conf)";
        }
    };
    private FileFilter fileFilterAPD = new FileFilter(){

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            return f.getName().toLowerCase().endsWith(".apd");
        }

        @Override
        public String getDescription() {
            return "Algorithm problem design files (*.apd)";
        }
    };
    boolean globalDEBUG;
    private JFrame jFrame;
    private JPanel jContentPane;
    private JTabbedPane jTabbedPaneMain;
    private JPanel jPanel_welcome;
    private JLabel jLabel_logo;
    private JPanel jPanel_algorithm;
    private JLabel jLabel_reportFunction;
    private JComboBox jComboBox_reportFunction;
    private JComboBox jComboBox_CONFalgname;
    private JLabel jLabel_CONFalgname;
    private JTextField jTextField_CONFalgPdFilePath;
    private JButton jButton_CONFalgPdFilePathBrowse;
    private JTextField jTextField_selectedAlgorithmScript;
    private JPanel jPanel4;
    private JButton jButton_algorithmPathBrowse;
    private JPanel jPanel_roi;
    private JScrollPane jScrollPane1;
    private JTable jTable_ROI;
    private JPanel jPanel11;
    private JTextField jTextField_ROIdim;
    private JSlider jSlider_ROIdim;
    private JPanel jPanel2;
    private JLabel jLabel_ROIdefaultType;
    private JLabel jLabel_ROIdefaultLow;
    private JLabel jLabel_ROIdefaultHigh;
    private JComboBox jComboBox_ROIdefaultType;
    private JTextField jTextField_ROIdefaultLow;
    private JTextField jTextField_ROIdefaultHigh;
    private JPanel jPanel_spoconf;
    private JScrollPane jScrollPane2;
    private JTextArea jTextArea_CONFadditional;
    private JPanel jPanel_CONFstep;
    private JLabel jLabel_CONFinitDesignPoints;
    private JTextField jTextField_CONFinitLhdPoints;
    private JComboBox jComboBox_CONFdesignType;
    private JLabel jLabel_CONFdesignType;
    private JPanel jPanel3;
    private JTextField jTextField_CONFautoLoopSteps;
    private JTextField jTextField_CONFautoLoopNEvals;
    private JLabel jLabel_CONFautoLoopSteps;
    private JLabel jLabel_CONFautoLoopNEvals;
    private JTextField jTextField_CONFseqDesignSize;
    private JLabel jLabel_CONFseqDesignSize;
    private JLabel jLabel_CONFmodel;
    private JComboBox jComboBox_CONFmodel;
    private JCheckBox jCheckBox_CONFadvanced;
    private JPanel jPanel_CONFproject;
    private JTextField jTextField_CONFprojectPath;
    private JButton jButton_CONFprojectPathBrowse;
    private JLabel jLabel_CONFprojectPath;
    private JTextField jTextField_CONFprojectPrefix;
    private JLabel jLabel_CONFprojectPrefix;
    private JCheckBox jCheckBox_CONFprojectPathSubfolder;
    private JPanel jPanel_run;
    private JPanel jPanel6;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel_checkSpotRun;
    private JLabel jLabel_checkSpotRun_algorithm;
    private JLabel jLabel_checkSpotRun_roiConfig;
    private JLabel jLabel_checkSpotRun_spoConfig;
    private JLabel jLabel_checkSpotRun_rPath;
    private JLabel jLabel_checkSpotRun_spoConfigFile;
    private JLabel jLabel_checkSpotRun_roiConfigFile;
    private JButton jButton_checkSpotRun;
    private JPanel jPanel1_SpotRun;
    private JLabel jLabel_taskSelect;
    private JComboBox jComboBox_taskSelect;
    private JButton jButton_spotRun;
    private JScrollPane jScrollPane3;
    private ColorPane jColorPane_spotRun;
    private ColorPane jColorPane_analyzeRun;
    private JPanel jPanel_analyze;
    private JScrollPane jScrollPane4;
    private JPanel jPanel_viewFiles;
    private JComboBox jComboBox_ViewRawFile;
    private JComboBox jComboBox_ViewPdfFile;
    private JButton jButton_viewRawFile;
    private JButton jButton_viewPdfFile;
    private JScrollPane jScrollPane5;
    private JEditorPane jJEditorPane_Intro;
    private JDialog jDialog_pathSetup;
    private JPanel jContentPane1;
    private JTextField jTextField_rPath;
    private JButton jButton_rPathBrowse;
    private JLabel jLabel_rPath;
    private JButton jButton_pathSetupCancel;
    private JButton jButton_savePathSetup;
    private JMenuBar jJMenuBar;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuItem exitMenuItem;
    private JMenuItem aboutMenuItem;
    private JDialog aboutDialog;
    private JPanel aboutContentPane;
    private JLabel aboutVersionLabel;
    private JMenuItem helpPdfMenuItem;
    private JMenuItem importMenuItem;
    private JMenuItem exportMenuItem;
    private JMenu toolsMenu;
    private JMenuItem funcGeneratorMenuItem;
    private JMenuItem setRPathMenuItem;
    private JPanel selectAlgorithmPanel;
    private JPanel selectApdPanel;
    private JPanel selectReportPanel;
    private JPanel autoConfigPanel;
    private JLabel tarDescriptionLabel;
    private JLabel repDescriptionLabel;
    private JLabel apdDescriptionLabel;
    private JMenuItem import2MenuItem;
    private JMenuItem import3MenuItem;

    public spotGuiMain() {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            Font defaultFont = new Font("Dialog", 0, 11);
            UIManager.put("TitledBorder.font", new FontUIResource(new Font("Dialog", 1, 11)));
            UIManager.put("Table.font", new FontUIResource(defaultFont));
            UIManager.put("Panel.font", new FontUIResource(defaultFont));
            UIManager.put("Label.font", new FontUIResource(defaultFont));
            UIManager.put("TextPane.font", new FontUIResource(defaultFont));
            UIManager.put("ScrollPane.font", new FontUIResource(defaultFont));
            UIManager.put("OptionPane.font", new FontUIResource(defaultFont));
            UIManager.put("EditorPane.font", new FontUIResource(defaultFont));
            UIManager.put("Tree.font", new FontUIResource(defaultFont));
            UIManager.put("TextField.font", new FontUIResource(defaultFont));
            UIManager.put("RadioButton.font", new FontUIResource(defaultFont));
            UIManager.put("MenuItem.font", new FontUIResource(defaultFont));
            UIManager.put("ComboBox.font", new FontUIResource(defaultFont));
            UIManager.put("ToolTip.font", new FontUIResource(defaultFont));
            UIManager.put("TextArea.font", new FontUIResource(defaultFont));
            UIManager.put("ProgressBar.font", new FontUIResource(defaultFont));
            UIManager.put("MenuBar.font", new FontUIResource(defaultFont));
            UIManager.put("ColorChooser.font", new FontUIResource(defaultFont));
            UIManager.put("ToolBar.font", new FontUIResource(defaultFont));
            UIManager.put("Text.font", new FontUIResource(defaultFont));
            UIManager.put("PopupMenu.font", new FontUIResource(defaultFont));
            UIManager.put("Menu.font", new FontUIResource(defaultFont));
            UIManager.put("Checkbox.font", new FontUIResource(defaultFont));
            UIManager.put("ToggleButton.font", new FontUIResource(defaultFont));
            UIManager.put("TableHeader.font", new FontUIResource(defaultFont));
            UIManager.put("PasswordField.font", new FontUIResource(defaultFont));
            UIManager.put("List.font", new FontUIResource(defaultFont));
            UIManager.put("Button.font", new FontUIResource(defaultFont));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.globalDEBUG = true;
        this.jFrame = null;
        this.jContentPane = null;
        this.jTabbedPaneMain = null;
        this.jPanel_welcome = null;
        this.jLabel_logo = null;
        this.jPanel_algorithm = null;
        this.jLabel_reportFunction = null;
        this.jComboBox_reportFunction = null;
        this.jComboBox_CONFalgname = null;
        this.jLabel_CONFalgname = null;
        this.jTextField_CONFalgPdFilePath = null;
        this.jButton_CONFalgPdFilePathBrowse = null;
        this.jTextField_selectedAlgorithmScript = null;
        this.jPanel4 = null;
        this.jButton_algorithmPathBrowse = null;
        this.jPanel_roi = null;
        this.jScrollPane1 = null;
        this.jTable_ROI = null;
        this.jPanel11 = null;
        this.jTextField_ROIdim = null;
        this.jSlider_ROIdim = null;
        this.jPanel2 = null;
        this.jLabel_ROIdefaultType = null;
        this.jLabel_ROIdefaultLow = null;
        this.jLabel_ROIdefaultHigh = null;
        this.jComboBox_ROIdefaultType = null;
        this.jTextField_ROIdefaultLow = null;
        this.jTextField_ROIdefaultHigh = null;
        this.jPanel_spoconf = null;
        this.jScrollPane2 = null;
        this.jTextArea_CONFadditional = null;
        this.jPanel_CONFstep = null;
        this.jLabel_CONFinitDesignPoints = null;
        this.jTextField_CONFinitLhdPoints = null;
        this.jComboBox_CONFdesignType = null;
        this.jLabel_CONFdesignType = null;
        this.jPanel3 = null;
        this.jTextField_CONFautoLoopSteps = null;
        this.jTextField_CONFautoLoopNEvals = null;
        this.jLabel_CONFautoLoopSteps = null;
        this.jLabel_CONFautoLoopNEvals = null;
        this.jTextField_CONFseqDesignSize = null;
        this.jLabel_CONFseqDesignSize = null;
        this.jLabel_CONFmodel = null;
        this.jComboBox_CONFmodel = null;
        this.jCheckBox_CONFadvanced = null;
        this.jPanel_CONFproject = null;
        this.jTextField_CONFprojectPath = null;
        this.jButton_CONFprojectPathBrowse = null;
        this.jLabel_CONFprojectPath = null;
        this.jTextField_CONFprojectPrefix = null;
        this.jLabel_CONFprojectPrefix = null;
        this.jCheckBox_CONFprojectPathSubfolder = null;
        this.jPanel_run = null;
        this.jPanel6 = null;
        this.jLabel1 = null;
        this.jLabel2 = null;
        this.jLabel3 = null;
        this.jPanel_checkSpotRun = null;
        this.jLabel_checkSpotRun_algorithm = null;
        this.jLabel_checkSpotRun_roiConfig = null;
        this.jLabel_checkSpotRun_spoConfig = null;
        this.jLabel_checkSpotRun_rPath = null;
        this.jLabel_checkSpotRun_spoConfigFile = null;
        this.jLabel_checkSpotRun_roiConfigFile = null;
        this.jButton_checkSpotRun = null;
        this.jPanel1_SpotRun = null;
        this.jLabel_taskSelect = null;
        this.jComboBox_taskSelect = null;
        this.jButton_spotRun = null;
        this.jScrollPane3 = null;
        this.jColorPane_spotRun = null;
        this.jColorPane_analyzeRun = null;
        this.jPanel_analyze = null;
        this.jScrollPane4 = null;
        this.jPanel_viewFiles = null;
        this.jComboBox_ViewRawFile = null;
        this.jComboBox_ViewPdfFile = null;
        this.jButton_viewRawFile = null;
        this.jButton_viewPdfFile = null;
        this.jScrollPane5 = null;
        this.jJEditorPane_Intro = null;
        this.jDialog_pathSetup = null;
        this.jContentPane1 = null;
        this.jTextField_rPath = null;
        this.jButton_rPathBrowse = null;
        this.jLabel_rPath = null;
        this.jButton_pathSetupCancel = null;
        this.jButton_savePathSetup = null;
        this.jJMenuBar = null;
        this.fileMenu = null;
        this.helpMenu = null;
        this.exitMenuItem = null;
        this.aboutMenuItem = null;
        this.aboutDialog = null;
        this.aboutContentPane = null;
        this.aboutVersionLabel = null;
        this.helpPdfMenuItem = null;
        this.importMenuItem = null;
        this.exportMenuItem = null;
        this.toolsMenu = null;
        this.funcGeneratorMenuItem = null;
        this.setRPathMenuItem = null;
        this.selectAlgorithmPanel = null;
        this.selectApdPanel = null;
        this.selectReportPanel = null;
        this.autoConfigPanel = null;
        this.tarDescriptionLabel = null;
        this.repDescriptionLabel = null;
        this.apdDescriptionLabel = null;
        this.import2MenuItem = null;
        this.import3MenuItem = null;
    }

    private JFrame getJFrame() {
        if (this.jFrame == null) {
            this.jFrame = new JFrame();
            this.jFrame.setDefaultCloseOperation(2);
            this.jFrame.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/spotGui/temp.gif")));
            this.jFrame.setJMenuBar(this.getJJMenuBar());
            this.jFrame.setContentPane(this.getJContentPane());
            this.jFrame.setTitle("Application");
            this.systemCheck();
            try {
                this.path_JAR = new File(URLDecoder.decode(new File(spotGuiMain.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent(), "ISO-8859-15"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.pathFile_HelpPdf = new File(String.valueOf(this.path_JAR.toString()) + this.FILE_SEPERATOR + "help.pdf");
            this.pathFile_SetupProperties = new File(String.valueOf(this.path_JAR.toString()) + this.FILE_SEPERATOR + "setup.cfg");
            if (this.globalDEBUG) {
                System.out.println("path_JAR: " + this.path_JAR.toString());
            }
            if (this.globalDEBUG) {
                System.out.println("pathFile_SetupProperties: " + this.pathFile_SetupProperties.toString());
            }
            if (this.globalDEBUG) {
                System.out.println("pathFileHelpPdf: " + this.pathFile_HelpPdf.toString());
            }
            if (!this.pathFile_HelpPdf.exists()) {
                System.err.println("Help PDF file (" + this.pathFile_HelpPdf.toString() + ") not found");
                this.helpPdfMenuItem.setEnabled(false);
            }
            this.loadPathSetup(this.pathFile_SetupProperties);
            Locale.setDefault(Locale.ENGLISH);
            JComponent.setDefaultLocale(Locale.ENGLISH);
            this.jFrame.setPreferredSize(new Dimension(530, 530));
            this.jFrame.setSize(530, 513);
            this.jFrame.setResizable(false);
            this.jFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    switch (e.getID()) {
                        case 201: {
                            int answer = JOptionPane.showConfirmDialog(spotGuiMain.this.jFrame, "All current settings will be lost. Are you sure?", "Exit", 0, 3);
                            if (answer == 0) {
                                System.exit(0);
                                break;
                            }
                            spotGuiMain.this.jFrame.setDefaultCloseOperation(0);
                            break;
                        }
                    }
                }
            });
            this.jFrame.setTitle("SPOT GUI " + this.SPOTGUIVERSION);
        }
        return this.jFrame;
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(null);
            this.jContentPane.add(this.getJTabbedPaneMain());
        }
        return this.jContentPane;
    }

    private JTabbedPane getJTabbedPaneMain() {
        if (this.jTabbedPaneMain == null) {
            this.jTabbedPaneMain = new JTabbedPane();
            this.jTabbedPaneMain.setFont(new Font("Dialog", 0, 12));
            this.jTabbedPaneMain.setSize(504, 451);
            this.jTabbedPaneMain.setLocation(new Point(8, 2));
            this.jTabbedPaneMain.addTab("Intro", new ImageIcon(this.getClass().getResource("/spotGui/icon_tab_welcome.gif")), this.getJPanel_welcome(), "Welcome to SPOT GUI");
            this.jTabbedPaneMain.addTab("Function select", new ImageIcon(this.getClass().getResource("/spotGui/icon_tab_algorithm.png")), this.getJPanel_algorithm(), "First step: Select your files");
            this.jTabbedPaneMain.addTab("ROI", new ImageIcon(this.getClass().getResource("/spotGui/icon_tab_roi.gif")), this.getJPanel_roi(), "Second step: Define your region of interest");
            this.jTabbedPaneMain.addTab("Config", new ImageIcon(this.getClass().getResource("/spotGui/icon_tab_conf.gif")), this.getJPanel_spoconf(), "Configuration: Define SPOT parameters");
            this.jTabbedPaneMain.addTab("Run", new ImageIcon(this.getClass().getResource("/spotGui/icon_tab_run.gif")), this.getJPanel_run(), "Get Results of your SPOT Run");
            this.jTabbedPaneMain.addTab("Results", new ImageIcon(this.getClass().getResource("/spotGui/icon_tab_analyse.gif")), this.getJPanel_analyze(), "Get Results of your SPOT Run");
            this.jTabbedPaneMain.setTabLayoutPolicy(1);
        }
        return this.jTabbedPaneMain;
    }

    private JPanel getJPanel_welcome() {
        if (this.jPanel_welcome == null) {
            this.jPanel_welcome = new JPanel();
            this.jPanel_welcome.setLayout(null);
            this.jPanel_welcome.add((Component)this.getJPanel4(), null);
        }
        return this.jPanel_welcome;
    }

    private JPanel getJPanel_algorithm() {
        if (this.jPanel_algorithm == null) {
            this.jPanel_algorithm = new JPanel();
            this.jPanel_algorithm.setLayout(null);
            this.jLabel_CONFalgname = new JLabel();
            this.jLabel_CONFalgname.setText("R Function which starts the algorithm:");
            this.jLabel_CONFalgname.setBounds(11, 152, 182, 14);
            this.jLabel_CONFalgname.setFont(new Font("Dialog", 0, 10));
            this.jLabel_reportFunction = new JLabel();
            this.jLabel_reportFunction.setText("R-Function which starts the report:");
            this.jLabel_reportFunction.setLayout(null);
            this.jLabel_reportFunction.setFont(new Font("Dialog", 0, 10));
            this.jLabel_reportFunction.setBounds(11, 81, 182, 14);
            this.jPanel_algorithm.add((Component)this.getSelectAlgorithmPanel(), null);
            this.jPanel_algorithm.add((Component)this.getSelectApdPanel(), null);
            this.jPanel_algorithm.add((Component)this.getSelectReportPanel(), null);
        }
        return this.jPanel_algorithm;
    }

    private JComboBox getJComboBox_reportFunction() {
        if (this.jComboBox_reportFunction == null) {
            this.jComboBox_reportFunction = new JComboBox();
            this.jComboBox_reportFunction.setBounds(201, 77, 280, 21);
            DefaultComboBoxModel<String> jComboBox_analyzeFunctionModel = new DefaultComboBoxModel<String>(this.analyzeFunctionStrings);
            this.jComboBox_reportFunction.setModel(jComboBox_analyzeFunctionModel);
        }
        return this.jComboBox_reportFunction;
    }

    private JComboBox getJComboBox_CONFalgname() {
        if (this.jComboBox_CONFalgname == null) {
            this.jComboBox_CONFalgname = new JComboBox();
            this.jComboBox_CONFalgname.setEnabled(true);
            this.jComboBox_CONFalgname.setBounds(201, 148, 280, 21);
            DefaultComboBoxModel<String> jComboBox_CONFalgnameModel = new DefaultComboBoxModel<String>(this.algnameStrings);
            this.jComboBox_CONFalgname.setModel(jComboBox_CONFalgnameModel);
        }
        return this.jComboBox_CONFalgname;
    }

    private JTextField getJTextField_CONFalgPdFilePath() {
        if (this.jTextField_CONFalgPdFilePath == null) {
            this.jTextField_CONFalgPdFilePath = new JTextField();
            this.jTextField_CONFalgPdFilePath.setEditable(false);
            this.jTextField_CONFalgPdFilePath.setBounds(new Rectangle(11, 64, 360, 20));
        }
        return this.jTextField_CONFalgPdFilePath;
    }

    private JButton getJButton_CONFalgPdFilePathBrowse() {
        if (this.jButton_CONFalgPdFilePathBrowse == null) {
            this.jButton_CONFalgPdFilePathBrowse = new JButton();
            this.jButton_CONFalgPdFilePathBrowse.setText("Browse");
            this.jButton_CONFalgPdFilePathBrowse.setBounds(new Rectangle(381, 62, 100, 22));
            this.jButton_CONFalgPdFilePathBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser apdFilePathFC = spotGuiMain.this.getJFileChooser_APD();
                    int ret = apdFilePathFC.showDialog(spotGuiMain.this.jButton_CONFalgPdFilePathBrowse.getParent(), "Select APD");
                    if (ret == 0) {
                        spotGuiMain.this.pathFile_APD = apdFilePathFC.getSelectedFile();
                        spotGuiMain.this.pathFCDefaultAPD = spotGuiMain.this.pathFile_APD;
                        spotGuiMain.this.jTextField_CONFalgPdFilePath.setText(spotGuiMain.this.pathFile_APD.toString());
                    }
                }
            });
        }
        return this.jButton_CONFalgPdFilePathBrowse;
    }

    private JTextField getJTextField_selectedAlgorithmScript() {
        if (this.jTextField_selectedAlgorithmScript == null) {
            this.jTextField_selectedAlgorithmScript = new JTextField();
            this.jTextField_selectedAlgorithmScript.setEditable(false);
            this.jTextField_selectedAlgorithmScript.setBounds(new Rectangle(11, 120, 360, 20));
        }
        return this.jTextField_selectedAlgorithmScript;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jPanel4 = new JPanel();
            this.jPanel4.setBorder(BorderFactory.createTitledBorder("Quick introduction"));
            this.jPanel4.setLayout(null);
            this.jPanel4.setBounds(5, 5, 490, 410);
            this.jPanel4.add((Component)this.getJScrollPane5(), null);
        }
        return this.jPanel4;
    }

    private JButton getJButton_algorithmPathBrowse() {
        if (this.jButton_algorithmPathBrowse == null) {
            this.jButton_algorithmPathBrowse = new JButton();
            this.jButton_algorithmPathBrowse.setText("Browse");
            this.jButton_algorithmPathBrowse.setBounds(new Rectangle(381, 118, 100, 22));
            this.jButton_algorithmPathBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser algoPathFC = spotGuiMain.this.getJFileChooser_algorithmSelect();
                    int ret = algoPathFC.showDialog(spotGuiMain.this.jButton_algorithmPathBrowse.getParent(), "Select script");
                    if (ret == 0) {
                        spotGuiMain.this.pathFCDefaultCONFalgorithmScript = algoPathFC.getSelectedFile();
                        spotGuiMain.this.pathFile_AlgorithmScript = spotGuiMain.this.pathFCDefaultCONFalgorithmScript;
                        spotGuiMain.this.jTextField_selectedAlgorithmScript.setText(spotGuiMain.this.pathFile_AlgorithmScript.toString());
                        String[] tmp = fileIO.readFuncFromRscript(algoPathFC.getSelectedFile());
                        if (tmp != null) {
                            String[] tmp1 = new String[tmp.length + 5];
                            int i = 0;
                            while (i < tmp.length) {
                                tmp1[i] = tmp[i];
                                ++i;
                            }
                            tmp1[tmp1.length - 5] = "spotFuncStartBranin";
                            tmp1[tmp1.length - 4] = "spotFuncStartSixHump";
                            tmp1[tmp1.length - 3] = "spotFuncStartSphere";
                            tmp1[tmp1.length - 2] = "spotAlgStartSann";
                            tmp1[tmp1.length - 1] = "spotAlgStartEs";
                            DefaultComboBoxModel<String> jComboBox_CONFalgnameModel = new DefaultComboBoxModel<String>(tmp1);
                            spotGuiMain.this.jComboBox_CONFalgname.setModel(jComboBox_CONFalgnameModel);
                            spotGuiMain.this.jComboBox_CONFalgname.setSelectedItem(null);
                        }
                    }
                }
            });
        }
        return this.jButton_algorithmPathBrowse;
    }

    private JPanel getJPanel_roi() {
        if (this.jPanel_roi == null) {
            this.jPanel_roi = new JPanel();
            this.jPanel_roi.setLayout(null);
            this.jPanel_roi.add((Component)this.getJScrollPane1(), null);
            this.jPanel_roi.add((Component)this.getJPanel11(), null);
            this.jPanel_roi.add((Component)this.getJPanel2(), null);
        }
        return this.jPanel_roi;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setBounds(9, 152, 486, 263);
            this.jScrollPane1.setViewportView(this.getJTable_ROI());
            this.jScrollPane1.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    spotGuiMain.this.jTable_ROI.repaint();
                }
            });
            this.jScrollPane1.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    spotGuiMain.this.jTable_ROI.repaint();
                }
            });
        }
        return this.jScrollPane1;
    }

    private JTable getJTable_ROI() {
        if (this.jTable_ROI == null) {
            this.jTable_ROI = new JTable();
            this.initTableData(this.roiTableDefaultMinValue, this.roiTableDefaultMaxValue, this.roiTableDefaultTypeValue);
            myTableModel myModel = new myTableModel();
            this.jTable_ROI = new JTable(myModel);
            JComboBox<String> comboBox = new JComboBox<String>();
            comboBox.setModel(new DefaultComboBoxModel<String>(this.roiTableTypes));
            this.jTable_ROI.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(comboBox));
            this.jTable_ROI.setSelectionMode(0);
            this.jTable_ROI.getTableHeader().setReorderingAllowed(false);
            Dimension d = this.jTable_ROI.getIntercellSpacing();
            this.jTable_ROI.setIntercellSpacing(new Dimension(d.width + 1, d.height + 1));
            this.jTable_ROI.setRowHeight(this.jTable_ROI.getRowHeight() + 1);
            DefaultTableCellRenderer renT = new DefaultTableCellRenderer();
            renT.setHorizontalAlignment(4);
            this.jTable_ROI.getColumn(this.roiTableColumnNames[1]).setCellRenderer(renT);
            this.jTable_ROI.getColumn(this.roiTableColumnNames[2]).setCellRenderer(renT);
        }
        return this.jTable_ROI;
    }

    private JPanel getJPanel11() {
        if (this.jPanel11 == null) {
            this.jPanel11 = new JPanel();
            this.jPanel11.add((Component)this.getJTextField_ROIdim(), null);
            this.jPanel11.add((Component)this.getJSlider_ROIdim(), null);
            this.jPanel11.setBounds(7, 5, 487, 60);
            this.jPanel11.setLayout(null);
            this.jPanel11.setBorder(BorderFactory.createTitledBorder("Count of parameters"));
        }
        return this.jPanel11;
    }

    private JTextField getJTextField_ROIdim() {
        if (this.jTextField_ROIdim == null) {
            this.jTextField_ROIdim = new JTextField();
            this.jTextField_ROIdim.setBounds(18, 22, 50, 25);
            this.jTextField_ROIdim.setText(Integer.toString(this.roiTableDimInit));
            this.jTextField_ROIdim.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int val = 0;
                    if (spotGuiMain.this.isRegExInt(spotGuiMain.this.jTextField_ROIdim.getText()) != null) {
                        val = Integer.valueOf(spotGuiMain.this.jTextField_ROIdim.getText());
                        if (val >= spotGuiMain.this.roiTableMinDim && val <= spotGuiMain.this.roiTableMaxDim) {
                            spotGuiMain.this.updateTableDim(val);
                        } else {
                            JOptionPane.showMessageDialog(spotGuiMain.this.jTextField_ROIdim.getParent(), "The value is out of range. The valid value range is defined from " + Integer.toString(spotGuiMain.this.roiTableMinDim) + " to " + Integer.toString(spotGuiMain.this.roiTableMaxDim) + "   (Invalid value was: " + val + ")", "Value error", 0);
                            spotGuiMain.this.jTextField_ROIdim.setText(Integer.toString(spotGuiMain.this.jSlider_ROIdim.getValue()));
                        }
                    } else {
                        JOptionPane.showMessageDialog(spotGuiMain.this.jTextField_ROIdim.getParent(), "Type of value have to be INT.   (Invalid value was: " + spotGuiMain.this.jTextField_ROIdim.getText() + ")", "Value type error", 0);
                        spotGuiMain.this.jTextField_ROIdim.setText(Integer.toString(spotGuiMain.this.jSlider_ROIdim.getValue()));
                    }
                }
            });
        }
        return this.jTextField_ROIdim;
    }

    private JSlider getJSlider_ROIdim() {
        if (this.jSlider_ROIdim == null) {
            this.jSlider_ROIdim = new JSlider();
            this.jSlider_ROIdim.setBounds(78, 22, 403, 25);
            this.jSlider_ROIdim.setMinimum(this.roiTableMinDim);
            this.jSlider_ROIdim.setMaximum(this.roiTableMaxDim);
            this.jSlider_ROIdim.setValue(this.roiTableDimInit);
            this.jSlider_ROIdim.setSnapToTicks(true);
            this.jSlider_ROIdim.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    int sliderValue = source.getValue();
                    spotGuiMain.this.jTextField_ROIdim.setText(String.valueOf(sliderValue));
                    if (!source.getValueIsAdjusting()) {
                        spotGuiMain.this.updateTableDim(sliderValue);
                    }
                }
            });
        }
        return this.jSlider_ROIdim;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jLabel_ROIdefaultHigh = new JLabel();
            this.jLabel_ROIdefaultHigh.setText("default upper bound:");
            this.jLabel_ROIdefaultHigh.setBounds(5, 51, 111, 14);
            this.jLabel_ROIdefaultHigh.setFont(new Font("Dialog", 0, 10));
            this.jLabel_ROIdefaultHigh.setHorizontalAlignment(4);
            this.jLabel_ROIdefaultLow = new JLabel();
            this.jLabel_ROIdefaultLow.setText("default lower bound:");
            this.jLabel_ROIdefaultLow.setBounds(5, 25, 111, 14);
            this.jLabel_ROIdefaultLow.setFont(new Font("Dialog", 0, 10));
            this.jLabel_ROIdefaultLow.setHorizontalAlignment(4);
            this.jLabel_ROIdefaultType = new JLabel();
            this.jLabel_ROIdefaultType.setText("default type:");
            this.jLabel_ROIdefaultType.setBounds(203, 25, 79, 14);
            this.jLabel_ROIdefaultType.setFont(new Font("Dialog", 0, 10));
            this.jLabel_ROIdefaultType.setHorizontalAlignment(4);
            this.jPanel2 = new JPanel();
            this.jPanel2.setBounds(7, 65, 487, 81);
            this.jPanel2.setLayout(null);
            this.jPanel2.setBorder(BorderFactory.createTitledBorder("Default values"));
            this.jPanel2.add((Component)this.jLabel_ROIdefaultType, null);
            this.jPanel2.add((Component)this.jLabel_ROIdefaultLow, null);
            this.jPanel2.add((Component)this.jLabel_ROIdefaultHigh, null);
            this.jPanel2.add((Component)this.getJComboBox_ROIdefaultType(), null);
            this.jPanel2.add((Component)this.getJTextField_ROIdefaultLow(), null);
            this.jPanel2.add((Component)this.getJTextField_ROIdefaultHigh(), null);
        }
        return this.jPanel2;
    }

    private JComboBox getJComboBox_ROIdefaultType() {
        if (this.jComboBox_ROIdefaultType == null) {
            this.jComboBox_ROIdefaultType = new JComboBox();
            this.jComboBox_ROIdefaultType.setModel(new DefaultComboBoxModel<String>(this.roiTableTypes));
            this.jComboBox_ROIdefaultType.setBounds(286, 22, 83, 20);
            this.jComboBox_ROIdefaultType.setSelectedIndex(1);
            this.jComboBox_ROIdefaultType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int answer = JOptionPane.showConfirmDialog(spotGuiMain.this.jComboBox_ROIdefaultType.getParent(), "All current values in the datatype column will be overwritten. Are you sure you want to go on?", "Overwrite tablecolumn with defined default value", 0, 3);
                    if (answer == 0) {
                        String val = spotGuiMain.this.jComboBox_ROIdefaultType.getSelectedItem().toString();
                        int i = 0;
                        while (i < spotGuiMain.this.roiTableMaxDim) {
                            spotGuiMain.this.jTable_ROI.setValueAt(val, i, 3);
                            ++i;
                        }
                        spotGuiMain.this.updateTableDim(spotGuiMain.this.roiTableDim);
                    }
                }
            });
        }
        return this.jComboBox_ROIdefaultType;
    }

    private JTextField getJTextField_ROIdefaultLow() {
        if (this.jTextField_ROIdefaultLow == null) {
            this.jTextField_ROIdefaultLow = new JTextField();
            this.jTextField_ROIdefaultLow.setText("0");
            this.jTextField_ROIdefaultLow.setBounds(120, 22, 83, 20);
            this.jTextField_ROIdefaultLow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String val = spotGuiMain.this.jTextField_ROIdefaultLow.getText();
                    if (spotGuiMain.this.isRegExFloat(val) != null || spotGuiMain.this.isRegExInt(val) != null || hlp.isRegExPosInf(val) || hlp.isRegExNegInf(val)) {
                        int answer = JOptionPane.showConfirmDialog(spotGuiMain.this.jTextField_ROIdefaultLow.getParent(), "All current values in the lower bound column will be overwritten. Are you sure you want to go on?", "Overwrite tablecolumn with defined default value", 0, 3);
                        if (answer == 0) {
                            int i = 0;
                            while (i < spotGuiMain.this.roiTableMaxDim) {
                                spotGuiMain.this.jTable_ROI.setValueAt(val, i, 1);
                                ++i;
                            }
                            spotGuiMain.this.updateTableDim(spotGuiMain.this.roiTableDim);
                            spotGuiMain.this.jTextField_ROIdefaultLow.setText((String)spotGuiMain.this.jTable_ROI.getValueAt(0, 1));
                        }
                    } else {
                        JOptionPane.showMessageDialog(spotGuiMain.this.jTextField_ROIdim.getParent(), "Type of value have to be INT or FLOAT. Other allowed values are: Inf and -Inf.   (Invalid value was: " + val.toString() + ")", "Value type error", 0);
                        spotGuiMain.this.jTextField_ROIdefaultLow.setText("");
                    }
                }
            });
        }
        return this.jTextField_ROIdefaultLow;
    }

    private JTextField getJTextField_ROIdefaultHigh() {
        if (this.jTextField_ROIdefaultHigh == null) {
            this.jTextField_ROIdefaultHigh = new JTextField();
            this.jTextField_ROIdefaultHigh.setText("10");
            this.jTextField_ROIdefaultHigh.setBounds(120, 48, 83, 20);
            this.jTextField_ROIdefaultHigh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String val = spotGuiMain.this.jTextField_ROIdefaultHigh.getText();
                    if (spotGuiMain.this.isRegExFloat(val) != null || spotGuiMain.this.isRegExInt(val) != null || hlp.isRegExPosInf(val) || hlp.isRegExNegInf(val)) {
                        int answer = JOptionPane.showConfirmDialog(spotGuiMain.this.jTextField_ROIdefaultHigh.getParent(), "All current values in the upper bound column will be overwritten. Are you sure you want to go on?", "Overwrite tablecolumn with defined default value", 0, 3);
                        if (answer == 0) {
                            int i = 0;
                            while (i < spotGuiMain.this.roiTableMaxDim) {
                                spotGuiMain.this.jTable_ROI.setValueAt(val, i, 2);
                                ++i;
                            }
                            spotGuiMain.this.updateTableDim(spotGuiMain.this.roiTableDim);
                            spotGuiMain.this.jTextField_ROIdefaultHigh.setText((String)spotGuiMain.this.jTable_ROI.getValueAt(0, 2));
                        }
                    } else {
                        JOptionPane.showMessageDialog(spotGuiMain.this.jTextField_ROIdim.getParent(), "Type of value have to be INT or FLOAT. Other allowed values are: Inf and -Inf.   (Invalid value was: " + val.toString() + ")", "Value type error", 0);
                        spotGuiMain.this.jTextField_ROIdefaultHigh.setText("");
                    }
                }
            });
        }
        return this.jTextField_ROIdefaultHigh;
    }

    private JPanel getJPanel_spoconf() {
        if (this.jPanel_spoconf == null) {
            this.jPanel_spoconf = new JPanel();
            this.jPanel_spoconf.setLayout(null);
            this.jPanel_spoconf.add((Component)this.getJScrollPane2(), null);
            this.jPanel_spoconf.add((Component)this.getJPanel_CONFstep(), null);
            this.jPanel_spoconf.add((Component)this.getJPanel3(), null);
            this.jPanel_spoconf.add((Component)this.getJCheckBox_CONFadvanced(), null);
            this.jPanel_spoconf.add((Component)this.getJPanel_CONFproject(), null);
            this.jPanel_spoconf.add((Component)this.getAutoConfigPanel(), null);
        }
        return this.jPanel_spoconf;
    }

    private JScrollPane getJScrollPane2() {
        if (this.jScrollPane2 == null) {
            this.jScrollPane2 = new JScrollPane();
            this.jScrollPane2.setBounds(110, 234, 381, 182);
            this.jScrollPane2.setViewportView(this.getJTextArea_CONFadditional());
            this.jScrollPane2.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    spotGuiMain.this.jTextArea_CONFadditional.repaint();
                }
            });
            this.jScrollPane2.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    spotGuiMain.this.jTextArea_CONFadditional.repaint();
                }
            });
        }
        return this.jScrollPane2;
    }

    private JTextArea getJTextArea_CONFadditional() {
        if (this.jTextArea_CONFadditional == null) {
            this.jTextArea_CONFadditional = new JTextArea();
            this.jTextArea_CONFadditional.setText("## initial\ninit.design.retries = 100;\n## sequential\nseq.design.func = \"spotCreateDesignLhs\";\nseq.design.oldBest.size = 0;\nseq.design.new.size = 2;\nseq.design.retries = 10;\nseq.transformation.func = I;\nseq.merge.func = mean;\n## overall\nspot.seed = 1000;\nspot.ocba  = F;\nio.verbosity = 3");
            this.jTextArea_CONFadditional.setCaretPosition(0);
            this.jTextArea_CONFadditional.setEnabled(false);
            this.jTextArea_CONFadditional.setFont(new Font("Dialog", 0, 13));
        }
        return this.jTextArea_CONFadditional;
    }

    private JPanel getJPanel_CONFstep() {
        if (this.jPanel_CONFstep == null) {
            this.jLabel_CONFdesignType = new JLabel();
            this.jLabel_CONFdesignType.setText("Design Function:");
            this.jLabel_CONFdesignType.setBounds(175, 20, 112, 16);
            this.jLabel_CONFdesignType.setHorizontalAlignment(4);
            this.jLabel_CONFinitDesignPoints = new JLabel();
            this.jLabel_CONFinitDesignPoints.setText("Design Size:");
            this.jLabel_CONFinitDesignPoints.setBounds(3, 20, 105, 16);
            this.jLabel_CONFinitDesignPoints.setHorizontalAlignment(4);
            this.jPanel_CONFstep = new JPanel();
            this.jPanel_CONFstep.setBounds(7, 81, 485, 45);
            this.jPanel_CONFstep.setBorder(BorderFactory.createTitledBorder("Initial config"));
            this.jPanel_CONFstep.setLayout(null);
            this.jPanel_CONFstep.add((Component)this.jLabel_CONFinitDesignPoints, null);
            this.jPanel_CONFstep.add((Component)this.getJTextField_CONFinitLhdPoints(), null);
            this.jPanel_CONFstep.add((Component)this.getJComboBox_CONFdesignType(), null);
            this.jPanel_CONFstep.add((Component)this.jLabel_CONFdesignType, null);
        }
        return this.jPanel_CONFstep;
    }

    private JTextField getJTextField_CONFinitLhdPoints() {
        if (this.jTextField_CONFinitLhdPoints == null) {
            this.jTextField_CONFinitLhdPoints = new JTextField();
            this.jTextField_CONFinitLhdPoints.setText("NA");
            this.jTextField_CONFinitLhdPoints.setBounds(110, 16, 60, 23);
        }
        return this.jTextField_CONFinitLhdPoints;
    }

    private JComboBox getJComboBox_CONFdesignType() {
        if (this.jComboBox_CONFdesignType == null) {
            this.jComboBox_CONFdesignType = new JComboBox();
            DefaultComboBoxModel<String> jComboBox_CONFdesignTypeModel = new DefaultComboBoxModel<String>(this.designTypeStrings);
            this.jComboBox_CONFdesignType.setModel(jComboBox_CONFdesignTypeModel);
            this.jComboBox_CONFdesignType.setSelectedIndex(2);
            this.jComboBox_CONFdesignType.setBounds(292, 16, 183, 23);
        }
        return this.jComboBox_CONFdesignType;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jLabel_CONFmodel = new JLabel();
            this.jLabel_CONFmodel.setText("Prediction Model:");
            this.jLabel_CONFmodel.setBounds(175, 22, 112, 16);
            this.jLabel_CONFmodel.setHorizontalAlignment(4);
            this.jLabel_CONFseqDesignSize = new JLabel();
            this.jLabel_CONFseqDesignSize.setText("Predicted Points:");
            this.jLabel_CONFseqDesignSize.setBounds(3, 22, 105, 16);
            this.jLabel_CONFseqDesignSize.setHorizontalAlignment(4);
            this.jLabel_CONFautoLoopNEvals = new JLabel();
            this.jLabel_CONFautoLoopNEvals.setText("Loop Evaluations:");
            this.jLabel_CONFautoLoopNEvals.setBounds(new Rectangle(204, 26, 113, 14));
            this.jLabel_CONFautoLoopNEvals.setHorizontalAlignment(4);
            this.jLabel_CONFautoLoopSteps = new JLabel();
            this.jLabel_CONFautoLoopSteps.setText("Loop Steps:");
            this.jLabel_CONFautoLoopSteps.setBounds(new Rectangle(9, 26, 87, 14));
            this.jLabel_CONFautoLoopSteps.setHorizontalAlignment(4);
            this.jPanel3 = new JPanel();
            this.jPanel3.setBounds(7, 126, 486, 49);
            this.jPanel3.setBorder(BorderFactory.createTitledBorder("Sequential config"));
            this.jPanel3.setLayout(null);
            this.jPanel3.add((Component)this.getJTextField_CONFseqDesignSize(), null);
            this.jPanel3.add((Component)this.jLabel_CONFseqDesignSize, null);
            this.jPanel3.add((Component)this.jLabel_CONFmodel, null);
            this.jPanel3.add((Component)this.getJComboBox_CONFmodel(), null);
        }
        return this.jPanel3;
    }

    private JTextField getJTextField_CONFautoLoopSteps() {
        if (this.jTextField_CONFautoLoopSteps == null) {
            this.jTextField_CONFautoLoopSteps = new JTextField();
            this.jTextField_CONFautoLoopSteps.setText("Inf");
            this.jTextField_CONFautoLoopSteps.setBounds(new Rectangle(100, 21, 87, 23));
        }
        return this.jTextField_CONFautoLoopSteps;
    }

    private JTextField getJTextField_CONFautoLoopNEvals() {
        if (this.jTextField_CONFautoLoopNEvals == null) {
            this.jTextField_CONFautoLoopNEvals = new JTextField();
            this.jTextField_CONFautoLoopNEvals.setText("100");
            this.jTextField_CONFautoLoopNEvals.setBounds(new Rectangle(321, 21, 87, 23));
        }
        return this.jTextField_CONFautoLoopNEvals;
    }

    private JTextField getJTextField_CONFseqDesignSize() {
        if (this.jTextField_CONFseqDesignSize == null) {
            this.jTextField_CONFseqDesignSize = new JTextField();
            this.jTextField_CONFseqDesignSize.setText("200");
            this.jTextField_CONFseqDesignSize.setBounds(110, 19, 60, 23);
        }
        return this.jTextField_CONFseqDesignSize;
    }

    private JComboBox getJComboBox_CONFmodel() {
        if (this.jComboBox_CONFmodel == null) {
            this.jComboBox_CONFmodel = new JComboBox();
            DefaultComboBoxModel<String> jComboBox_CONFmodelModel = new DefaultComboBoxModel<String>(this.modelStrings);
            this.jComboBox_CONFmodel.setModel(jComboBox_CONFmodelModel);
            this.jComboBox_CONFmodel.setSelectedIndex(0);
            this.jComboBox_CONFmodel.setBounds(292, 17, 183, 23);
        }
        return this.jComboBox_CONFmodel;
    }

    private JCheckBox getJCheckBox_CONFadvanced() {
        if (this.jCheckBox_CONFadvanced == null) {
            this.jCheckBox_CONFadvanced = new JCheckBox();
            this.jCheckBox_CONFadvanced.setText("<html>Enable<br>advanced<br>config<br>setup</html>");
            this.jCheckBox_CONFadvanced.setBounds(19, 289, 74, 103);
            this.jCheckBox_CONFadvanced.setHorizontalAlignment(0);
            this.jCheckBox_CONFadvanced.setFont(new Font("Dialog", 0, 11));
            this.jCheckBox_CONFadvanced.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (spotGuiMain.this.jCheckBox_CONFadvanced.isSelected()) {
                        spotGuiMain.this.jTextArea_CONFadditional.setEnabled(true);
                    } else {
                        spotGuiMain.this.jTextArea_CONFadditional.setEnabled(false);
                    }
                }
            });
        }
        return this.jCheckBox_CONFadvanced;
    }

    private JPanel getJPanel_CONFproject() {
        if (this.jPanel_CONFproject == null) {
            this.jLabel_CONFprojectPrefix = new JLabel();
            this.jLabel_CONFprojectPrefix.setText("Projectname:");
            this.jLabel_CONFprojectPrefix.setHorizontalAlignment(4);
            this.jLabel_CONFprojectPrefix.setBounds(265, 24, 78, 14);
            this.jLabel_CONFprojectPath = new JLabel();
            this.jLabel_CONFprojectPath.setText("Projectpath:");
            this.jLabel_CONFprojectPath.setHorizontalAlignment(4);
            this.jLabel_CONFprojectPath.setFont(new Font("Dialog", 0, 10));
            this.jLabel_CONFprojectPath.setBounds(17, 49, 62, 14);
            this.jPanel_CONFproject = new JPanel();
            this.jPanel_CONFproject.setBounds(7, 5, 485, 76);
            this.jPanel_CONFproject.setBorder(BorderFactory.createTitledBorder("Project config"));
            this.jPanel_CONFproject.setLayout(null);
            this.jPanel_CONFproject.add((Component)this.getJTextField_CONFprojectPath(), null);
            this.jPanel_CONFproject.add((Component)this.getJButton_CONFprojectPathBrowse(), null);
            this.jPanel_CONFproject.add((Component)this.jLabel_CONFprojectPath, null);
            this.jPanel_CONFproject.add((Component)this.getJTextField_CONFprojectPrefix(), null);
            this.jPanel_CONFproject.add((Component)this.jLabel_CONFprojectPrefix, null);
            this.jPanel_CONFproject.add((Component)this.getJCheckBox_CONFprojectPathSubfolder(), null);
        }
        return this.jPanel_CONFproject;
    }

    private JTextField getJTextField_CONFprojectPath() {
        if (this.jTextField_CONFprojectPath == null) {
            this.jTextField_CONFprojectPath = new JTextField();
            this.jTextField_CONFprojectPath.setEditable(false);
            this.jTextField_CONFprojectPath.setBounds(79, 46, 292, 20);
        }
        return this.jTextField_CONFprojectPath;
    }

    private JButton getJButton_CONFprojectPathBrowse() {
        if (this.jButton_CONFprojectPathBrowse == null) {
            this.jButton_CONFprojectPathBrowse = new JButton();
            this.jButton_CONFprojectPathBrowse.setText("Browse");
            this.jButton_CONFprojectPathBrowse.setBounds(377, 44, 91, 22);
            this.jButton_CONFprojectPathBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser projectPathFC = spotGuiMain.this.getJFileChooser_CONFprojectPath();
                    int ret = projectPathFC.showDialog(spotGuiMain.this.jButton_CONFprojectPathBrowse.getParent(), "Set project path");
                    if (ret == 0) {
                        spotGuiMain.this.pathFCDefaultCONFproject = projectPathFC.getSelectedFile();
                        if (spotGuiMain.this.jCheckBox_CONFprojectPathSubfolder.isSelected() && !spotGuiMain.this.jTextField_CONFprojectPrefix.getText().equals("") && hlp.validPref(spotGuiMain.this.jTextField_CONFprojectPrefix.getText())) {
                            spotGuiMain.this.jTextField_CONFprojectPath.setText(String.valueOf(projectPathFC.getSelectedFile().toString()) + spotGuiMain.this.FILE_SEPERATOR + spotGuiMain.this.jTextField_CONFprojectPrefix.getText());
                        } else {
                            spotGuiMain.this.jTextField_CONFprojectPath.setText(spotGuiMain.this.pathFCDefaultCONFproject.toString());
                        }
                        spotGuiMain.this.path_Project = new File(spotGuiMain.this.jTextField_CONFprojectPath.getText());
                    }
                }
            });
        }
        return this.jButton_CONFprojectPathBrowse;
    }

    private JTextField getJTextField_CONFprojectPrefix() {
        if (this.jTextField_CONFprojectPrefix == null) {
            this.jTextField_CONFprojectPrefix = new JTextField();
            this.jTextField_CONFprojectPrefix.setFont(new Font("Dialog", 1, 11));
            this.jTextField_CONFprojectPrefix.setText("demo0001");
            this.jTextField_CONFprojectPrefix.setBounds(349, 22, 119, 20);
            this.jTextField_CONFprojectPrefix.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (hlp.validPref(spotGuiMain.this.jTextField_CONFprojectPrefix.getText())) {
                        spotGuiMain.this.jTextField_CONFprojectPrefix.setBackground(Color.white);
                        if (spotGuiMain.this.jCheckBox_CONFprojectPathSubfolder.isSelected() && !spotGuiMain.this.jTextField_CONFprojectPath.getText().equals("")) {
                            spotGuiMain.this.jTextField_CONFprojectPath.setText(String.valueOf(spotGuiMain.this.pathFCDefaultCONFproject.toString()) + spotGuiMain.this.FILE_SEPERATOR + spotGuiMain.this.jTextField_CONFprojectPrefix.getText());
                        }
                    } else {
                        spotGuiMain.this.jTextField_CONFprojectPrefix.setBackground(Color.red);
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
            this.jTextField_CONFprojectPrefix.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (hlp.validPref(spotGuiMain.this.jTextField_CONFprojectPrefix.getText())) {
                        spotGuiMain.this.jTextField_CONFprojectPrefix.setBackground(Color.white);
                        spotGuiMain.this.path_Project = new File(spotGuiMain.this.jTextField_CONFprojectPath.getText());
                    } else {
                        JOptionPane.showMessageDialog(spotGuiMain.this.jTextField_CONFprojectPrefix.getParent(), "Wrong name format. Allowed characters are: A-Z, a-z, _ and 0-9. Note, that the name have to start with a letter. Please select a proper name.   (Invalid name is: \"" + spotGuiMain.this.jTextField_CONFprojectPrefix.getText() + "\")", "Value type error", 0);
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
        }
        return this.jTextField_CONFprojectPrefix;
    }

    private JCheckBox getJCheckBox_CONFprojectPathSubfolder() {
        if (this.jCheckBox_CONFprojectPathSubfolder == null) {
            this.jCheckBox_CONFprojectPathSubfolder = new JCheckBox();
            this.jCheckBox_CONFprojectPathSubfolder.setText("<html>Create subfolder for project</html>");
            this.jCheckBox_CONFprojectPathSubfolder.setFont(new Font("Dialog", 0, 10));
            this.jCheckBox_CONFprojectPathSubfolder.setBounds(13, 24, 171, 17);
            this.jCheckBox_CONFprojectPathSubfolder.setHorizontalAlignment(2);
            this.jCheckBox_CONFprojectPathSubfolder.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!spotGuiMain.this.jTextField_CONFprojectPath.getText().equals("")) {
                        if (spotGuiMain.this.jCheckBox_CONFprojectPathSubfolder.isSelected() && !spotGuiMain.this.path_Project.toString().equals("")) {
                            if (spotGuiMain.this.path_Project.toString().endsWith(spotGuiMain.this.FILE_SEPERATOR)) {
                                spotGuiMain.this.jTextField_CONFprojectPath.setText(String.valueOf(spotGuiMain.this.path_Project.toString()) + spotGuiMain.this.jTextField_CONFprojectPrefix.getText());
                                spotGuiMain.this.path_Project = new File(spotGuiMain.this.jTextField_CONFprojectPath.getText());
                            } else {
                                spotGuiMain.this.jTextField_CONFprojectPath.setText(String.valueOf(spotGuiMain.this.path_Project.toString()) + spotGuiMain.this.FILE_SEPERATOR + spotGuiMain.this.jTextField_CONFprojectPrefix.getText());
                                spotGuiMain.this.path_Project = new File(spotGuiMain.this.jTextField_CONFprojectPath.getText());
                            }
                        } else {
                            spotGuiMain.this.jTextField_CONFprojectPath.setText(spotGuiMain.this.pathFCDefaultCONFproject.toString());
                            spotGuiMain.this.path_Project = spotGuiMain.this.pathFCDefaultCONFproject;
                        }
                    }
                }
            });
        }
        return this.jCheckBox_CONFprojectPathSubfolder;
    }

    private JPanel getJPanel_run() {
        if (this.jPanel_run == null) {
            this.jPanel_run = new JPanel();
            this.jPanel_run.setLayout(null);
            this.jPanel_run.add((Component)this.getJPanel6(), null);
            this.jPanel_run.add((Component)this.getJPanel_checkSpotRun(), null);
            this.jPanel_run.add((Component)this.getJPanel1_SpotRun(), null);
            this.jPanel_run.add((Component)this.getJScrollPane3(), null);
        }
        return this.jPanel_run;
    }

    private JPanel getJPanel6() {
        if (this.jPanel6 == null) {
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("= invalid/error");
            this.jLabel3.setIcon(this.iconCheckInvalid);
            this.jLabel3.setBounds(266, 21, 118, 17);
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("= unchecked");
            this.jLabel2.setIcon(this.iconCheckUnknown);
            this.jLabel2.setBounds(141, 21, 119, 17);
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("= valid");
            this.jLabel1.setIcon(this.iconCheckValid);
            this.jLabel1.setBounds(17, 21, 118, 17);
            this.jPanel6 = new JPanel();
            this.jPanel6.setBorder(BorderFactory.createTitledBorder("Information"));
            this.jPanel6.setBounds(7, 232, 489, 51);
            this.jPanel6.setLayout(null);
            this.jPanel6.add((Component)this.jLabel1, null);
            this.jPanel6.add((Component)this.jLabel2, null);
            this.jPanel6.add((Component)this.jLabel3, null);
        }
        return this.jPanel6;
    }

    private JPanel getJPanel_checkSpotRun() {
        if (this.jPanel_checkSpotRun == null) {
            this.jLabel_checkSpotRun_roiConfigFile = new JLabel();
            this.jLabel_checkSpotRun_roiConfigFile.setText("Write ROI config file");
            this.jLabel_checkSpotRun_roiConfigFile.setIcon(this.iconCheckUnknown);
            this.jLabel_checkSpotRun_roiConfigFile.setBounds(156, 21, 131, 15);
            this.jLabel_checkSpotRun_spoConfigFile = new JLabel();
            this.jLabel_checkSpotRun_spoConfigFile.setText("Write SPO config file");
            this.jLabel_checkSpotRun_spoConfigFile.setIcon(this.iconCheckUnknown);
            this.jLabel_checkSpotRun_spoConfigFile.setBounds(156, 42, 131, 15);
            this.jLabel_checkSpotRun_rPath = new JLabel();
            this.jLabel_checkSpotRun_rPath.setText("R Path");
            this.jLabel_checkSpotRun_rPath.setIcon(this.iconCheckUnknown);
            this.jLabel_checkSpotRun_rPath.setBounds(13, 84, 131, 15);
            this.jLabel_checkSpotRun_spoConfig = new JLabel();
            this.jLabel_checkSpotRun_spoConfig.setText("SPO config");
            this.jLabel_checkSpotRun_spoConfig.setIcon(this.iconCheckUnknown);
            this.jLabel_checkSpotRun_spoConfig.setBounds(13, 63, 131, 15);
            this.jLabel_checkSpotRun_roiConfig = new JLabel();
            this.jLabel_checkSpotRun_roiConfig.setText("ROI config");
            this.jLabel_checkSpotRun_roiConfig.setIcon(this.iconCheckUnknown);
            this.jLabel_checkSpotRun_roiConfig.setBounds(13, 42, 131, 15);
            this.jLabel_checkSpotRun_algorithm = new JLabel();
            this.jLabel_checkSpotRun_algorithm.setText("Algorithm script");
            this.jLabel_checkSpotRun_algorithm.setIcon(this.iconCheckUnknown);
            this.jLabel_checkSpotRun_algorithm.setBounds(13, 21, 131, 15);
            this.jPanel_checkSpotRun = new JPanel();
            this.jPanel_checkSpotRun.setBounds(7, 283, 329, 132);
            this.jPanel_checkSpotRun.setBorder(BorderFactory.createTitledBorder("Check list"));
            this.jPanel_checkSpotRun.setLayout(null);
            this.jPanel_checkSpotRun.add((Component)this.jLabel_checkSpotRun_algorithm, null);
            this.jPanel_checkSpotRun.add((Component)this.jLabel_checkSpotRun_roiConfig, null);
            this.jPanel_checkSpotRun.add((Component)this.jLabel_checkSpotRun_spoConfig, null);
            this.jPanel_checkSpotRun.add((Component)this.jLabel_checkSpotRun_rPath, null);
            this.jPanel_checkSpotRun.add((Component)this.jLabel_checkSpotRun_spoConfigFile, null);
            this.jPanel_checkSpotRun.add((Component)this.jLabel_checkSpotRun_roiConfigFile, null);
            this.jPanel_checkSpotRun.add((Component)this.getJButton_checkSpotRun(), null);
        }
        return this.jPanel_checkSpotRun;
    }

    private JButton getJButton_checkSpotRun() {
        if (this.jButton_checkSpotRun == null) {
            this.jButton_checkSpotRun = new JButton();
            this.jButton_checkSpotRun.setText("<html><center>Check & write config files</center></html>");
            this.jButton_checkSpotRun.setBounds(185, 73, 117, 42);
            this.jButton_checkSpotRun.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (spotGuiMain.this.checkSPO() != 0) {
                        spotGuiMain.this.jLabel_taskSelect.setEnabled(false);
                        spotGuiMain.this.jComboBox_taskSelect.setEnabled(false);
                        spotGuiMain.this.jButton_spotRun.setEnabled(false);
                    } else {
                        spotGuiMain.this.jLabel_taskSelect.setEnabled(true);
                        spotGuiMain.this.jComboBox_taskSelect.setEnabled(true);
                        spotGuiMain.this.jButton_spotRun.setEnabled(true);
                    }
                }
            });
        }
        return this.jButton_checkSpotRun;
    }

    private JPanel getJPanel1_SpotRun() {
        if (this.jPanel1_SpotRun == null) {
            this.jLabel_taskSelect = new JLabel();
            this.jLabel_taskSelect.setText("Select Task:");
            this.jLabel_taskSelect.setBounds(17, 22, 94, 14);
            this.jLabel_taskSelect.setEnabled(false);
            this.jPanel1_SpotRun = new JPanel();
            this.jPanel1_SpotRun.setBounds(336, 283, 160, 132);
            this.jPanel1_SpotRun.setBorder(BorderFactory.createTitledBorder("Start SPOT"));
            this.jPanel1_SpotRun.setLayout(null);
            this.jPanel1_SpotRun.add((Component)this.jLabel_taskSelect, null);
            this.jPanel1_SpotRun.add((Component)this.getJComboBox_taskSelect(), null);
            this.jPanel1_SpotRun.add((Component)this.getJButton_spotRun(), null);
        }
        return this.jPanel1_SpotRun;
    }

    private JComboBox getJComboBox_taskSelect() {
        if (this.jComboBox_taskSelect == null) {
            this.jComboBox_taskSelect = new JComboBox();
            DefaultComboBoxModel<String> jComboBox_taskSelectModel = new DefaultComboBoxModel<String>(new String[]{"init", "run", "seq", "auto", "rep"});
            this.jComboBox_taskSelect.setModel(jComboBox_taskSelectModel);
            this.jComboBox_taskSelect.setBounds(17, 36, 117, 20);
            this.jComboBox_taskSelect.setEnabled(false);
            this.jComboBox_taskSelect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!spotGuiMain.this.jButton_spotRun.isEnabled()) {
                        spotGuiMain.this.jButton_spotRun.setEnabled(true);
                    }
                }
            });
        }
        return this.jComboBox_taskSelect;
    }

    private JButton getJButton_spotRun() {
        if (this.jButton_spotRun == null) {
            this.jButton_spotRun = new JButton();
            this.jButton_spotRun.setText("<html><center>Start SPOT</center></html>");
            this.jButton_spotRun.setBounds(17, 73, 117, 42);
            this.jButton_spotRun.setEnabled(false);
            this.jButton_spotRun.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String RscriptExe = hlp.strQuote(String.valueOf(spotGuiMain.this.pathFile_R.getParent()) + spotGuiMain.this.FILE_SEPERATOR + "Rscript.exe");
                    String confString = spotGuiMain.this.pathFile_ProjectConf.toString();
                    String taskString = spotGuiMain.this.jComboBox_taskSelect.getSelectedItem().toString();
                    String tempString1 = String.valueOf(spotGuiMain.this.path_Project.toString()) + spotGuiMain.this.FILE_SEPERATOR + spotGuiMain.this.jTextField_CONFprojectPrefix.getText() + ".R";
                    String tempString2 = String.valueOf(spotGuiMain.this.path_Project.toString()) + spotGuiMain.this.FILE_SEPERATOR + spotGuiMain.this.jTextField_CONFprojectPrefix.getText() + ".Rout";
                    String[] cmdWINDOWS = new String[]{"cmd", "/C", "start", "\"\"", "/wait", RscriptExe, hlp.strQuote(tempString1)};
                    String[] cmdLINUX = new String[]{"xterm", "-exec", "R --slave --args  <" + hlp.strQuote(tempString1)};
                    fileIO.writeRSpot(confString.replace('\\', '/'), taskString, tempString1, tempString2.replace('\\', '/'), spotGuiMain.this.pathFile_AlgorithmScript.toString().replace('\\', '/'));
                    String[] cmdCallString = spotGuiMain.this.IS_OS_WINDOWS ? cmdWINDOWS : (spotGuiMain.this.IS_OS_LINUX ? cmdLINUX : (spotGuiMain.this.IS_OS_MAC ? cmdLINUX : cmdLINUX));
                    spotGuiMain.this.jColorPane_spotRun.setText("");
                    spotGuiMain.this.jColorPane_spotRun.append(Color.blue, "[*** STARTING SPOT ***]");
                    spotGuiMain.this.jColorPane_spotRun.append(Color.blue, "\n\nExecuting command String[]:\n");
                    int j = 0;
                    while (j < cmdCallString.length) {
                        spotGuiMain.this.jColorPane_spotRun.append(Color.blue, "...cmd[" + j + "] = ");
                        spotGuiMain.this.jColorPane_spotRun.append(Color.black, String.valueOf(cmdCallString[j]) + "\n");
                        ++j;
                    }
                    spotGuiMain.this.jColorPane_spotRun.append(Color.blue, "\nSPOT task is starting now, please stand by and wait for SPOT to finish");
                    spotGuiMain.this.jButton_spotRun.setEnabled(false);
                    try {
                        Process p = Runtime.getRuntime().exec(cmdCallString);
                        p.waitFor();
                        StringBuffer contents = fileIO.getTxt(tempString2);
                        spotGuiMain.this.jColorPane_spotRun.append(Color.blue, "\n");
                        spotGuiMain.this.jColorPane_spotRun.append(Color.black, contents.toString());
                        spotGuiMain.this.jColorPane_spotRun.append(Color.blue, "\nThis SPOT task is finished");
                        spotGuiMain.this.jButton_spotRun.setEnabled(true);
                    }
                    catch (Exception err) {
                        err.printStackTrace();
                    }
                }
            });
        }
        return this.jButton_spotRun;
    }

    private JScrollPane getJScrollPane3() {
        if (this.jScrollPane3 == null) {
            this.jScrollPane3 = new JScrollPane();
            this.jScrollPane3.setBounds(9, 11, 486, 220);
            this.jScrollPane3.setEnabled(false);
            this.jScrollPane3.setAutoscrolls(true);
            this.jColorPane_spotRun = new ColorPane();
            this.jScrollPane3.setViewportView(this.jColorPane_spotRun);
            this.jColorPane_spotRun.setBounds(12, 12, 480, 220);
            this.jColorPane_spotRun.setEditable(false);
            this.jScrollPane3.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    spotGuiMain.this.jColorPane_spotRun.repaint();
                }
            });
            this.jScrollPane3.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    spotGuiMain.this.jColorPane_spotRun.repaint();
                }
            });
        }
        return this.jScrollPane3;
    }

    private JPanel getJPanel_analyze() {
        if (this.jPanel_analyze == null) {
            this.jPanel_analyze = new JPanel();
            this.jPanel_analyze.setLayout(null);
            this.jPanel_analyze.add((Component)this.getJScrollPane4(), null);
            this.jPanel_analyze.add((Component)this.getJPanel_viewFiles(), null);
        }
        return this.jPanel_analyze;
    }

    private JScrollPane getJScrollPane4() {
        if (this.jScrollPane4 == null) {
            this.jScrollPane4 = new JScrollPane();
            this.jScrollPane4.setBounds(9, 11, 486, 315);
            this.jScrollPane4.setEnabled(false);
            this.jScrollPane4.setAutoscrolls(true);
            this.jColorPane_analyzeRun = new ColorPane();
            this.jScrollPane4.setViewportView(this.jColorPane_analyzeRun);
            this.jColorPane_analyzeRun.setBounds(12, 12, 480, 220);
            this.jColorPane_analyzeRun.setEditable(false);
            this.jScrollPane4.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    spotGuiMain.this.jColorPane_analyzeRun.repaint();
                }
            });
            this.jScrollPane4.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    spotGuiMain.this.jColorPane_analyzeRun.repaint();
                }
            });
        }
        return this.jScrollPane4;
    }

    private JPanel getJPanel_viewFiles() {
        if (this.jPanel_viewFiles == null) {
            this.jPanel_viewFiles = new JPanel();
            this.jPanel_viewFiles.setBounds(7, 332, 485, 83);
            this.jPanel_viewFiles.setBorder(BorderFactory.createTitledBorder("View Project And Result Files"));
            this.jPanel_viewFiles.setLayout(null);
            this.jPanel_viewFiles.add((Component)this.getJComboBox_ViewRawFile(), null);
            this.jPanel_viewFiles.add((Component)this.getJComboBox_ViewPdfFile(), null);
            this.jPanel_viewFiles.add((Component)this.getJButton_viewRawFile(), null);
            this.jPanel_viewFiles.add((Component)this.getJButton_viewPdfFile(), null);
        }
        return this.jPanel_viewFiles;
    }

    private JComboBox getJComboBox_ViewRawFile() {
        if (this.jComboBox_ViewRawFile == null) {
            this.jComboBox_ViewRawFile = new JComboBox();
            DefaultComboBoxModel<String> Model_RawFiles = new DefaultComboBoxModel<String>(new String[]{".conf SPOT configuration", ".apd algorithm problem definition", ".roi region of interest", ".des experiment design", ".res list of results", ".bst list of best results", ".R script called by R to call SPOT", ".Rout logfile of the SPOT run, see report output here"});
            this.jComboBox_ViewRawFile.setModel(Model_RawFiles);
            this.jComboBox_ViewRawFile.setSelectedIndex(0);
            this.jComboBox_ViewRawFile.setBounds(159, 20, 309, 23);
        }
        return this.jComboBox_ViewRawFile;
    }

    private JComboBox getJComboBox_ViewPdfFile() {
        if (this.jComboBox_ViewPdfFile == null) {
            this.jComboBox_ViewPdfFile = new JComboBox();
            DefaultComboBoxModel<String> Model_PdfFiles = new DefaultComboBoxModel<String>(new String[]{"Final Report", "Ongoing Report"});
            this.jComboBox_ViewPdfFile.setModel(Model_PdfFiles);
            this.jComboBox_ViewPdfFile.setSelectedIndex(0);
            this.jComboBox_ViewPdfFile.setBounds(159, 50, 309, 23);
        }
        return this.jComboBox_ViewPdfFile;
    }

    private JButton getJButton_viewRawFile() {
        if (this.jButton_viewRawFile == null) {
            this.jButton_viewRawFile = new JButton();
            this.jButton_viewRawFile.setText("<html><center>View Raw File</center></html>");
            this.jButton_viewRawFile.setBounds(10, 20, 138, 23);
            this.jButton_viewRawFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String tarSuffix = ".conf";
                    switch (spotGuiMain.this.jComboBox_ViewRawFile.getSelectedIndex()) {
                        case 0: {
                            tarSuffix = ".conf";
                            break;
                        }
                        case 1: {
                            tarSuffix = ".apd";
                            break;
                        }
                        case 2: {
                            tarSuffix = ".roi";
                            break;
                        }
                        case 3: {
                            tarSuffix = ".des";
                            break;
                        }
                        case 4: {
                            tarSuffix = ".res";
                            break;
                        }
                        case 5: {
                            tarSuffix = ".bst";
                            break;
                        }
                        case 6: {
                            tarSuffix = ".R";
                            break;
                        }
                        case 7: {
                            tarSuffix = ".Rout";
                        }
                    }
                    String tarFile = "";
                    tarFile = tarSuffix.equals(".apd") ? spotGuiMain.this.jTextField_CONFalgPdFilePath.getText() : String.valueOf(spotGuiMain.this.path_Project.toString()) + spotGuiMain.this.FILE_SEPERATOR + spotGuiMain.this.jTextField_CONFprojectPrefix.getText() + tarSuffix;
                    if (new File(tarFile).exists()) {
                        StringBuffer contents = fileIO.getTxt(tarFile);
                        spotGuiMain.this.jColorPane_analyzeRun.setText("");
                        spotGuiMain.this.jColorPane_analyzeRun.append(Color.blue, "\nContent of file:" + tarFile);
                        spotGuiMain.this.jColorPane_analyzeRun.append(Color.blue, "\n\n");
                        spotGuiMain.this.jColorPane_analyzeRun.append(Color.black, contents.toString());
                        spotGuiMain.this.jColorPane_analyzeRun.append(Color.blue, "\nEnd of file: " + tarFile);
                    } else {
                        spotGuiMain.this.jColorPane_analyzeRun.setText("");
                        spotGuiMain.this.jColorPane_analyzeRun.append(Color.red, "\nFile does not exist: " + tarFile);
                    }
                }
            });
        }
        return this.jButton_viewRawFile;
    }

    private JButton getJButton_viewPdfFile() {
        if (this.jButton_viewPdfFile == null) {
            this.jButton_viewPdfFile = new JButton();
            this.jButton_viewPdfFile.setText("<html><center>View PDF File</center></html>");
            this.jButton_viewPdfFile.setBounds(10, 50, 138, 23);
            this.jButton_viewPdfFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String pdfFileString = "";
                    pdfFileString = spotGuiMain.this.jComboBox_ViewPdfFile.getSelectedIndex() == 1 ? String.valueOf(spotGuiMain.this.path_Project.toString()) + spotGuiMain.this.FILE_SEPERATOR + "Rplots.pdf" : String.valueOf(spotGuiMain.this.path_Project.toString()) + spotGuiMain.this.FILE_SEPERATOR + spotGuiMain.this.jTextField_CONFprojectPrefix.getText() + ".pdf";
                    File pdfFile = new File(pdfFileString);
                    if (pdfFile.exists()) {
                        try {
                            Desktop.getDesktop().browse(pdfFile.toURI());
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    } else {
                        spotGuiMain.this.jColorPane_analyzeRun.setText("");
                        spotGuiMain.this.jColorPane_analyzeRun.append(Color.red, "\nFile does not exist: " + pdfFileString);
                    }
                }
            });
        }
        return this.jButton_viewPdfFile;
    }

    private JScrollPane getJScrollPane5() {
        if (this.jScrollPane5 == null) {
            this.jScrollPane5 = new JScrollPane();
            this.jScrollPane5.setBounds(5, 20, 478, 380);
            this.jScrollPane5.setViewportView(this.getJJEditorPane_Intro());
        }
        return this.jScrollPane5;
    }

    private JEditorPane getJJEditorPane_Intro() {
        if (this.jJEditorPane_Intro == null) {
            this.jJEditorPane_Intro = new JEditorPane();
            this.jJEditorPane_Intro.setFont(new Font("Dialog", 0, 11));
            this.jJEditorPane_Intro.setContentType("text/html");
            this.jJEditorPane_Intro.setText("<html><h4>Welcome to SPOT GUI</h4>If this is your first time of use, you should read this carefully, to get an overview. With this graphical interface you can easily configure and start optimization runs via the software <i>SPOT (sequential parameter optimization toolbox)</i>. This GUI does not contain any optimization features itself, but it will help you to set up and archive own optimization projects for <i>SPOT</i> without creating the required configuration files manually. The tabs of this software represent the required steps for setting up and running a project: <br><br><b>1. <u>File select</u>:</b> In this tab you have to select files or functions for your optimization problem. Three files can, but do not have to be chosen. First you can choose a file that contains a call to your target Algorithm in R. Note that the algorithm script does not have to be the algorithm, which should be optimized, but can rather be an interface which will invoke the algorithm. Additionally you can choose an .apd File, which defines parameters of your algorithm, that will not be changed by <i>SPOT</i>, i.e. the problem definition.Finally you can choose one of the default report functions for the evaluation of your <i>SPOT</i> run. If you do not choose a file for your algorithm function, you can alternatively choose functions that are allready implemented in <i>SPOT</i>. This can be done with the drop down menues, regardless of the files chosen. <br><b>2. <u>ROI</u>:</b> Specify the name and range of the exogenous parameters which should be fit. <br><b>3. <u>Config</u>:</b> Set <i>SPOT</i> related options for the optimization run and project settings. <br><b>4. <u>Run</u>:</b> Check the whole configuration of your current project and finally start <i>SPOT</i> with one of the supplied tasks. You can choose a full automatic task as well, which will include all other tasks sequentially. <br><b>5. <u>Results</u>:</b>Here you can view the different results produced by <i>SPOT</i>, including textfiles and pdf figures. <br><br>When you first use <i>SPOT</i> you should load existing ROI and CONF files to get used to valid setups. To get further information for single configuration options, or a more detailed how-to manual, you can use the \"Help\" button.</html>");
            this.jJEditorPane_Intro.setCaretPosition(0);
            this.jJEditorPane_Intro.setPreferredSize(new Dimension(458, 392));
            this.jJEditorPane_Intro.setEditable(false);
        }
        return this.jJEditorPane_Intro;
    }

    private JDialog getJDialog1() {
        if (this.jDialog_pathSetup == null) {
            this.jDialog_pathSetup = new JDialog(this.getJFrame());
            this.jDialog_pathSetup.setSize(new Dimension(480, 140));
            this.jDialog_pathSetup.setContentPane(this.getJContentPane1());
            this.jDialog_pathSetup.setTitle("Setup: Path to R.exe");
        }
        if (!this.pathFile_SetupProperties.exists()) {
            this.jButton_savePathSetup.setEnabled(true);
        }
        return this.jDialog_pathSetup;
    }

    private JPanel getJContentPane1() {
        if (this.jContentPane1 == null) {
            this.jLabel_rPath = new JLabel();
            this.jLabel_rPath.setText("Filepath to R.exe (windows systems only):");
            this.jLabel_rPath.setBounds(8, 22, 359, 14);
            this.jContentPane1 = new JPanel();
            this.jContentPane1.setLayout(null);
            this.jContentPane1.add((Component)this.getJTextField_rPath(), null);
            this.jContentPane1.add((Component)this.getJButton_rPathBrowse(), null);
            this.jContentPane1.add((Component)this.jLabel_rPath, null);
            this.jContentPane1.add((Component)this.getJButton_pathSetupCancel(), null);
            this.jContentPane1.add((Component)this.getJButton_savePathSetup(), null);
            if (!this.IS_OS_WINDOWS) {
                this.jTextField_rPath.setEnabled(false);
                this.jButton_rPathBrowse.setEnabled(false);
                this.jLabel_rPath.setEnabled(false);
                this.jButton_savePathSetup.setEnabled(false);
            }
        }
        return this.jContentPane1;
    }

    private JTextField getJTextField_rPath() {
        if (this.jTextField_rPath == null) {
            this.jTextField_rPath = new JTextField();
            this.jTextField_rPath.setEditable(false);
            this.jTextField_rPath.setText(this.pathFile_R.toString());
            this.jTextField_rPath.setBounds(8, 36, 357, 20);
        }
        return this.jTextField_rPath;
    }

    private JButton getJButton_rPathBrowse() {
        if (this.jButton_rPathBrowse == null) {
            this.jButton_rPathBrowse = new JButton();
            this.jButton_rPathBrowse.setBounds(371, 35, 91, 22);
            this.jButton_rPathBrowse.setText("Browse");
            this.jButton_rPathBrowse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser rPathFC = spotGuiMain.this.getJFileChooser_rPath();
                    int ret = rPathFC.showDialog(spotGuiMain.this.jButton_rPathBrowse.getParent(), "Set R filepath");
                    if (ret == 0) {
                        if (rPathFC.getSelectedFile().getName().equalsIgnoreCase("R.exe")) {
                            spotGuiMain.this.pathFile_R = rPathFC.getSelectedFile();
                            spotGuiMain.this.pathFCDefaultRPATH = spotGuiMain.this.pathFile_R;
                            spotGuiMain.this.jTextField_rPath.setText(spotGuiMain.this.pathFile_R.toString());
                            spotGuiMain.this.jButton_savePathSetup.setEnabled(true);
                        } else {
                            JOptionPane.showMessageDialog(spotGuiMain.this.jButton_savePathSetup.getParent(), "R filepath is invalid. Please use the browse button to select valid path for R (R.exe)", "Path setup", 0);
                            spotGuiMain.this.jButton_savePathSetup.setEnabled(false);
                        }
                    }
                }
            });
        }
        return this.jButton_rPathBrowse;
    }

    private JButton getJButton_pathSetupCancel() {
        if (this.jButton_pathSetupCancel == null) {
            this.jButton_pathSetupCancel = new JButton();
            this.jButton_pathSetupCancel.setText("Cancel");
            this.jButton_pathSetupCancel.setBounds(350, 82, 112, 23);
            this.jButton_pathSetupCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (spotGuiMain.this.setupPropertieExist) {
                        String old_pathR = spotGuiMain.this.setupProperties.getProperty("pathFile_R");
                        if (!old_pathR.equals(spotGuiMain.this.pathFile_R.toString())) {
                            spotGuiMain.this.pathFile_R = new File(old_pathR);
                            spotGuiMain.this.pathFCDefaultRPATH = spotGuiMain.this.pathFile_R;
                            spotGuiMain.this.jTextField_rPath.setText(spotGuiMain.this.pathFile_R.toString());
                        }
                        spotGuiMain.this.loadPathSetup(spotGuiMain.this.pathFile_SetupProperties);
                        spotGuiMain.this.jTextField_rPath.setText(spotGuiMain.this.pathFile_R.toString());
                    } else {
                        spotGuiMain.this.jTextField_rPath.setText("");
                    }
                    spotGuiMain.this.jButton_savePathSetup.setEnabled(false);
                    spotGuiMain.this.jDialog_pathSetup.dispose();
                }
            });
        }
        return this.jButton_pathSetupCancel;
    }

    private JButton getJButton_savePathSetup() {
        if (this.jButton_savePathSetup == null) {
            this.jButton_savePathSetup = new JButton();
            this.jButton_savePathSetup.setText("Save path setup");
            this.jButton_savePathSetup.setBounds(185, 82, 155, 23);
            this.jButton_savePathSetup.setEnabled(false);
            this.jButton_savePathSetup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    spotGuiMain.this.setupProperties.setProperty("pathFile_R", spotGuiMain.this.pathFile_R.toString());
                    try {
                        spotGuiMain.this.setupProperties.storeToXML(new FileOutputStream(spotGuiMain.this.pathFile_SetupProperties), null);
                    }
                    catch (FileNotFoundException exc) {
                        exc.printStackTrace();
                    }
                    catch (IOException exc) {
                        exc.printStackTrace();
                    }
                    spotGuiMain.this.loadPathSetup(spotGuiMain.this.pathFile_SetupProperties);
                    spotGuiMain.this.jButton_savePathSetup.setEnabled(false);
                    spotGuiMain.this.jDialog_pathSetup.dispose();
                }
            });
        }
        return this.jButton_savePathSetup;
    }

    private JMenuBar getJJMenuBar() {
        if (this.jJMenuBar == null) {
            this.jJMenuBar = new JMenuBar();
            this.jJMenuBar.add(this.getFileMenu());
            this.jJMenuBar.add(this.getToolsMenu());
            this.jJMenuBar.add(this.getHelpMenu());
        }
        return this.jJMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.add(this.getImportMenuItem());
            this.fileMenu.add(this.getImport2MenuItem());
            this.fileMenu.add(this.getImport3MenuItem());
            this.fileMenu.add(this.getExportMenuItem());
            this.fileMenu.add(this.getSetRPathMenuItem());
            this.fileMenu.add(this.getExitMenuItem());
        }
        return this.fileMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            this.helpMenu.setText("Help");
            this.helpMenu.add(this.getAboutMenuItem());
            this.helpMenu.add(this.getHelpPdfMenuItem());
        }
        return this.helpMenu;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            this.exitMenuItem.setText("Exit");
            this.exitMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int answer = JOptionPane.showConfirmDialog(spotGuiMain.this.exitMenuItem.getParent(), "All current settings will be lost. Are you sure?", "Exit", 0, 3);
                    if (answer == 0) {
                        System.exit(0);
                    }
                }
            });
        }
        return this.exitMenuItem;
    }

    private JMenuItem getAboutMenuItem() {
        if (this.aboutMenuItem == null) {
            this.aboutMenuItem = new JMenuItem();
            this.aboutMenuItem.setText("About");
            this.aboutMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JDialog aboutDialog = spotGuiMain.this.getAboutDialog();
                    aboutDialog.pack();
                    Point loc = spotGuiMain.this.getJFrame().getLocation();
                    loc.translate(20, 20);
                    aboutDialog.setLocation(loc);
                    aboutDialog.setVisible(true);
                }
            });
        }
        return this.aboutMenuItem;
    }

    private JDialog getAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new JDialog((Frame)this.getJFrame(), true);
            this.aboutDialog.setTitle("About");
            this.aboutDialog.setContentPane(this.getAboutContentPane());
        }
        return this.aboutDialog;
    }

    private JPanel getAboutContentPane() {
        if (this.aboutContentPane == null) {
            this.aboutContentPane = new JPanel();
            this.aboutContentPane.setLayout(new BorderLayout());
            this.aboutContentPane.add((Component)this.getAboutVersionLabel(), "Center");
            this.jLabel_logo = new JLabel();
            this.jLabel_logo.setBounds(17, 139, 455, 254);
            this.jLabel_logo.setIcon(this.iconLogo);
            this.jLabel_logo.setHorizontalAlignment(0);
            this.aboutContentPane.add((Component)this.jLabel_logo, "North");
        }
        return this.aboutContentPane;
    }

    private JLabel getAboutVersionLabel() {
        if (this.aboutVersionLabel == null) {
            this.aboutVersionLabel = new JLabel();
            this.aboutVersionLabel.setText("<html><center><h3>SPOT GUI (" + this.SPOTGUIVERSION + ")</h3>A graphical user interface for the sequential parameter optimization toolbox <i>SPOT</i><br>This software has been developed in the context of a diploma thesis.<br><br><i>Authors: Tobias Zimmer, Martin Zaefferer</i></center></html>");
            this.aboutVersionLabel.setHorizontalAlignment(0);
        }
        return this.aboutVersionLabel;
    }

    private JMenuItem getHelpPdfMenuItem() {
        if (this.helpPdfMenuItem == null) {
            this.helpPdfMenuItem = new JMenuItem();
            this.helpPdfMenuItem.setText("PDF Manual");
            this.helpPdfMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Desktop.getDesktop().browse(spotGuiMain.this.pathFile_HelpPdf.toURI());
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            });
        }
        return this.helpPdfMenuItem;
    }

    private JMenuItem getImportMenuItem() {
        if (this.importMenuItem == null) {
            this.importMenuItem = new JMenuItem();
            this.importMenuItem.setText("Import Configuration (.conf)");
            this.importMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser importSettingsFC;
                    int ret;
                    int answer = JOptionPane.showConfirmDialog(spotGuiMain.this.importMenuItem.getParent(), "Your current .conf Settings will be overwritten. Are you sure you want to go on?", "Import settings from file", 0, 3);
                    if (answer == 0 && (ret = (importSettingsFC = spotGuiMain.this.getJFileChooser_importSettings()).showDialog(spotGuiMain.this.importMenuItem.getParent(), "Import")) == 0) {
                        File chosenFile = new File("");
                        chosenFile = importSettingsFC.getSelectedFile();
                        spotGuiMain.this.pathFCDefaultImportSettigns = chosenFile.getParentFile();
                        if (chosenFile.toString().toLowerCase().endsWith(".conf")) {
                            spotGuiMain.this.pathFile_ProjectConf = chosenFile;
                            if (spotGuiMain.this.makeStringListToConfVal(fileIO.readToStrList(spotGuiMain.this.pathFile_ProjectConf)) != 0) {
                                JOptionPane.showMessageDialog(spotGuiMain.this.importMenuItem.getParent(), "Error: CONF load failed.", "Load failed", 0);
                            } else {
                                spotGuiMain.this.loadConfValues(spotGuiMain.this.pathFile_ProjectConf);
                                spotGuiMain.this.jCheckBox_CONFprojectPathSubfolder.setSelected(false);
                            }
                        }
                    }
                }
            });
        }
        return this.importMenuItem;
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String tmp = f.getName().toLowerCase();
        return tmp.endsWith(".setting") || tmp.endsWith(".roi") || tmp.endsWith(".conf");
    }

    public String getDescription() {
        return "Importable files (*.setting, *.roi, *.conf)";
    }

    private JMenuItem getExportMenuItem() {
        if (this.exportMenuItem == null) {
            this.exportMenuItem = new JMenuItem();
            this.exportMenuItem.setText("Export (.setting)");
            this.exportMenuItem.setEnabled(false);
            this.exportMenuItem.setVisible(false);
            this.exportMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser exportSettingsFC = spotGuiMain.this.getJFileChooser_exportSettings();
                    int ret = exportSettingsFC.showDialog(spotGuiMain.this.exportMenuItem.getParent(), "Export");
                    if (ret == 0) {
                        spotGuiMain.this.pathFCDefaultExportSettigns = exportSettingsFC.getSelectedFile();
                        if (!spotGuiMain.this.pathFCDefaultExportSettigns.toString().toLowerCase().endsWith(".setting")) {
                            spotGuiMain.this.pathFCDefaultExportSettigns = new File(String.valueOf(spotGuiMain.this.pathFCDefaultExportSettigns.toString()) + ".setting");
                        }
                        if (spotGuiMain.this.exportSetting(spotGuiMain.this.pathFCDefaultExportSettigns) != 0) {
                            JOptionPane.showMessageDialog(spotGuiMain.this.exportMenuItem.getParent(), "Error: Export failed.", "Export failed", 0);
                            spotGuiMain.this.pathFCDefaultExportSettigns = spotGuiMain.this.pathFile_ExportSettigns;
                        } else {
                            spotGuiMain.this.pathFile_ExportSettigns = spotGuiMain.this.pathFCDefaultExportSettigns;
                        }
                    }
                }
            });
        }
        return this.exportMenuItem;
    }

    private JMenu getToolsMenu() {
        if (this.toolsMenu == null) {
            this.toolsMenu = new JMenu();
            this.toolsMenu.setText("Tools");
            this.toolsMenu.add(this.getFuncGeneratorMenuItem());
        }
        return this.toolsMenu;
    }

    private JMenuItem getFuncGeneratorMenuItem() {
        if (this.funcGeneratorMenuItem == null) {
            this.funcGeneratorMenuItem = new JMenuItem();
            this.funcGeneratorMenuItem.setText("Target Function Generator");
            this.funcGeneratorMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String[] callArgs = new String[]{"cmd", "/C", "start", "\"\"", "/wait"};
                    tarFuncGenerator.main(callArgs);
                }
            });
        }
        return this.funcGeneratorMenuItem;
    }

    private JMenuItem getSetRPathMenuItem() {
        if (this.setRPathMenuItem == null) {
            this.setRPathMenuItem = new JMenuItem();
            this.setRPathMenuItem.setText("Path Setup");
            this.setRPathMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JDialog pathSetupJD = spotGuiMain.this.getJDialog1();
                    pathSetupJD.setLocationRelativeTo(spotGuiMain.this.setRPathMenuItem.getParent());
                    pathSetupJD.setVisible(true);
                }
            });
        }
        return this.setRPathMenuItem;
    }

    private JPanel getSelectAlgorithmPanel() {
        if (this.selectAlgorithmPanel == null) {
            this.tarDescriptionLabel = new JLabel();
            this.tarDescriptionLabel.setBounds(new Rectangle(13, 17, 462, 92));
            this.tarDescriptionLabel.setText("<html>Please select a target function. You can either choose an internal function from the dropdown list, or first select a file where your custom function is stored. This has to be an .R script. Then select the name of the function from the dropdown list. However it has to be prepared for use with SPOT. To create your own functions easily use the function generator in the \"Tools\" Menu.</html>");
            this.selectAlgorithmPanel = new JPanel();
            this.selectAlgorithmPanel.setBorder(BorderFactory.createTitledBorder("Target Function"));
            this.selectAlgorithmPanel.setLayout(null);
            this.selectAlgorithmPanel.setBounds(new Rectangle(5, 5, 490, 175));
            this.selectAlgorithmPanel.add((Component)this.getJComboBox_CONFalgname(), null);
            this.selectAlgorithmPanel.add((Component)this.jLabel_CONFalgname, null);
            this.selectAlgorithmPanel.add((Component)this.getJTextField_selectedAlgorithmScript(), null);
            this.selectAlgorithmPanel.add((Component)this.getJButton_algorithmPathBrowse(), null);
            this.selectAlgorithmPanel.add((Component)this.tarDescriptionLabel, null);
        }
        return this.selectAlgorithmPanel;
    }

    private JPanel getSelectApdPanel() {
        if (this.selectApdPanel == null) {
            this.apdDescriptionLabel = new JLabel();
            this.apdDescriptionLabel.setBounds(new Rectangle(11, 13, 471, 59));
            this.apdDescriptionLabel.setText("<html>Choose an APD File here. Not mandatory, unless your custom target function requests it.</html>");
            this.selectApdPanel = new JPanel();
            this.selectApdPanel.setBorder(BorderFactory.createTitledBorder("Algorithm Problem Definition"));
            this.selectApdPanel.setLayout(null);
            this.selectApdPanel.setBounds(new Rectangle(5, 180, 490, 110));
            this.selectApdPanel.add((Component)this.getJTextField_CONFalgPdFilePath(), null);
            this.selectApdPanel.add((Component)this.getJButton_CONFalgPdFilePathBrowse(), null);
            this.selectApdPanel.add((Component)this.apdDescriptionLabel, null);
        }
        return this.selectApdPanel;
    }

    private JPanel getSelectReportPanel() {
        if (this.selectReportPanel == null) {
            this.repDescriptionLabel = new JLabel();
            this.repDescriptionLabel.setBounds(new Rectangle(15, 22, 465, 28));
            this.repDescriptionLabel.setText("<html>You can choose one of SPOTs default report functions here, simply use the dropdown menu. Note that the 3d Report will not work properly from within the spotGUI.</html>");
            this.selectReportPanel = new JPanel();
            this.selectReportPanel.setBorder(BorderFactory.createTitledBorder("Report Function"));
            this.selectReportPanel.setLayout(null);
            this.selectReportPanel.setBounds(new Rectangle(5, 295, 490, 120));
            this.selectReportPanel.add((Component)this.jLabel_reportFunction, null);
            this.selectReportPanel.add((Component)this.getJComboBox_reportFunction(), null);
            this.selectReportPanel.add((Component)this.repDescriptionLabel, null);
        }
        return this.selectReportPanel;
    }

    private JPanel getAutoConfigPanel() {
        if (this.autoConfigPanel == null) {
            this.autoConfigPanel = new JPanel();
            this.autoConfigPanel.setLayout(null);
            this.autoConfigPanel.setBounds(7, 175, 486, 51);
            this.autoConfigPanel.setBorder(BorderFactory.createTitledBorder("Auto config"));
            this.autoConfigPanel.add((Component)this.jLabel_CONFautoLoopSteps, null);
            this.autoConfigPanel.add((Component)this.getJTextField_CONFautoLoopSteps(), null);
            this.autoConfigPanel.add((Component)this.getJTextField_CONFautoLoopNEvals(), null);
            this.autoConfigPanel.add((Component)this.jLabel_CONFautoLoopNEvals, null);
        }
        return this.autoConfigPanel;
    }

    private JMenuItem getImport2MenuItem() {
        if (this.import2MenuItem == null) {
            this.import2MenuItem = new JMenuItem();
            this.import2MenuItem.setText("Import Region of Interest (.roi)");
            this.import2MenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser import2SettingsFC;
                    int ret;
                    int answer = JOptionPane.showConfirmDialog(spotGuiMain.this.import2MenuItem.getParent(), "Your current Region Of Interest will be overwritten. Are you sure you want to go on?", "Import settings from file", 0, 3);
                    if (answer == 0 && (ret = (import2SettingsFC = spotGuiMain.this.getJFileChooser_import2Settings()).showDialog(spotGuiMain.this.import2MenuItem.getParent(), "Import")) == 0) {
                        File chosenFile = new File("");
                        chosenFile = import2SettingsFC.getSelectedFile();
                        spotGuiMain.this.pathFCDefaultImportSettigns = chosenFile.getParentFile();
                        if (chosenFile.toString().toLowerCase().endsWith(".roi")) {
                            spotGuiMain.this.pathFile_LoadROI = chosenFile;
                            if (spotGuiMain.this.makeStringListToRoiVal(fileIO.readToStrList(spotGuiMain.this.pathFile_LoadROI)) != 0) {
                                JOptionPane.showMessageDialog(spotGuiMain.this.import2MenuItem.getParent(), "Error: ROI load failed.", "Load failed", 0);
                            }
                        }
                    }
                }
            });
        }
        return this.import2MenuItem;
    }

    private JMenuItem getImport3MenuItem() {
        if (this.import3MenuItem == null) {
            this.import3MenuItem = new JMenuItem();
            this.import3MenuItem.setText("Import Algorithm Problem Design (.apd)");
            this.import3MenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JFileChooser import3SettingsFC = spotGuiMain.this.getJFileChooser_import3Settings();
                    int ret = import3SettingsFC.showDialog(spotGuiMain.this.import3MenuItem.getParent(), "Import");
                    if (ret == 0) {
                        File chosenFile = new File("");
                        chosenFile = import3SettingsFC.getSelectedFile();
                        spotGuiMain.this.pathFCDefaultImportSettigns = chosenFile.getParentFile();
                        spotGuiMain.this.pathFile_APD = import3SettingsFC.getSelectedFile();
                        spotGuiMain.this.pathFCDefaultAPD = spotGuiMain.this.pathFile_APD;
                        spotGuiMain.this.jTextField_CONFalgPdFilePath.setText(spotGuiMain.this.pathFile_APD.toString());
                    }
                }
            });
        }
        return this.import3MenuItem;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                spotGuiMain application = new spotGuiMain();
                application.getJFrame().setVisible(true);
            }
        });
    }

    private JFileChooser getJFileChooser_importSettings() {
        if (this.jFileChooser_importSettings == null) {
            this.jFileChooser_importSettings = new JFileChooser();
            this.jFileChooser_importSettings.removeChoosableFileFilter(this.jFileChooser_importSettings.getChoosableFileFilters()[0]);
            this.jFileChooser_importSettings.addChoosableFileFilter(this.fileFilterAll);
            this.jFileChooser_importSettings.addChoosableFileFilter(this.fileFilterCONF);
        }
        this.jFileChooser_importSettings.setCurrentDirectory(this.pathFCDefaultImportSettigns);
        return this.jFileChooser_importSettings;
    }

    private JFileChooser getJFileChooser_import2Settings() {
        if (this.jFileChooser_import2Settings == null) {
            this.jFileChooser_import2Settings = new JFileChooser();
            this.jFileChooser_import2Settings.removeChoosableFileFilter(this.jFileChooser_import2Settings.getChoosableFileFilters()[0]);
            this.jFileChooser_import2Settings.addChoosableFileFilter(this.fileFilterAll);
            this.jFileChooser_import2Settings.addChoosableFileFilter(this.fileFilterROI);
        }
        this.jFileChooser_import2Settings.setCurrentDirectory(this.pathFCDefaultImportSettigns);
        return this.jFileChooser_import2Settings;
    }

    private JFileChooser getJFileChooser_import3Settings() {
        if (this.jFileChooser_import3Settings == null) {
            this.jFileChooser_import3Settings = new JFileChooser();
            this.jFileChooser_import3Settings.removeChoosableFileFilter(this.jFileChooser_import3Settings.getChoosableFileFilters()[0]);
            this.jFileChooser_import3Settings.addChoosableFileFilter(this.fileFilterAll);
            this.jFileChooser_import3Settings.addChoosableFileFilter(this.fileFilterAPD);
        }
        this.jFileChooser_import3Settings.setCurrentDirectory(this.pathFCDefaultImportSettigns);
        return this.jFileChooser_import3Settings;
    }

    private JFileChooser getJFileChooser_exportSettings() {
        if (this.jFileChooser_exportSettings == null) {
            this.jFileChooser_exportSettings = new JFileChooser();
            this.jFileChooser_exportSettings.removeChoosableFileFilter(this.jFileChooser_exportSettings.getChoosableFileFilters()[0]);
            this.jFileChooser_exportSettings.addChoosableFileFilter(this.fileFilterAll);
        }
        this.jFileChooser_exportSettings.setCurrentDirectory(this.pathFCDefaultExportSettigns);
        return this.jFileChooser_exportSettings;
    }

    private JFileChooser getJFileChooser_CONFprojectPath() {
        if (this.jFileChooser_CONFprojectPath == null) {
            this.jFileChooser_CONFprojectPath = new JFileChooser();
            this.jFileChooser_CONFprojectPath.removeChoosableFileFilter(this.jFileChooser_CONFprojectPath.getChoosableFileFilters()[0]);
            this.jFileChooser_CONFprojectPath.addChoosableFileFilter(this.fileFilterAll);
            this.jFileChooser_CONFprojectPath.setFileSelectionMode(1);
        }
        this.jFileChooser_CONFprojectPath.setCurrentDirectory(this.pathFCDefaultCONFproject);
        return this.jFileChooser_CONFprojectPath;
    }

    private JFileChooser getJFileChooser_algorithmSelect() {
        if (this.jFileChooser_algorithmSelect == null) {
            this.jFileChooser_algorithmSelect = new JFileChooser();
            this.jFileChooser_algorithmSelect.removeChoosableFileFilter(this.jFileChooser_algorithmSelect.getChoosableFileFilters()[0]);
            this.jFileChooser_algorithmSelect.addChoosableFileFilter(this.fileFilterAll);
            this.jFileChooser_algorithmSelect.addChoosableFileFilter(this.fileFilterAlgo);
        }
        this.jFileChooser_algorithmSelect.setCurrentDirectory(this.pathFCDefaultCONFalgorithmScript);
        return this.jFileChooser_algorithmSelect;
    }

    private JFileChooser getJFileChooser_rPath() {
        if (this.jFileChooser_rPath == null) {
            this.jFileChooser_rPath = new JFileChooser();
            this.jFileChooser_rPath.removeChoosableFileFilter(this.jFileChooser_rPath.getChoosableFileFilters()[0]);
            this.jFileChooser_rPath.addChoosableFileFilter(this.fileFilterAll);
            this.jFileChooser_rPath.addChoosableFileFilter(this.fileFilterExe);
        }
        this.jFileChooser_rPath.setCurrentDirectory(this.pathFCDefaultRPATH);
        return this.jFileChooser_rPath;
    }

    private JFileChooser getJFileChooser_APD() {
        if (this.jFileChooser_APD == null) {
            this.jFileChooser_APD = new JFileChooser();
            this.jFileChooser_APD.removeChoosableFileFilter(this.jFileChooser_APD.getChoosableFileFilters()[0]);
            this.jFileChooser_APD.addChoosableFileFilter(this.fileFilterAll);
            this.jFileChooser_APD.addChoosableFileFilter(this.fileFilterAPD);
        }
        this.jFileChooser_APD.setCurrentDirectory(this.pathFCDefaultAPD);
        return this.jFileChooser_APD;
    }

    public void initTableData(String def_min, String def_max, String def_type) {
        int i = 0;
        while (i < this.roiTableMaxDim) {
            this.roiTableData[i][0] = new String("VARX" + Integer.toString(i + 1));
            this.roiTableData[i][1] = new String(def_min);
            this.roiTableData[i][2] = new String(def_max);
            this.roiTableData[i][3] = new String(def_type);
            ++i;
        }
    }

    private boolean isRegExString(String val) {
        String regEx = "[a-zA-Z][\\w]*";
        return val.toString().matches(regEx);
    }

    public String isRegExInt(String val) {
        try {
            return Integer.toString(Integer.valueOf(val.toString()));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public String isRegExFloat(String val) {
        try {
            return Float.toString(Float.valueOf(val.toString().replace(",", ".")).floatValue());
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public void clearConfVars() {
        this.conf_algPath = "";
        this.conf_algName = "";
        this.conf_algPdFile = "";
        this.conf_model = "";
        this.conf_design_type = "";
        this.conf_init_design_size = "";
        this.conf_seq_design_size = "";
        this.conf_auto_loop_steps = "";
    }

    public void refreshConf() {
        boolean DEBUG = true;
        boolean DEBUGadvanced = true;
        boolean changesOccured = false;
        String check = "";
        if (!this.jTextField_selectedAlgorithmScript.equals("")) {
            try {
                this.relativePathFileString_algPath = hlp.getRelPath(this.pathFile_AlgorithmScript, this.path_Project);
            }
            catch (IOException e) {
                System.err.println("IOException @ relativePathFileString_algPath=hlp.getRelPath(pathFile_AlgorithmScript,path_Project);");
            }
            File relativeAlgPath = new File(this.relativePathFileString_algPath);
            check = this.relativePathFileString_algPath.contains(this.FILE_SEPERATOR) ? relativeAlgPath.getParent().toString() : "";
            if (!this.conf_algPath.equals(check)) {
                if (DEBUG) {
                    this.jColorPane_spotRun.append(Color.gray, "\nconf_algPath:  old=" + hlp.strQuote(this.conf_algPath) + "  new=" + hlp.strQuote(check));
                }
                this.conf_algPath = check;
                changesOccured = true;
            }
        } else {
            check = "";
            if (!this.conf_algPath.equals(check)) {
                if (DEBUG) {
                    this.jColorPane_spotRun.append(Color.gray, "\nconf: alg.path:  old=" + hlp.strQuote(this.conf_algPath) + "  new=" + hlp.strQuote(check));
                }
                this.conf_algPath = check;
                changesOccured = true;
            }
        }
        if (this.jComboBox_CONFalgname.getSelectedIndex() >= 0 && !this.conf_algName.equals(check = this.jComboBox_CONFalgname.getSelectedItem().toString().replace(" = ", " <- ").split(" <- ")[0])) {
            if (DEBUG) {
                this.jColorPane_spotRun.append(Color.gray, "\nconf: alg.func:  old=" + hlp.strQuote(this.conf_algName) + "  new=" + hlp.strQuote(check));
            }
            this.conf_algName = check;
            changesOccured = true;
        }
        try {
            this.relativePathFileString_algPd = hlp.getRelPath(this.pathFile_APD, this.path_Project);
        }
        catch (IOException e) {
            System.err.println("IOException @ relativePathFileString_algPd=hlp.getRelPath(pathFile_APD,path_Project);");
        }
        check = this.relativePathFileString_algPd;
        if (!this.conf_algPdFile.equals(check)) {
            if (DEBUG) {
                this.jColorPane_spotRun.append(Color.gray, "\nconf: io.apdFileName:  old=" + hlp.strQuote(this.conf_algPdFile) + "  new=" + hlp.strQuote(check));
            }
            this.conf_algPdFile = check;
            changesOccured = true;
        }
        try {
            check = this.jComboBox_CONFmodel.getSelectedItem().toString();
            if (!this.conf_model.equals(check)) {
                if (DEBUG) {
                    this.jColorPane_spotRun.append(Color.gray, "\nconf: seq.predictionModel.func:  old=" + hlp.strQuote(this.conf_model) + "  new=" + hlp.strQuote(check));
                }
                this.conf_model = check;
                changesOccured = true;
            }
        }
        catch (Exception e) {
            System.err.println("catched exception: jComboBox_CONFmodel.getSelectedItem()");
        }
        try {
            check = this.jComboBox_CONFdesignType.getSelectedItem().toString();
            if (!this.conf_design_type.equals(check)) {
                if (DEBUG) {
                    this.jColorPane_spotRun.append(Color.gray, "\nconf: init.design.func:  old=" + hlp.strQuote(this.conf_design_type) + "  new=" + hlp.strQuote(check));
                }
                this.conf_design_type = check;
                changesOccured = true;
            }
        }
        catch (Exception e) {
            System.err.println("catched exception: jComboBox_CONFmodel.getSelectedItem()");
        }
        if (!this.conf_init_design_size.equals(check = this.jTextField_CONFinitLhdPoints.getText())) {
            if (DEBUG) {
                this.jColorPane_spotRun.append(Color.gray, "\nconf: init.design.size:  old=" + hlp.strQuote(this.conf_init_design_size) + "  new=" + hlp.strQuote(check));
            }
            this.conf_init_design_size = check;
            changesOccured = true;
        }
        if (!this.conf_seq_design_size.equals(check = this.jTextField_CONFseqDesignSize.getText())) {
            if (DEBUG) {
                this.jColorPane_spotRun.append(Color.gray, "\nconf: seq.design.size:  old=" + hlp.strQuote(this.conf_seq_design_size) + "  new=" + hlp.strQuote(check));
            }
            this.conf_seq_design_size = check;
            changesOccured = true;
        }
        if (!this.conf_auto_loop_steps.equals(check = this.jTextField_CONFautoLoopSteps.getText())) {
            if (DEBUG) {
                this.jColorPane_spotRun.append(Color.gray, "\nconf: auto.loop.steps:  old=" + hlp.strQuote(this.conf_auto_loop_steps) + "  new=" + hlp.strQuote(check));
            }
            this.conf_auto_loop_steps = check;
            changesOccured = true;
        }
        if (!this.conf_auto_loop_nevals.equals(check = this.jTextField_CONFautoLoopNEvals.getText())) {
            if (DEBUG) {
                this.jColorPane_spotRun.append(Color.gray, "\nconf: auto.loop.nevals:  old=" + hlp.strQuote(this.conf_auto_loop_nevals) + "  new=" + hlp.strQuote(check));
            }
            this.conf_auto_loop_nevals = check;
            changesOccured = true;
        }
        if (DEBUG && DEBUGadvanced && this.jCheckBox_CONFadvanced.isSelected()) {
            this.jColorPane_spotRun.append(Color.gray, "\nconf_advanced:");
            String[] advanced = this.jTextArea_CONFadditional.getText().split("\n");
            int i = 0;
            while (i < advanced.length) {
                this.jColorPane_spotRun.append(Color.gray, "\n...");
                this.jColorPane_spotRun.append(Color.gray, advanced[i]);
                ++i;
            }
        }
        if (this.jComboBox_reportFunction.getSelectedIndex() >= 0 && !this.reportFunction.equals(check = this.jComboBox_reportFunction.getSelectedItem().toString().replace(" = ", " <- ").split(" <- ")[0])) {
            if (DEBUG) {
                this.jColorPane_spotRun.append(Color.gray, "\nconf: report.func:  old=" + hlp.strQuote(this.reportFunction) + "  new=" + hlp.strQuote(check));
            }
            this.reportFunction = check;
            changesOccured = true;
        }
        if (changesOccured) {
            this.jLabel_checkSpotRun_algorithm.setIcon(this.iconCheckUnknown);
            this.jLabel_checkSpotRun_roiConfig.setIcon(this.iconCheckUnknown);
            this.jLabel_checkSpotRun_spoConfig.setIcon(this.iconCheckUnknown);
            this.jLabel_checkSpotRun_rPath.setIcon(this.iconCheckUnknown);
            this.jLabel_checkSpotRun_roiConfigFile.setIcon(this.iconCheckUnknown);
            this.jLabel_checkSpotRun_spoConfigFile.setIcon(this.iconCheckUnknown);
            this.jLabel_taskSelect.setEnabled(false);
            this.jComboBox_taskSelect.setEnabled(false);
            this.jButton_spotRun.setEnabled(false);
            this.jButton_checkSpotRun.setEnabled(true);
        }
    }

    private int updateTableDim(int dim) {
        if (dim >= this.roiTableMinDim && dim <= this.roiTableMaxDim) {
            this.roiTableDim = dim;
            this.jSlider_ROIdim.setValue(dim);
            this.jTextField_ROIdim.setText(Integer.toString(dim));
            this.jTable_ROI.tableChanged(new TableModelEvent(this.jTable_ROI.getModel()));
            return 0;
        }
        this.jTable_ROI.tableChanged(new TableModelEvent(this.jTable_ROI.getModel()));
        return -1;
    }

    private void loadConfValues(File confFile) {
        int n;
        int i;
        String[] tmp1;
        if (this.reportFunction.equals("spotReportDefault") || this.reportFunction.equals("spotReportSens") || this.reportFunction.equals("spotReportContour") || this.reportFunction.equals("spotReport3d")) {
            this.pathFile_ReportScript = new File("");
            DefaultComboBoxModel<String> temp1Model = new DefaultComboBoxModel<String>(new String[]{"spotReportDefault", "spotReportSens", "spotReport3d", "spotReportContour"});
            this.jComboBox_reportFunction.setModel(temp1Model);
            this.jComboBox_reportFunction.setSelectedItem(this.reportFunction);
        }
        if (this.conf_algName.equals("spotFuncStartBranin") || this.conf_algName.equals("spotFuncStartSixHump") || this.conf_algName.equals("spotFuncStartSphere") || this.conf_algName.equals("spotAlgStartSann") || this.conf_algName.equals("spotAlgStartEs")) {
            this.jTextField_selectedAlgorithmScript.setText("");
            this.pathFile_AlgorithmScript = new File("");
            DefaultComboBoxModel<String> temp2Model = new DefaultComboBoxModel<String>(new String[]{"spotFuncStartBranin", "spotFuncStartSixHump", "spotFuncStartSphere", "spotAlgStartSann", "spotAlgStartEs"});
            this.jComboBox_CONFalgname.setModel(temp2Model);
            this.jComboBox_CONFalgname.setSelectedItem(this.conf_algName);
        } else if (!this.conf_algPath.equals("NA") && !this.conf_algPath.equals("")) {
            try {
                this.jTextField_selectedAlgorithmScript.setText(new File(String.valueOf(confFile.getParent()) + this.FILE_SEPERATOR + this.conf_algPath + this.FILE_SEPERATOR + this.conf_algName + ".R").getCanonicalPath());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.pathFile_AlgorithmScript = new File(this.jTextField_selectedAlgorithmScript.getText());
            if (this.pathFCDefaultReportScript.equals("") && this.pathFile_AlgorithmScript.toString().contains(this.FILE_SEPERATOR)) {
                this.pathFCDefaultReportScript = this.pathFile_AlgorithmScript.getParentFile();
            }
        }
        String[] tmp = null;
        if (this.pathFile_AlgorithmScript.exists() && this.pathFile_AlgorithmScript.isFile()) {
            tmp = fileIO.readFuncFromRscript(this.pathFile_AlgorithmScript);
        }
        if (tmp != null) {
            tmp1 = new String[tmp.length + 5];
            int i2 = 0;
            while (i2 < tmp.length) {
                tmp1[i2] = tmp[i2];
                ++i2;
            }
            tmp1[tmp1.length - 5] = "spotFuncStartBranin";
            tmp1[tmp1.length - 4] = "spotFuncStartSixHump";
            tmp1[tmp1.length - 3] = "spotFuncStartSphere";
            tmp1[tmp1.length - 2] = "spotAlgStartSann";
            tmp1[tmp1.length - 1] = "spotAlgStartEs";
            DefaultComboBoxModel<String> jComboBox_CONFalgnameModel = new DefaultComboBoxModel<String>(tmp1);
            this.jComboBox_CONFalgname.setModel(jComboBox_CONFalgnameModel);
            this.jComboBox_CONFalgname.setSelectedItem(null);
            i = 0;
            while (i < this.jComboBox_CONFalgname.getItemCount()) {
                if (this.jComboBox_CONFalgname.getItemAt(i).toString().split(" <- ")[0].equals(this.conf_algName)) {
                    this.jComboBox_CONFalgname.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
        tmp = null;
        if (this.pathFile_ReportScript.exists() && this.pathFile_ReportScript.isFile()) {
            tmp = fileIO.readFuncFromRscript(this.pathFile_ReportScript);
        }
        if (tmp != null) {
            tmp1 = new String[tmp.length + 2];
            int i3 = 0;
            while (i3 < tmp.length) {
                tmp1[i3] = tmp[i3];
                ++i3;
            }
            tmp1[tmp1.length - 4] = "spotReportDefault";
            tmp1[tmp1.length - 3] = "spotReportSens";
            tmp1[tmp1.length - 2] = "spotReport3d";
            tmp1[tmp1.length - 1] = "spotReportContour";
            DefaultComboBoxModel<String> jComboBox_CONFrepnameModel = new DefaultComboBoxModel<String>(tmp1);
            this.jComboBox_reportFunction.setModel(jComboBox_CONFrepnameModel);
            this.jComboBox_reportFunction.setSelectedItem(null);
            i = 0;
            while (i < this.jComboBox_reportFunction.getItemCount()) {
                if (this.jComboBox_reportFunction.getItemAt(i).toString().split(" <- ")[0].equals(this.reportFunction)) {
                    this.jComboBox_reportFunction.setSelectedIndex(i);
                    break;
                }
                ++i;
            }
        }
        if (!this.conf_algPdFile.equals("") && !this.conf_algPdFile.equals("NA")) {
            try {
                this.jTextField_CONFalgPdFilePath.setText(new File(String.valueOf(confFile.getParent()) + this.FILE_SEPERATOR + this.conf_algPdFile).getCanonicalPath());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.pathFile_APD = new File(this.jTextField_CONFalgPdFilePath.getText());
            this.pathFCDefaultAPD = this.pathFile_APD.getParentFile();
        }
        this.jTextField_CONFprojectPath.setText(confFile.getParent());
        this.path_Project = new File(this.jTextField_CONFprojectPath.getText());
        this.jTextField_CONFprojectPrefix.setText(confFile.getName().replaceFirst("\\..*", ""));
        boolean modelIsKnown = false;
        if (!this.conf_model.equals("")) {
            String[] stringArray = this.modelStrings;
            n = this.modelStrings.length;
            i = 0;
            while (i < n) {
                String i4 = stringArray[i];
                if (i4.equals(this.conf_model)) {
                    this.jComboBox_CONFmodel.setSelectedItem(this.conf_model);
                    modelIsKnown = true;
                    break;
                }
                ++i;
            }
            if (!modelIsKnown) {
                this.jTextArea_CONFadditional.append("\nseq.predictionModel.func = " + hlp.strQuote(this.conf_model));
                if (!this.jCheckBox_CONFadvanced.isSelected()) {
                    this.jCheckBox_CONFadvanced.setSelected(true);
                    this.jTextArea_CONFadditional.setEnabled(true);
                }
            }
        }
        boolean designIsKnown = false;
        if (!this.conf_design_type.equals("")) {
            String[] stringArray = this.designTypeStrings;
            int n2 = this.designTypeStrings.length;
            n = 0;
            while (n < n2) {
                String i5 = stringArray[n];
                if (i5.equals(this.conf_design_type)) {
                    this.jComboBox_CONFdesignType.setSelectedItem(this.conf_design_type);
                    designIsKnown = true;
                    break;
                }
                ++n;
            }
            if (!designIsKnown) {
                this.jTextArea_CONFadditional.append("\ninit.design.func = " + this.conf_design_type);
                if (!this.jCheckBox_CONFadvanced.isSelected()) {
                    this.jCheckBox_CONFadvanced.setSelected(true);
                    this.jTextArea_CONFadditional.setEnabled(true);
                }
            }
        }
        if (!this.conf_init_design_size.equals("")) {
            this.jTextField_CONFinitLhdPoints.setText(this.conf_init_design_size);
        }
        if (!this.conf_seq_design_size.equals("")) {
            this.jTextField_CONFseqDesignSize.setText(this.conf_seq_design_size);
        }
        if (!this.conf_auto_loop_steps.equals("")) {
            this.jTextField_CONFautoLoopSteps.setText(this.conf_auto_loop_steps);
        }
        if (!this.conf_auto_loop_nevals.equals("")) {
            this.jTextField_CONFautoLoopNEvals.setText(this.conf_auto_loop_nevals);
        }
    }

    public ArrayList<String> makeRoiValToStringList() {
        ArrayList<String> content = new ArrayList<String>();
        content.add("name low high type");
        int i = 0;
        while (i < this.roiTableDim) {
            content.add(String.valueOf(this.roiTableData[i][0].toString()) + this.sepRoiFile + this.roiTableData[i][1].toString() + this.sepRoiFile + this.roiTableData[i][2].toString() + this.sepRoiFile + this.roiTableData[i][3].toString());
            ++i;
        }
        return content;
    }

    public int makeStringListToRoiVal(ArrayList<String> myStrList) {
        if (myStrList.size() - 1 > this.roiTableMaxDim) {
            System.err.println("ERROR(makeStringListToRoiVal): ROI file has more than roiTableMaxDim (" + Integer.toString(this.roiTableMaxDim) + ") parameterlines (count of lines was: " + Integer.toString(myStrList.size()) + ")");
            return -1;
        }
        String[] linesplit = new String[3];
        int i = 1;
        while (i < myStrList.size()) {
            linesplit = myStrList.get(i).split(this.sepRoiFile);
            this.jTable_ROI.setValueAt(linesplit[0], i - 1, 0);
            this.jTable_ROI.setValueAt(linesplit[1], i - 1, 1);
            this.jTable_ROI.setValueAt(linesplit[2], i - 1, 2);
            this.jTable_ROI.setValueAt(linesplit[3], i - 1, 3);
            ++i;
        }
        this.updateTableDim(i - 1);
        return 0;
    }

    public int makeStringListToConfVal(ArrayList<String> myStrList) {
        if (myStrList == null) {
            return -1;
        }
        boolean DEBUG = true;
        ArrayList<String> additional = new ArrayList<String>();
        if (DEBUG) {
            System.out.println("\n\n\n**************************************");
        }
        if (DEBUG) {
            System.out.println("** ENTERING makeStringListToConfVal **");
        }
        if (DEBUG) {
            System.out.println("**************************************");
        }
        String[] var = new String[2];
        String tmp = new String();
        if (DEBUG) {
            System.out.println("linecount: " + myStrList.size());
        }
        this.clearConfVars();
        int i = 0;
        while (i < myStrList.size()) {
            tmp = myStrList.get(i);
            tmp = tmp.replace(";", "");
            tmp = tmp.replace("<-", "=");
            tmp = tmp.replaceFirst(" *= *", "=");
            tmp = tmp.replaceFirst("\\s*#.*", "");
            tmp = tmp.replaceAll("\"", "");
            String checktmp = (tmp = tmp.replace("\\\\", "\\").replace("\\", this.FILE_SEPERATOR).replace("/", this.FILE_SEPERATOR)).split("=")[0];
            if (checktmp.equals("alg.func")) {
                var = tmp.split("=", 2);
                this.conf_algName = var[1];
            } else if (checktmp.equals("io.apdFileName")) {
                var = tmp.split("=", 2);
                this.conf_algPdFile = var[1];
            } else if (checktmp.equals("seq.predictionModel.func")) {
                var = tmp.split("=", 2);
                this.conf_model = var[1];
            } else if (checktmp.equals("init.design.func")) {
                var = tmp.split("=", 2);
                this.conf_design_type = var[1];
            } else if (checktmp.equals("init.design.size")) {
                var = tmp.split("=", 2);
                this.conf_init_design_size = var[1];
            } else if (checktmp.equals("seq.design.size")) {
                var = tmp.split("=", 2);
                this.conf_seq_design_size = var[1];
            } else if (checktmp.equals("auto.loop.steps")) {
                var = tmp.split("=", 2);
                this.conf_auto_loop_steps = var[1];
            } else if (checktmp.equals("auto.loop.nevals")) {
                var = tmp.split("=", 2);
                this.conf_auto_loop_nevals = var[1];
            } else if (checktmp.equals("report.func")) {
                var = tmp.split("=", 2);
                this.reportFunction = var[1];
            } else if (!checktmp.equals("report.io.pdf")) {
                additional.add(myStrList.get(i));
            }
            ++i;
        }
        if (additional.size() > 0) {
            this.jCheckBox_CONFadvanced.setSelected(true);
            this.jTextArea_CONFadditional.setEnabled(true);
            this.jTextArea_CONFadditional.setText("");
            this.jTextArea_CONFadditional.append((String)additional.get(0));
            i = 1;
            while (i < additional.size()) {
                this.jTextArea_CONFadditional.append("\n" + (String)additional.get(i));
                ++i;
            }
        } else {
            this.jCheckBox_CONFadvanced.setSelected(false);
            this.jTextArea_CONFadditional.setEnabled(false);
        }
        return 0;
    }

    public ArrayList<String> makeConfValToStringList() {
        ArrayList<String> confArrayList = new ArrayList<String>();
        confArrayList.add("##############################################################");
        confArrayList.add("### *** This CONF was generated by SPOT GUI (ver. " + this.SPOTGUIVERSION + ") *** ###");
        confArrayList.add("##############################################################");
        confArrayList.add("");
        confArrayList.add("alg.func = " + hlp.strQuote(this.conf_algName));
        if (this.confAPDSelectedCheck && this.confAPDExistCheck) {
            confArrayList.add("io.apdFileName = " + hlp.strQuote(this.conf_algPdFile.replace("\\\\", "\\").replace("\\", "\\\\")));
        }
        confArrayList.add("io.verbosity=3");
        confArrayList.add("");
        confArrayList.add("init.design.func = " + hlp.strQuote(this.conf_design_type));
        confArrayList.add("init.design.size = " + this.conf_init_design_size);
        confArrayList.add("seq.predictionModel.func = " + hlp.strQuote(this.conf_model));
        confArrayList.add("auto.loop.nevals = " + this.conf_auto_loop_nevals);
        confArrayList.add("auto.loop.steps = " + this.conf_auto_loop_steps);
        confArrayList.add("seq.design.size = " + this.conf_seq_design_size);
        confArrayList.add("");
        confArrayList.add("###########################");
        confArrayList.add("### ** REPORT CONFIG ** ###");
        confArrayList.add("###########################");
        confArrayList.add("");
        confArrayList.add("report.func = " + hlp.strQuote(this.reportFunction));
        confArrayList.add("report.io.pdf = TRUE");
        confArrayList.add("report.interactive = FALSE");
        if (this.jCheckBox_CONFadvanced.isSelected()) {
            String[] additional = this.jTextArea_CONFadditional.getText().split("\\n");
            if (additional.length >= 1) {
                confArrayList.add("");
                confArrayList.add("###############################");
                confArrayList.add("### ** ADDITIONAL CONFIG ** ###");
                confArrayList.add("###############################");
                confArrayList.add("");
            }
            int i = 0;
            while (i < additional.length) {
                if (!additional[i].matches("\\s*#.*")) {
                    confArrayList.add(additional[i]);
                }
                ++i;
            }
        }
        return confArrayList;
    }

    public int checkSPO() {
        int answer;
        if (new File(String.valueOf(this.path_Project.toString()) + this.FILE_SEPERATOR + this.jTextField_CONFprojectPrefix.getText() + ".conf").exists() && (answer = JOptionPane.showConfirmDialog(this.jFrame, "Project already exists. Do you want to overwrite ?", "Overwrite existing project ?", 0, 3)) == 1) {
            return -1;
        }
        this.jColorPane_spotRun.setText("");
        this.jColorPane_spotRun.append(Color.blue, "[*** UPDATE CONFIG PARAMETERS CHANGE ***]");
        this.refreshConf();
        this.jColorPane_spotRun.append(Color.black, "\n...");
        this.jColorPane_spotRun.append(Color.blue, "done");
        this.jColorPane_spotRun.append(Color.black, "...");
        this.jColorPane_spotRun.append(Color.blue, "\n\n[*** STARTING CHECK ***]");
        boolean algoScriptSelectedCheck = false;
        boolean algoScriptExistCheck = false;
        boolean roiBoundvaluesCheck = true;
        boolean roiFactorCheck = true;
        boolean writeROI = false;
        boolean confRFunctionSelectedCheck = false;
        this.confAPDSelectedCheck = false;
        this.confAPDExistCheck = false;
        boolean confProjectPathSelectedCheck = false;
        boolean confProjectPrefixCheck = false;
        boolean confInitLhdPointsCheck = false;
        boolean confAutoLoopStepsCheck = false;
        boolean confAutoLoopNevalsCheck = false;
        boolean LimitCheck = false;
        boolean confIStepSampleSizeCheck = false;
        boolean confAdvancedConfCheck = false;
        boolean writeCONF = false;
        boolean pathRCheck = false;
        boolean fileROICheck = false;
        boolean fileCONFCheck = false;
        this.jColorPane_spotRun.append(Color.black, "\n...[CHECK]: ALGORITHM SCRIPT - filepath selected......");
        if (!this.jTextField_selectedAlgorithmScript.getText().equals("")) {
            algoScriptSelectedCheck = true;
            this.jColorPane_spotRun.append(Color.green, "OK");
            this.jColorPane_spotRun.append(Color.black, "\n...[CHECK]: ALGORITHM SCRIPT - file exists......");
            if (new File(this.jTextField_selectedAlgorithmScript.getText()).exists()) {
                algoScriptExistCheck = true;
            } else {
                this.jColorPane_spotRun.append(Color.red, "FAILED");
            }
        } else if (this.jComboBox_CONFalgname.getSelectedItem().toString().equals("spotFuncStartBranin") || this.jComboBox_CONFalgname.getSelectedItem().toString().equals("spotFuncStartSixHump") || this.jComboBox_CONFalgname.getSelectedItem().toString().equals("spotFuncStartSphere") || this.jComboBox_CONFalgname.getSelectedItem().toString().equals("spotAlgStartSann") || this.jComboBox_CONFalgname.getSelectedItem().toString().equals("spotAlgStartEs")) {
            this.jColorPane_spotRun.append(Color.blue, "SKIPPED, Algorithm is internal");
            algoScriptSelectedCheck = true;
            algoScriptExistCheck = true;
        } else {
            this.jColorPane_spotRun.append(Color.red, "FAILED");
        }
        this.jColorPane_spotRun.append(Color.black, "\n...[CHECK]: ROI - lower bound is less or equal upper bound......");
        int i = 0;
        while (i < this.roiTableDim) {
            if (this.jTable_ROI.getValueAt(i, 3).toString().equalsIgnoreCase("FACTOR") && (this.jTable_ROI.getValueAt(i, 1).toString().contains("Inf") || this.jTable_ROI.getValueAt(i, 2).toString().contains("Inf"))) {
                roiFactorCheck = false;
            }
            if (!(this.jTable_ROI.getValueAt(i, 1).toString().equals("Inf") || this.jTable_ROI.getValueAt(i, 1).toString().equals("-Inf") || this.jTable_ROI.getValueAt(i, 2).toString().equals("Inf") || this.jTable_ROI.getValueAt(i, 2).toString().equals("-Inf"))) {
                if (Float.valueOf(this.jTable_ROI.getValueAt(i, 1).toString()).floatValue() > Float.valueOf(this.jTable_ROI.getValueAt(i, 2).toString()).floatValue()) {
                    roiBoundvaluesCheck = false;
                }
            } else if (this.jTable_ROI.getValueAt(i, 1).toString().equals("Inf") || this.jTable_ROI.getValueAt(i, 2).toString().equals("-Inf")) {
                roiBoundvaluesCheck = false;
            }
            ++i;
        }
        if (roiBoundvaluesCheck) {
            this.jColorPane_spotRun.append(Color.green, "OK");
        } else {
            this.jColorPane_spotRun.append(Color.red, "FAILED");
        }
        this.jColorPane_spotRun.append(Color.black, "\n...[CHECK]: ROI - not used type factor on Inf/-Inf bounds......");
        if (roiFactorCheck) {
            this.jColorPane_spotRun.append(Color.green, "OK");
        } else {
            this.jColorPane_spotRun.append(Color.red, "FAILED");
        }
        if (this.IS_OS_WINDOWS) {
            this.jColorPane_spotRun.append(Color.black, "\n...[CHECK]: PATH SETUP - valid filepath to R.exe selected......");
            if (this.pathFile_R.getName().equalsIgnoreCase("R.exe")) {
                pathRCheck = true;
                this.jColorPane_spotRun.append(Color.green, "OK");
            } else {
                this.jColorPane_spotRun.append(Color.red, "FAILED");
            }
        } else if (this.IS_OS_LINUX || this.IS_OS_MAC) {
            pathRCheck = true;
        }
        this.jColorPane_spotRun.append(Color.black, "\n...[CHECK]: CONF - algorithm R function selected......");
        if (this.jComboBox_CONFalgname.getSelectedIndex() >= 0) {
            confRFunctionSelectedCheck = true;
            this.jColorPane_spotRun.append(Color.green, "OK");
        } else {
            this.jColorPane_spotRun.append(Color.red, "FAILED");
        }
        this.jColorPane_spotRun.append(Color.black, "\n...[CHECK]: CONF - APD filepath selected......");
        if (!this.pathFile_APD.toString().equals("")) {
            this.confAPDSelectedCheck = true;
            this.jColorPane_spotRun.append(Color.green, "OK");
            this.jColorPane_spotRun.append(Color.black, "\n...[CHECK]: CONF - APD file exists......");
            if (this.confAPDSelectedCheck && this.pathFile_APD.exists()) {
                this.confAPDExistCheck = true;
                this.jColorPane_spotRun.append(Color.green, "OK");
            } else {
                this.jColorPane_spotRun.append(Color.blue, "WARNING, not existing");
            }
        } else {
            this.jColorPane_spotRun.append(Color.blue, "WARNING, none selected");
        }
        this.jColorPane_spotRun.append(Color.black, "\n...[CHECK]: CONF - project path selected......");
        if (!this.path_Project.toString().equals("")) {
            confProjectPathSelectedCheck = true;
            this.jColorPane_spotRun.append(Color.green, "OK");
        } else {
            this.jColorPane_spotRun.append(Color.red, "FAILED");
        }
        this.jColorPane_spotRun.append(Color.black, "\n...[CHECK]: CONF - project prefix name is valid......");
        if (hlp.validPref(this.jTextField_CONFprojectPrefix.getText())) {
            confProjectPrefixCheck = true;
            this.jColorPane_spotRun.append(Color.green, "OK");
        } else {
            this.jColorPane_spotRun.append(Color.red, "FAILED");
        }
        this.jColorPane_spotRun.append(Color.black, "\n...[CHECK]: CONF - value of init.lhd.points is valid......");
        if (hlp.validIntNa(this.jTextField_CONFinitLhdPoints.getText())) {
            confInitLhdPointsCheck = true;
            this.jColorPane_spotRun.append(Color.green, "OK");
        } else {
            this.jColorPane_spotRun.append(Color.red, "FAILED");
        }
        this.jColorPane_spotRun.append(Color.black, "\n...[CHECK]: CONF - value of auto.loop.steps is valid......");
        if (hlp.validIntInf(this.jTextField_CONFautoLoopSteps.getText())) {
            confAutoLoopStepsCheck = true;
            this.jColorPane_spotRun.append(Color.green, "OK");
        } else {
            this.jColorPane_spotRun.append(Color.red, "FAILED");
        }
        this.jColorPane_spotRun.append(Color.black, "\n...[CHECK]: CONF - value of auto.loop.nevals is valid......");
        if (hlp.validIntInf(this.jTextField_CONFautoLoopNEvals.getText())) {
            confAutoLoopNevalsCheck = true;
            this.jColorPane_spotRun.append(Color.green, "OK");
        } else {
            this.jColorPane_spotRun.append(Color.red, "FAILED");
        }
        this.jColorPane_spotRun.append(Color.black, "\n...[CHECK]: CONF - auto.loop.nevals and auto.loop.steps can not both be 'Inf'......");
        if (!this.jTextField_CONFautoLoopNEvals.getText().equals("Inf") || !this.jTextField_CONFautoLoopSteps.getText().equals("Inf")) {
            LimitCheck = true;
            this.jColorPane_spotRun.append(Color.green, "OK");
        } else {
            this.jColorPane_spotRun.append(Color.red, "FAILED");
        }
        this.jColorPane_spotRun.append(Color.black, "\n...[CHECK]: CONF - value of seq.design.size is valid......");
        if (hlp.validIntNa(this.jTextField_CONFseqDesignSize.getText())) {
            confIStepSampleSizeCheck = true;
            this.jColorPane_spotRun.append(Color.green, "OK");
        } else {
            this.jColorPane_spotRun.append(Color.red, "FAILED");
        }
        this.jColorPane_spotRun.append(Color.black, "\n...note: additonal parameters are not checked, to assure full compatibility");
        confAdvancedConfCheck = true;
        if (algoScriptSelectedCheck && algoScriptExistCheck) {
            this.jLabel_checkSpotRun_algorithm.setIcon(this.iconCheckValid);
        } else {
            this.jLabel_checkSpotRun_algorithm.setIcon(this.iconCheckInvalid);
        }
        if (!this.path_Project.toString().equals("") && confProjectPrefixCheck) {
            this.pathFile_ProjectConf = new File(String.valueOf(this.path_Project.toString()) + this.FILE_SEPERATOR + this.jTextField_CONFprojectPrefix.getText() + ".conf");
            this.pathFile_ProjectRoi = new File(String.valueOf(this.path_Project.toString()) + this.FILE_SEPERATOR + this.jTextField_CONFprojectPrefix.getText() + ".roi");
        }
        if (roiBoundvaluesCheck && roiFactorCheck) {
            this.jLabel_checkSpotRun_roiConfig.setIcon(this.iconCheckValid);
            if (confProjectPathSelectedCheck && confProjectPrefixCheck) {
                writeROI = true;
            }
        } else {
            this.jLabel_checkSpotRun_roiConfig.setIcon(this.iconCheckInvalid);
        }
        if (algoScriptSelectedCheck && algoScriptExistCheck && confRFunctionSelectedCheck && confProjectPathSelectedCheck && confProjectPrefixCheck && confInitLhdPointsCheck && confAutoLoopStepsCheck && confAutoLoopNevalsCheck && LimitCheck && confIStepSampleSizeCheck && confAdvancedConfCheck) {
            this.jLabel_checkSpotRun_spoConfig.setIcon(this.iconCheckValid);
            writeCONF = true;
        } else {
            this.jLabel_checkSpotRun_spoConfig.setIcon(this.iconCheckInvalid);
        }
        if (pathRCheck) {
            this.jLabel_checkSpotRun_rPath.setIcon(this.iconCheckValid);
        } else {
            this.jLabel_checkSpotRun_rPath.setIcon(this.iconCheckInvalid);
        }
        if (writeROI) {
            this.jColorPane_spotRun.append(Color.black, "\n...[CONFIG FILES]: ROI - generate and write file......");
            if (fileIO.writeStrListTo(this.makeRoiValToStringList(), this.pathFile_ProjectRoi) == 0) {
                fileROICheck = true;
                this.jColorPane_spotRun.append(Color.green, "OK");
            } else {
                this.jColorPane_spotRun.append(Color.red, "FAILED");
            }
        }
        if (!writeROI) {
            this.jLabel_checkSpotRun_roiConfigFile.setIcon(this.iconCheckUnknown);
        } else if (fileROICheck) {
            this.jLabel_checkSpotRun_roiConfigFile.setIcon(this.iconCheckValid);
        } else {
            this.jLabel_checkSpotRun_roiConfigFile.setIcon(this.iconCheckInvalid);
        }
        if (writeCONF) {
            this.jColorPane_spotRun.append(Color.black, "\n...[CONFIG FILES]: CONF - generate and write file......");
            if (fileIO.writeStrListTo(this.makeConfValToStringList(), this.pathFile_ProjectConf) == 0) {
                fileCONFCheck = true;
                this.jColorPane_spotRun.append(Color.green, "OK");
            } else {
                this.jColorPane_spotRun.append(Color.red, "FAILED");
            }
        }
        if (!writeCONF) {
            this.jLabel_checkSpotRun_spoConfigFile.setIcon(this.iconCheckUnknown);
        } else if (fileCONFCheck) {
            this.jLabel_checkSpotRun_spoConfigFile.setIcon(this.iconCheckValid);
        } else {
            this.jLabel_checkSpotRun_spoConfigFile.setIcon(this.iconCheckInvalid);
        }
        if (fileROICheck && fileCONFCheck && pathRCheck) {
            this.jColorPane_spotRun.append(Color.green, "\nALL CHECKS PASSED SUCCESSFULLY ... FEEL FREE TO START SPOT");
            return 0;
        }
        this.jColorPane_spotRun.append(Color.red, "\nSOME CHECKS FAILED ... PLEASE RECONFIGURE FAILED PARTS");
        return -1;
    }

    private int exportSetting(File settingsFile) {
        int answer;
        if (this.pathFCDefaultExportSettigns.isFile() && (answer = JOptionPane.showConfirmDialog(this.exportMenuItem.getParent(), "The choosen file (" + this.pathFCDefaultExportSettigns.getName() + ") already exists. Do you want to overwrite? ", "File exists", 0, 3)) == 1) {
            return -1;
        }
        this.updateTableDim(this.roiTableDim);
        this.refreshConf();
        ArrayList<String> arrayListRoi = this.makeRoiValToStringList();
        ArrayList<String> arrayListConf = this.makeConfValToStringList();
        if (arrayListRoi == null) {
            System.err.println("exportSetting returned -2");
            return -2;
        }
        if (arrayListConf == null) {
            System.err.println("exportSetting returned -3");
            return -3;
        }
        ArrayList<String> arrayListSettings = new ArrayList<String>();
        int i = 0;
        while (i < arrayListRoi.size()) {
            arrayListSettings.add(arrayListRoi.get(i));
            ++i;
        }
        arrayListSettings.add(this.sepLineSettings);
        i = 0;
        while (i < arrayListConf.size()) {
            arrayListSettings.add(arrayListConf.get(i));
            ++i;
        }
        arrayListSettings.add(String.valueOf(this.jTextField_CONFprojectPath.getText()) + this.FILE_SEPERATOR + this.jTextField_CONFprojectPrefix.getText() + ".conf");
        int ret = fileIO.writeStrListTo(arrayListSettings, settingsFile);
        if (ret != 0) {
            System.err.println("exportSetting returned -4");
            return -4;
        }
        return 0;
    }

    private int importSetting(File settingsFile) {
        if (!settingsFile.isFile()) {
            System.err.println("importSetting returned -1");
            return -1;
        }
        ArrayList<String> arrayListSettings = fileIO.readToStrList(settingsFile);
        if (arrayListSettings == null) {
            System.err.println("importSetting returned -2");
            return -2;
        }
        ArrayList<String> arrayListRoi = new ArrayList<String>();
        ArrayList<String> arrayListConf = new ArrayList<String>();
        int indexOfSeperator = 0;
        boolean validSeperator = false;
        int i = 0;
        while (i < arrayListSettings.size()) {
            if (arrayListSettings.get(i).equals(this.sepLineSettings)) {
                indexOfSeperator = i;
                validSeperator = true;
                i = arrayListSettings.size();
            }
            ++i;
        }
        if (!validSeperator) {
            System.err.println("ERROR(importSetting): File does not contain the valid separator for settings files (" + this.sepLineSettings + ")");
            return -3;
        }
        i = 0;
        while (i < indexOfSeperator) {
            arrayListRoi.add(arrayListSettings.get(i));
            ++i;
        }
        i = indexOfSeperator + 1;
        while (i < arrayListSettings.size() - 1) {
            arrayListConf.add(arrayListSettings.get(i));
            ++i;
        }
        this.pathFile_ProjectConf = new File(arrayListSettings.get(arrayListSettings.size() - 1));
        int retRoi = this.makeStringListToRoiVal(arrayListRoi);
        int retConf = this.makeStringListToConfVal(arrayListConf);
        if (retRoi != 0 || retConf != 0) {
            if (retRoi != 0 && retConf != 0) {
                System.err.println("importSetting returned -4");
                return -4;
            }
            if (retRoi != 0) {
                System.err.println("importSetting returned -5");
                return -5;
            }
            System.err.println("importSetting returned -6");
            return -6;
        }
        this.loadConfValues(this.pathFile_ProjectConf);
        return 0;
    }

    public void systemCheck() {
        boolean error = false;
        if (SystemUtils.FILE_SEPARATOR == null) {
            System.err.println("Could not read SystemUtils.FILE_SEPARATOR");
            error = true;
        }
        if (SystemUtils.LINE_SEPARATOR == null) {
            System.err.println("Could not read SystemUtils.LINE_SEPARATOR");
            error = true;
        }
        if (Boolean.valueOf(SystemUtils.IS_OS_WINDOWS) == null) {
            System.err.println("Could not read SystemUtils.IS_OS_WINDOWS");
            error = true;
        }
        if (Boolean.valueOf(SystemUtils.IS_OS_LINUX) == null) {
            System.err.println("Could not read SystemUtils.IS_OS_LINUX");
            error = true;
        }
        if (Boolean.valueOf(SystemUtils.IS_OS_MAC) == null) {
            System.err.println("Could not read SystemUtils.IS_OS_MAC");
            error = true;
        }
        if (error) {
            return;
        }
        this.IS_OS_WINDOWS = SystemUtils.IS_OS_WINDOWS;
        this.IS_OS_LINUX = SystemUtils.IS_OS_LINUX;
        this.IS_OS_MAC = SystemUtils.IS_OS_MAC;
        this.FILE_SEPERATOR = SystemUtils.FILE_SEPARATOR;
        this.LINE_SEPERATOR = SystemUtils.LINE_SEPARATOR;
        if (this.globalDEBUG) {
            System.out.println("\n### SYSTEM CHECK START ###");
        }
        if (this.globalDEBUG) {
            System.out.println("Current JVM version: " + System.getProperty("java.version"));
        }
        if (SystemUtils.IS_JAVA_1_6) {
            if (this.globalDEBUG) {
                System.out.println("   ==> JVM-CHECK: valid");
            }
        } else {
            System.err.println("   ==> JVM-CHECK Warning: At least Java 1.6 is required for this application.");
        }
        if (this.globalDEBUG) {
            System.out.println("Current operating system: " + System.getProperty("os.name") + " (OS-Architecture: " + System.getProperty("os.arch") + ", OS-Version: " + System.getProperty("os.version") + ")");
        }
        if (this.IS_OS_WINDOWS || this.IS_OS_LINUX || this.IS_OS_MAC) {
            if (this.globalDEBUG) {
                System.out.println("   ==> OS-CHECK: valid");
            }
        } else {
            System.err.println("   ==> OS-CHECK Warning: This application was only tested under Windows (XP), Linux, MAC OS and may cause problems on your platform.");
        }
        if (this.globalDEBUG) {
            System.out.println("IS OS WINDOWS: " + this.IS_OS_WINDOWS);
        }
        if (this.globalDEBUG) {
            System.out.println("IS OS LINUX: " + this.IS_OS_LINUX);
        }
        if (this.globalDEBUG) {
            System.out.println("IS OS MAC: " + this.IS_OS_MAC);
        }
        if (this.globalDEBUG) {
            System.out.println("OS FILE SEPERATOR: " + hlp.strQuote(this.FILE_SEPERATOR));
        }
        if (this.globalDEBUG) {
            System.out.println("### SYSTEM CHECK END ###\n");
        }
        if (!this.IS_OS_WINDOWS) {
            this.setRPathMenuItem.setEnabled(false);
            this.setRPathMenuItem.setVisible(false);
        }
    }

    private void loadPathSetup(File psFile) {
        if (this.pathFile_SetupProperties.exists()) {
            try {
                this.setupProperties.loadFromXML(new FileInputStream(psFile));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.setupProperties.containsKey("pathFile_R")) {
                File tmp = new File(this.setupProperties.getProperty("pathFile_R"));
                if (this.IS_OS_WINDOWS && !tmp.toString().equals("") && tmp.exists()) {
                    this.pathFCDefaultRPATH = this.pathFile_R = tmp;
                    this.setupPropertieExist = true;
                    if (this.globalDEBUG) {
                        System.out.println("re-loaded pathFile_R:\"" + this.pathFile_R.toString() + "\"");
                    }
                }
            }
            if (!this.setupPropertieExist && !this.IS_OS_LINUX) {
                JOptionPane.showMessageDialog(this.jFrame, "Your path setup file was removed, because it was invalid. Please do the \"Path setup\", to assure comfortable and proper usage.", "Information", 0);
                psFile.delete();
            }
        } else if (!this.IS_OS_LINUX) {
            JOptionPane.showMessageDialog(this.jFrame, "If this is the first time the GUI is launched, please do the \"Path setup\" first of all, to assure comfortable and proper usage.", "Information", 1);
        }
    }

    public class ColorPane
    extends JTextPane {
        private static final long serialVersionUID = 9915L;

        public void append(Color c, String s) {
            boolean flag = false;
            if (!this.isEditable()) {
                flag = true;
                this.setEditable(true);
            }
            StyleContext sc = StyleContext.getDefaultStyleContext();
            AttributeSet aset = sc.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, c);
            int len = this.getDocument().getLength();
            this.setCaretPosition(len);
            this.setCharacterAttributes(aset, false);
            this.replaceSelection(s);
            if (flag) {
                this.setEditable(false);
            }
            this.repaint();
        }
    }

    class myTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        myTableModel() {
        }

        @Override
        public int getColumnCount() {
            return spotGuiMain.this.roiTableColumnNames.length;
        }

        @Override
        public int getRowCount() {
            return spotGuiMain.this.roiTableDim;
        }

        @Override
        public Object getValueAt(int r, int c) {
            return spotGuiMain.this.roiTableData[r][c];
        }

        @Override
        public String getColumnName(int i) {
            return spotGuiMain.this.roiTableColumnNames[i];
        }

        public Class getColumnClass(int i) {
            return this.getValueAt(0, i).getClass();
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return true;
        }

        @Override
        public void setValueAt(Object val, int r, int c) {
            boolean isValidType = false;
            if (val.toString().equalsIgnoreCase(spotGuiMain.this.roiTableTypes[0]) || val.toString().equalsIgnoreCase(spotGuiMain.this.roiTableTypes[1]) || val.toString().equalsIgnoreCase(spotGuiMain.this.roiTableTypes[2])) {
                isValidType = true;
            }
            if (c == 0) {
                if (spotGuiMain.this.isRegExString(val.toString())) {
                    ((spotGuiMain)spotGuiMain.this).roiTableData[r][c] = new String(val.toString());
                } else {
                    JOptionPane.showMessageDialog(spotGuiMain.this.jTextField_ROIdim.getParent(), "Wrong name format. Allowed characters are: A-Z, a-z, _ and 0-9. Note, that the name have to start with a letter.   (Invalid value was: \"" + val.toString() + "\" in column " + spotGuiMain.this.roiTableColumnNames[c] + " @ parameter " + spotGuiMain.this.jTable_ROI.getValueAt(r, 0) + ")", "Value type error", 0);
                }
            } else if (c == 1 || c == 2) {
                if (spotGuiMain.this.isRegExInt(val.toString()) != null) {
                    ((spotGuiMain)spotGuiMain.this).roiTableData[r][c] = new String(spotGuiMain.this.isRegExInt(val.toString()));
                } else if (spotGuiMain.this.isRegExFloat(val.toString()) != null) {
                    String temp = spotGuiMain.this.isRegExFloat(val.toString());
                    if (temp.endsWith(".0")) {
                        temp = temp.replace(".0", "");
                    }
                    ((spotGuiMain)spotGuiMain.this).roiTableData[r][c] = new String(temp);
                } else if (hlp.isRegExPosInf(val.toString())) {
                    ((spotGuiMain)spotGuiMain.this).roiTableData[r][c] = new String("Inf");
                } else if (hlp.isRegExNegInf(val.toString())) {
                    ((spotGuiMain)spotGuiMain.this).roiTableData[r][c] = new String("-Inf");
                } else {
                    JOptionPane.showMessageDialog(spotGuiMain.this.jTextField_ROIdim.getParent(), "Type of value have to be INT or FLOAT. Other allowed values are: Inf and -Inf.   (Invalid value was: \"" + val.toString() + "\" in column " + spotGuiMain.this.roiTableColumnNames[c] + " @ parameter " + spotGuiMain.this.jTable_ROI.getValueAt(r, 0) + ")", "Value type error", 0);
                }
            } else if (c == 3) {
                if (isValidType) {
                    ((spotGuiMain)spotGuiMain.this).roiTableData[r][c] = new String(val.toString());
                } else {
                    JOptionPane.showMessageDialog(spotGuiMain.this.jTextField_ROIdim.getParent(), "Type have to be INT, FLOAT or FACTOR   (Invalid value was: \"" + val.toString() + "\" in column " + spotGuiMain.this.roiTableColumnNames[c] + " @ parameter " + spotGuiMain.this.jTable_ROI.getValueAt(r, 0) + ")", "Value type error", 0);
                }
            }
            this.fireTableCellUpdated(r, c);
        }
    }
}

