% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/spotReportContour.R
\name{spotReportContour}
\alias{spotReportContour}
\title{Model Contour Plot -  Report Function}
\usage{
spotReportContour(spotConfig)
}
\arguments{
\item{spotConfig}{the configuration list of all spot parameters. \cr
The parameter spotConfig$report.interactive=TRUE will be set as default if not contained in the list.
That means, by default the user will be asked to specify which parameters will be varied when the report is started. This is done in a small twiddler GUI.
If the user wants to specify which parameters should be plotted against each other, before starting the report, he can
set the parameter spotConfig$report.aIndex and spotConfig$report.bIndex. They should be two different integer numbers. They will only be used if
spotConfig$report.interactive is FALSE. By default they will be set to 1 and 2, so the first two parameters in the ROI will be plotted.
In case of a multi objective problem, spotConfig$report.cIndex will determine which point from the Pareto front will be used to determine values of
parameters not on the axis of the plot.}
}
\description{
Function to generate a contour plot of the predicted meta model.
}
\details{
This report function uses the parameter spotConfig$seq.modelFit to plot the predicted model.
If spotConfig$seq.modelFit is NULL, the model is generated, based on spotConfig$seq.predictionModel.func.
It is not recommended to use this function at the end of an "auto" run of SPOT, make sure to save results first.
By default, twiddler will be used to let the user specify which of the parameters should be varied in the plot.
Values not varied in the graph are fixed to their "best" value according to the current Results.
}
\seealso{
\code{\link{spotSurfContour}}
}

