% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateKriging.R
\name{simulate.kriging}
\alias{simulate.kriging}
\title{Kriging Simulation}
\usage{
\method{simulate}{kriging}(
  object,
  nsim = 1,
  seed = NA,
  xsim,
  method = "decompose",
  conditionalSimulation = TRUE,
  Ncos = 10,
  returnAll = FALSE,
  ...
)
}
\arguments{
\item{object}{fit of the Kriging model (settings and parameters), of class \code{kriging}.}

\item{nsim}{number of simulations}

\item{seed}{random number generator seed. Defaults to NA, in which case no seed is set}

\item{xsim}{list of samples in input space, to be simulated at}

\item{method}{\code{"decompose"} (default) or \code{"spectral"}, specifying the method used for simulation. 
Note that \code{"decompose"} is can be preferable, since it is exact but may be computationally infeasible for high-dimensional xsim.
On the other hand, \code{"spectral"} yields a function that can be evaluated at arbitrary sample locations.}

\item{conditionalSimulation}{logical, if set to TRUE (default), the simulation is conditioned with the training data of the Kriging model.
Else, the simulation is non-conditional.}

\item{Ncos}{number of cosine functions (used with \code{method="spectral"} only)}

\item{returnAll}{if set to TRUE, a list with the simulated values (y) and the corresponding covariance matrix (covar)
of the simulated samples is returned.}

\item{...}{further arguments, not used}
}
\value{
Returned value depends on the setting of \code{object$simulationReturnAll}
}
\description{
(Conditional) Simulation at given locations, with a model fit resulting from \code{\link{buildKriging}}.
In contrast to prediction or estimation, the goal is to reproduce the covariance 
structure, rather than the data itself. Note, that the conditional simulation 
also reproduces the training data, but
has a two times larger error than the Kriging predictor.
}
\references{
N. A. Cressie. Statistics for Spatial Data. JOHN WILEY & SONS INC, 1993.

C. Lantuejoul. Geostatistical Simulation - Models and Algorithms. Springer-Verlag Berlin Heidelberg, 2002.
}
\seealso{
\code{\link{buildKriging}}, \code{\link{predict.kriging}}
}
