% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTaskCensus.R
\name{get_task_census}
\alias{get_task_census}
\title{Get Census KDD data set (+variation)}
\usage{
get_task_census(
  task.type = "classif",
  nobs = 50000,
  nfactors = "high",
  nnumericals = "high",
  cardinality = "high",
  data.seed = 1,
  cachedir = "../oml.cache"
)
}
\arguments{
\item{task.type}{character, either "classif" or "regr".}

\item{nobs}{integer, number of observations uniformly sampled from the full data set.}

\item{nfactors}{character, controls the number of factors (categorical features) to use. Can be "low", "med", "high", or "full" (full corresponds to original data set).}

\item{nnumericals}{character, controls the number of numerical features to use. Can be "low", "med", "high", or "full" (full corresponds to original data set).}

\item{cardinality}{character, controls the number of factor levels (categories) for the categorical features. Can be "low", "med", "high" (high corresponds to original data set).}

\item{data.seed}{integer, this will be used via set.seed() to make the random subsampling reproducible. Will not have an effect if all observations are used.}

\item{cachedir}{the cache directory.}
}
\value{
an mlr task with the respective data set
}
\description{
This function downloads (or loads from cache folder) the Census
KDD Dataset (OpenML ID: 4535).
If requested, data set is changed w.r.t the number of observations, number of
numerical/categorical feature,
the cardinality of the categorical features, and the task type (regr. or classif).
}
