% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms.image_methods.R
\name{closeImage,ms.image-method}
\alias{closeImage,ms.image-method}
\alias{closeImage}
\title{Apply morphological closing to binary image.}
\usage{
\S4method{closeImage}{ms.image}(object, kern.size = 5)
}
\arguments{
\item{object}{\link{ms.image-class} object. See \link{msImage}.}

\item{kern.size}{numeric. Kernel size.}
}
\value{
\link{ms.image-class} object after closing.
}
\description{
Apply morphological closing to binary image.
}
\examples{
## Load package
library("SPUTNIK")

## Create ms.image-class object
msIm <- msImage(values = matrix(rnorm(200), 40, 50), name = "test", scale = TRUE)

## Generate binary image
msImBin <- refImageBinaryOtsu(msIm)

## Apply the morphological closing
msImClosed <- closeImage(msImBin, kern.size = 3)
}
