% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forEasySdcTable.R
\encoding{UTF8}
\name{FindTableGroup}
\alias{FindTableGroup}
\title{Finding table(s) of hierarchical variable groups}
\usage{
FindTableGroup(x = NULL, findLinked = FALSE, mainName = TRUE,
  fCorr = FactorLevCorr(x), CheckHandling = warning)
}
\arguments{
\item{x}{Matrix or data frame containing the variables}

\item{findLinked}{When TRUE, two linked tables can be in output}

\item{mainName}{When TRUE the groupVarInd ouput is named according to first variable in group.}

\item{fCorr}{When non-null x is not needed as input.}

\item{CheckHandling}{Function (warning or stop) to be used in problematic situations.}
}
\value{
Output is a list with items
 \item{groupVarInd}{List defining the hierarchical variable groups. First variable has most levels.}
 \item{table}{List containing one or two tables. These tables are coded as indices referring to elements of groupVarInd.}
}
\description{
A single table or two linked tables are found
}
\examples{
 x <- rep(c('A','B','C'),3)
 y <- rep(c(11,22,11),3)
 z <- c(1,1,1,2,2,2,3,3,3)
 zy <- paste(z,y,sep='')
 m <- cbind(x,y,z,zy)
 FindTableGroup(m)
 FindTableGroup(m,findLinked=TRUE)
}
\author{
Øyvind Langsrud
}
