% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hierarchies2ModelMatrix.R
\name{Hierarchies2ModelMatrix}
\alias{Hierarchies2ModelMatrix}
\title{Model matrix representing crossed hierarchies}
\usage{
Hierarchies2ModelMatrix(data, hierarchies, inputInOutput = TRUE,
  crossTable = FALSE, total = "Total", hierarchyVarNames = c(mapsFrom
  = "mapsFrom", mapsTo = "mapsTo", sign = "sign", level = "level"),
  unionComplement = FALSE)
}
\arguments{
\item{data}{Matrix or data frame with data containing codes of relevant variables}

\item{hierarchies}{List of hierarchies, which can be converted by \code{\link{AutoHierarchies}}.
Thus, the variables can also be coded by \code{"rowFactor"} or \code{""}, which correspond to using the categories in the data.}

\item{inputInOutput}{Logical vector (possibly recycled) for each element of hierarchies.
TRUE means that codes from input are included in output. Values corresponding to \code{"rowFactor"} or \code{""} are ignored.}

\item{crossTable}{Cross table in output when TRUE}

\item{total}{Vector of total codes (possibly recycled) used when running \code{\link{Hrc2DimList}}}

\item{hierarchyVarNames}{Variable names in the hierarchy tables as in \code{\link{HierarchyFix}}}

\item{unionComplement}{Logical vector (possibly recycled) for each element of hierarchies.
When TRUE, sign means union and complement instead of addition or subtraction. 
Values corresponding to \code{"rowFactor"} and \code{"colFactor"} are ignored.}
}
\value{
A sparse model matrix or a list of two elements (model matrix and cross table)
}
\description{
Make a model matrix, x, that corresponds to data and represents all hierarchies crossed.
This means that aggregates corresponding to numerical variables can be computed as 
\code{t(x) \%*\% y}, where  \code{y} is a matrix with one column for each numerical variable.
}
\details{
This function makes use of \code{\link{AutoHierarchies}}
and \code{\link{HierarchyCompute}}  via  \code{\link{HierarchyComputeDummy}}
}
\examples{
# Create some input
z <- SSBtoolsData("sprt_emp_withEU")
ageHier <- SSBtoolsData("sprt_emp_ageHier")
geoDimList <- FindDimLists(z[, c("geo", "eu")], total = "Europe")[[1]]

# First example has list output
Hierarchies2ModelMatrix(z, list(age = ageHier, geo = geoDimList), inputInOutput = FALSE, 
                        crossTable = TRUE)

m1 <- Hierarchies2ModelMatrix(z, list(age = ageHier, geo = geoDimList), inputInOutput = FALSE)
m2 <- Hierarchies2ModelMatrix(z, list(age = ageHier, geo = geoDimList))
m3 <- Hierarchies2ModelMatrix(z, list(age = ageHier, geo = geoDimList, year = ""),
                              inputInOutput = FALSE)
m4 <- Hierarchies2ModelMatrix(z, list(age = ageHier, geo = geoDimList, year = "allYears"), 
                              inputInOutput = c(FALSE, FALSE, TRUE))

# Illustrate the effect of unionComplement, geoHier2 as in the examples of HierarchyCompute
geoHier2 <- rbind(data.frame(mapsFrom = c("EU", "Spain"), mapsTo = "EUandSpain", sign = 1), 
                  SSBtoolsData("sprt_emp_geoHier")[, -4])
m5 <- Hierarchies2ModelMatrix(z, list(age = ageHier, geo = geoHier2, year = "allYears"), 
                              inputInOutput = FALSE)  # Spain is counted twice
m6 <- Hierarchies2ModelMatrix(z, list(age = ageHier, geo = geoHier2, year = "allYears"), 
                              inputInOutput = FALSE, unionComplement = TRUE)

# Compute aggregates
ths_per <- as.matrix(z[, "ths_per", drop = FALSE])  # matrix with the values to be aggregated
t(m1) \%*\% ths_per  # crossprod(m1, ths_per) is equivalent and faster
t(m2) \%*\% ths_per
t(m3) \%*\% ths_per
t(m4) \%*\% ths_per
t(m5) \%*\% ths_per
t(m6) \%*\% ths_per
}
\author{
Øyvind Langsrud
}
