% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extend0.R
\name{Extend0}
\alias{Extend0}
\title{Add zero frequency rows}
\usage{
Extend0(
  data,
  freqName = "freq",
  hierarchical = TRUE,
  varGroups = NULL,
  dimVar = NULL,
  extraVar = TRUE
)
}
\arguments{
\item{data}{data frame}

\item{freqName}{Name of (existing) frequency variable}

\item{hierarchical}{Hierarchical variables treated atomatically when \code{TRUE}}

\item{varGroups}{List of variable groups, possibly with data (see details and examples).}

\item{dimVar}{The dimensional variables}

\item{extraVar}{Extra variables as variable names, TRUE (all remaining) or FALSE (none).}
}
\value{
Extended data frame
}
\description{
Microdata or tabular frequency data is extended to contain all combinations of unique rows
of (hierarchical) groups of dimensional variables. Extra variables are extended by \code{NA}'s or \code{0}'s.
}
\details{
With no frequency variable in input (microdata), the frequency variable in output  consists of ones and zeros.
By default, all variables, except the frequencies, are considered as dimensional variables.
By default, the grouping of dimensional variables is based on hierarchical relationships (\code{hierarchical = TRUE}).
With \code{varGroups = NULL} and \code{hierarchical = FALSE},
each dimensional variable forms a separate group (as \code{as.list(dimVar)}).
Parameter \code{extraVar} can be specified as variable names.
\code{TRUE} means all remaining variables and \code{FALSE} no variables.

When the contents of \code{varGroups[[i]]} is variable names, the data frame \code{unique(data[varGroups[[i]]])} will be made as a
building block within the function. A possibility is to supply such a data frame instead of variable names.
Then, the building block will be \code{unique(varGroups[[i]])}. Names and data frames can be mixed.
}
\examples{
z <- SSBtoolsData("sprt_emp_withEU")[c(1, 4:6, 8, 11:15), ]
z$age[z$age == "Y15-29"] <- "young"
z$age[z$age == "Y30-64"] <- "old"

Extend0(z[, -4])
Extend0(z, hierarchical = FALSE, dimVar = c("age", "geo", "eu"))
Extend0(z, hierarchical = FALSE, dimVar = c("age", "geo", "eu"), extraVar = "year")
Extend0(z, hierarchical = FALSE, dimVar = c("age", "geo", "eu"), extraVar = FALSE)
Extend0(z, varGroups = list(c("age", "geo", "year"), "eu"))
Extend0(MakeFreq(z[c(1, 1, 1, 2, 2, 3:10), -4]))
Extend0(z, "ths_per")

# varGroups with data frames (same result as with names above)
Extend0(z, varGroups = list(z[c("age", "geo", "year")], z["eu"]))

# varGroups with both names and data frame
Extend0(z, varGroups = list(c("year", "geo", "eu"), data.frame(age = c("middle", "old"))))
}
