% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_by_variable.R
\name{filter_by_variable}
\alias{filter_by_variable}
\alias{names_by_variable}
\title{Filter a List of Items or Retrieve Names by a Variable}
\usage{
filter_by_variable(variable, items, variable_mapping)

names_by_variable(variable, variable_mapping)
}
\arguments{
\item{variable}{A character string. The variable to filter the items by.}

\item{items}{A named list of elements. These can be any type of objects (e.g., formulas, data, etc.).}

\item{variable_mapping}{A named list. Each element is a character vector of variables associated
with the corresponding item in \code{items}. The names of the list in \code{variable_mapping} should match
the names of the list in \code{items}.}
}
\value{
\itemize{
\item \code{filter_by_variable()}: A named list containing a subset of \code{items} where each element is
associated with the specified \code{variable}. If no matches are found, an empty list is returned.
\item \code{names_by_variable()}: A character vector of names from \code{variable_mapping} that are associated
with the specified \code{variable}. If no matches are found, an empty character vector is returned.
}
}
\description{
Filters a list of items, retaining only those associated with a specific variable,
or retrieves the names of items associated with the variable. The association between
items and variables is provided via a named list, where each element contains a
vector of variables corresponding to an item in \code{items}.
}
\details{
\code{filter_by_variable()} returns the filtered list of items, whereas
\code{names_by_variable()} is a simpler function that just returns the names of the items.
}
\note{
This function is written and documented by ChatGPT after some discussion.
The examples have been chosen to be relevant in connection with the
\code{\link{tables_by_formulas}} function.
}
\examples{

items <- list(
  table_1 = ~region * sector2, 
  table_2 = ~region1:sector4 - 1, 
  table_3 = ~region + sector4 - 1
)

variable_mapping <- list(
  table_3 = c("z", "y"), 
  table_1 = c("value", "x"), 
  table_2 = c("value", "x", "y")
)

filter_by_variable("value", items, variable_mapping)
filter_by_variable("y", items, variable_mapping)
filter_by_variable("nonexistent", items, variable_mapping)

names_by_variable("value", variable_mapping)
names_by_variable("y", variable_mapping)
names_by_variable("nonexistent", variable_mapping)

}
