% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSubsetHaplo.R
\name{dataSubsetHaplo}
\alias{dataSubsetHaplo}
\title{Dataset manipulation for haplotypes}
\usage{
dataSubsetHaplo(haplotype, filename, AFND, alignments)
}
\arguments{
\item{haplotype}{A haplotype where allele names are written in the IPD-IMGT/HLA Database format, and have 1-4 fields. Alleles in haplotypes may be delimited by "-" or "~".}

\item{filename}{The full file path of the user specified dataset if the user wishes to use their own file, or pre-bundled mock haplotype dataset. User provided datasets must be a .dat, .txt, or.csv file, and must conform to the structure and format of the mock haplotype dataset bundled with the package.}

\item{AFND}{A logical parameter that determines whether the user specified dataset is data from AFND. This parameter is only relevant if haplotype maps are being made.}

\item{alignments}{A list object of sub-lists of data frames of protein alignments for the HLA and HLA-region genes supported in the ANHIG/IMGTHLA GitHub Repository. Alignments will always be the most recent version IPD-IMGT/HLA Database version.}
}
\value{
A two element list with 1) a subset data frame containing only haplotypes with alleles present in the user input haplotype, and 2) a data frame of the full dataset. Alleles with two fields will be evaluated with their three and four field allele equivalents, and alleles with three fields will be evaluated with their four field allele equivalent. Otherwise, a vector containing FALSE and an error message is returned.
}
\description{
Returns the user input dataset that contains the selected haplotype.
}
\note{
For internal SSHAARP use only.
}
