% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssim_raster.R
\name{ssim_raster}
\alias{ssim_raster}
\title{The SSIM index for raster images.}
\usage{
ssim_raster(img1, img2, global = TRUE, w = 3, k1 = NULL, k2 = NULL)
}
\arguments{
\item{img1}{A \code{terra} raster object representing the first image.}

\item{img2}{A \code{terra} raster object representing the second image.}

\item{global}{If global is TRUE, returning the global average of SSIM, SIM, SIV, and SIP. If the option is FALSE, a \code{terra} raster brick containing the SSIM, SIM, SIV, and SIP
for each cell is returned.Default is TRUE.}

\item{w}{Integer specifying the window size for the local neighborhood. Default is 3.}

\item{k1}{The constant used in the SSIM calculation. Default is NULL, in which case it is computed from the maximum value of the images.}

\item{k2}{The constant used in the SSIM calculation. Default is NULL, in which case it is computed from the maximum value of the images.}
}
\value{
If global is TRUE, returning the global average of SSIM, SIM, SIV, and SIP. If the option is FALSE, a \code{terra} raster brick containing the SSIM, SIM, SIV, and SIP for each cell is returned.
}
\description{
This function calculates the SSIM, a measure of similarity between two raster images
}
\details{
This function computes the SSIM index for two raster images.
}
\examples{
single<-system.file("/ex/single2nm.tif", package="SSIMmap")
group<-system.file("/ex/groups2nm.tif", package="SSIMmap")
whale_single<-terra::rast(single)
whale_groups<-terra::rast(group)
ssim_raster(whale_single,whale_groups)
result_raster<-ssim_raster(whale_single,whale_groups,global=FALSE)
}
