% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WellSVM.R
\name{WellSVMSSLR}
\alias{WellSVMSSLR}
\title{General Interface for WellSVM model}
\usage{
WellSVMSSLR(
  C1 = 1,
  C2 = 0.1,
  gamma = 1,
  x_center = TRUE,
  scale = FALSE,
  use_Xu_for_scaling = FALSE,
  max_iter = 20
)
}
\arguments{
\item{C1}{double; A regularization parameter for labeled data, default 1;}

\item{C2}{double; A regularization parameter for unlabeled data, default 0.1;}

\item{gamma}{double; Gaussian kernel parameter, i.e., k(x,y) = exp(-gamma^2||x-y||^2/avg) where avg is the average distance among instances; when gamma = 0, linear kernel is used. default gamma = 1;}

\item{x_center}{logical;  Should the features be centered?}

\item{scale}{logical; Should the features be normalized? (default: FALSE)}

\item{use_Xu_for_scaling}{logical; whether the unlabeled objects should be used to determine the mean and scaling for the normalization}

\item{max_iter}{integer; Maximum number of iterations}
}
\description{
model from RSSL package
WellSVM is a minimax relaxation of the mixed integer programming problem of finding the
optimal labels for the unlabeled data in the SVM objective function.
This implementation is a translation of the Matlab implementation of Li (2013) into R.
}
\examples{
library(tidyverse)
library(tidymodels)
library(caret)
library(SSLR)

data(breast)

set.seed(1)
train.index <- createDataPartition(breast$Class, p = .7, list = FALSE)
train <- breast[ train.index,]
test  <- breast[-train.index,]

cls <- which(colnames(breast) == "Class")

#\% LABELED
labeled.index <- createDataPartition(breast$Class, p = .2, list = FALSE)
train[-labeled.index,cls] <- NA


m <- WellSVMSSLR() \%>\% fit(Class ~ ., data = train)


#Accuracy
predict(m,test) \%>\%
  bind_cols(test) \%>\%
  metrics(truth = "Class", estimate = .pred_class)

}
\references{
Y.-F. Li, I. W. Tsang, J. T. Kwok, and Z.-H. Zhou. Scalable and Convex Weakly Labeled SVMs. Journal of Machine Learning Research, 2013.

R.-E. Fan, P.-H. Chen, and C.-J. Lin. Working set selection using second order information for training SVM. Journal of Machine Learning Research 6, 1889-1918, 2005.
}
