% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudoR2.R
\name{pseudoR2.SSN2}
\alias{pseudoR2.SSN2}
\alias{pseudoR2.ssn_lm}
\alias{pseudoR2.ssn_glm}
\title{Compute a pseudo r-squared}
\usage{
\method{pseudoR2}{ssn_lm}(object, adjust = FALSE, ...)

\method{pseudoR2}{ssn_glm}(object, adjust = FALSE, ...)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{adjust}{A logical indicating whether the pseudo r-squared
should be adjusted to account for the number of explanatory variables. The
default is \code{FALSE}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
The pseudo r-squared as a numeric vector.
}
\description{
Compute a pseudo r-squared for a fitted model object.
}
\details{
Several pseudo r-squared statistics exist for in the literature.
We define this pseudo r-squared as one minus the ratio of the deviance of a full model
relative to the deviance of a null (intercept only) model. This pseudo r-squared
can be viewed as a generalization of the classical r-squared definition
seen as one minus the ratio of error sums of squares from the full model relative
to the error sums of squares from the null model. If adjusted, the adjustment
is analogous to the the classical r-squared adjustment.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
pseudoR2(ssn_mod)
}
