% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hatvalues.R
\name{hatvalues.SSN2}
\alias{hatvalues.SSN2}
\alias{hatvalues.ssn_lm}
\alias{hatvalues.ssn_glm}
\title{Compute leverage (hat) values}
\usage{
\method{hatvalues}{ssn_lm}(model, ...)

\method{hatvalues}{ssn_glm}(model, ...)
}
\arguments{
\item{model}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}
}
\value{
A vector of leverage (hat) values for each observation from the
fitted model object.
}
\description{
Compute the leverage (hat) value for each observation from a fitted
model object.
}
\details{
Leverage values measure how far an observation's explanatory variables
are relative to the average of the explanatory variables. In other words, observations with high
leverage are typically considered to have an extreme or unusual combination of explanatory
variables. Leverage values are the diagonal of the hat (projection) matrix.
The larger the hat value, the larger the leverage.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
hatvalues(ssn_mod)
}
\seealso{
\code{\link[=augment.SSN2]{augment.SSN2()}} \code{\link[=cooks.distance.SSN2]{cooks.distance.SSN2()}} \code{\link[=influence.SSN2]{influence.SSN2()}} \code{\link[=residuals.SSN2]{residuals.SSN2()}}
}
