% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{display_motifsSTSeries}
\alias{display_motifsSTSeries}
\title{Plot the selected spatial-time series with the selected motifs highlighted}
\usage{
display_motifsSTSeries(dataset, rmotifs, space = c(1:length(dataset)))
}
\arguments{
\item{dataset}{Dataset containing numeric values}

\item{rmotifs}{List of ranked motifs}

\item{space}{Select a range of columns to plot the corresponding spatial series}
}
\value{
Selected spatial series with the selected motifs highlighted
}
\description{
Plot the selected spatial-time series with the selected motifs highlighted
}
\examples{
#Launch all the workflow
#Plot the result
D  <- STMotif::example_dataset
DS <- NormSAX(STMotif::example_dataset,5)
stmotifs <- SearchSTMotifs(D,DS,4,5,4,10,2,2)
rstmotifs <- RankSTMotifs(stmotifs)
display_motifsSTSeries(dataset = STMotif::example_dataset,rstmotifs[c(1:4)],space = c(1:4,10:12))
}
