% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothUnit.R
\name{smoothUnit}
\alias{smoothUnit}
\title{Smooth via unit level model}
\usage{
smoothUnit(
  formula,
  domain,
  design,
  family = c("gaussian", "binomial")[1],
  Amat = NULL,
  X.pop = NULL,
  domain.size = NULL,
  pc.u = 1,
  pc.alpha = 0.01,
  pc.u.phi = 0.5,
  pc.alpha.phi = 2/3,
  CI = 0.95,
  n.sample = 250
)
}
\arguments{
\item{formula}{an object of class "formula" describing the model to be fitted.}

\item{domain}{formula specifying variable containing domain labels}

\item{design}{an object of class "svydesign" containing the data for the model}

\item{family}{of the response variable, currently supports 'binomial' (default with logit link function) or 'gaussian'.}

\item{Amat}{Adjacency matrix for the regions. If set to NULL, the IID spatial effect will be used.}

\item{X.pop}{unit-level covariates data frame. One of the column name needs to match the domain specified, in order to be linked to the data input. Currently only supporting time-invariant domain-level covariates.}

\item{domain.size}{Domain size data frame. One of the column name needs to match the domain specified, in order to be linked to the data input and there must be a size column containing domain sizes.}

\item{pc.u}{hyperparameter U for the PC prior on precisions.}

\item{pc.alpha}{hyperparameter alpha for the PC prior on precisions.}

\item{pc.u.phi}{hyperparameter U for the PC prior on the mixture probability phi in BYM2 model.}

\item{pc.alpha.phi}{hyperparameter alpha for the PC prior on the mixture probability phi in BYM2 model.}

\item{CI}{the desired posterior credible interval to calculate}

\item{n.sample}{number of draws from posterior used to compute summaries}
}
\value{
A list with elements
\item{direct.est}{direct estimates}
\item{model.fit}{fitted INLA object for iid domain effects model}
\item{model.est}{smoothed estimates}
}
\description{
Generates small area estimates by smoothing direct estimates using a unit 
level model
}
\examples{
\dontrun{
library(survey)
data(DemoData2)
data(DemoMap2)
des0 <- svydesign(ids = ~clustid+id, strata = ~strata,
                 weights = ~weights, data = DemoData2, nest = T)
                 
EXAMPLE 1: Continuous response model
cts.res <- smoothUnit(formula = tobacco.use ~ 1,
                      domain = ~region,
                      design = des0, X.pop = DemoData2)
                      
EXAMPLE 2: Binary response model
bin.res <- smoothUnit(formula = tobacco.use ~ 1,
                      family = "binomial",
                      domain = ~region,
                      design = des0, X.pop = DemoData2)
}
}
