% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{print.SUMMERprojlist}
\alias{print.SUMMERprojlist}
\title{Print method for the combined projection output.}
\usage{
\method{print}{SUMMERprojlist}(x, ...)
}
\arguments{
\item{x}{output from \code{\link{getSmoothed}}}

\item{...}{not used}
}
\description{
This function is the print method for class \code{SUMMERprojlist}.
}
\examples{
\dontrun{
 library(SUMMER)
 library(dplyr)
 data(DemoData)
 # Create dataset of counts
 counts.all <- NULL
 for(i in 1:length(DemoData)){
 counts <- getCounts(DemoData[[i]][, c("clustid", "time", "age", "died",
                                      "region", "strata")],
          variables = 'died', by = c("age", "clustid", "region", 
                                       "time", "strata"))
 counts <- counts \%>\% mutate(cluster = clustid, years = time, Y=died)
 counts$strata <- gsub(".*\\\\.","",counts$strata)
 counts$survey <- names(DemoData)[i] 
 counts.all <- rbind(counts.all, counts)
 }
 
 # fit cluster-level model on the periods
 periods <- levels(DemoData[[1]]$time)
 fit <- smoothCluster(data = counts.all, 
    Amat = DemoMap$Amat, 
    time.model = "rw2", 
    st.time.model = "rw1",
    strata.time.effect =  TRUE, 
    survey.effect = TRUE,
    family = "betabinomial",
    year_label = c(periods, "15-19"))
 summary(fit)
 est <- getSmoothed(fit, nsim = 1000)
}
}
\author{
Zehang Li
}
