% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPop.R
\name{simPopInternal}
\alias{simPopInternal}
\alias{getExpectedNperEA}
\alias{getSortIndices}
\alias{rStratifiedMultnomial}
\alias{rStratifiedMultnomialBySubarea}
\alias{rMyMultinomial}
\alias{rMyMultinomialSubarea}
\alias{rmultinom1}
\alias{sampleNMultilevelMultinomial}
\alias{sampleNMultilevelMultinomialFixed}
\title{Internal functions for population simulation}
\usage{
getExpectedNperEA(easpa, popMat, level = c("grid", "EA"), pixelIndexMat = NULL)

getSortIndices(
  i,
  urban = TRUE,
  popMat,
  stratifyByUrban = TRUE,
  validationPixelI = NULL
)

rStratifiedMultnomial(n, popMat, easpa, stratifyByUrban = TRUE)

rStratifiedMultnomialBySubarea(
  n,
  popMat,
  easpa,
  stratifyByUrban = TRUE,
  poppsub = NULL,
  min1PerSubarea = TRUE,
  minSample = 1
)

rMyMultinomial(
  n,
  i,
  stratifyByUrban = TRUE,
  urban = TRUE,
  popMat = NULL,
  easpa = NULL,
  min1PerSubarea = FALSE,
  method = c("mult1", "mult", "indepMH"),
  minSample = 1
)

rMyMultinomialSubarea(
  n,
  i,
  easpsub,
  stratifyByUrban = TRUE,
  urban = TRUE,
  popMat = NULL
)

rmultinom1(
  n = 1,
  size,
  prob,
  maxSize = 8000 * 8000,
  method = c("mult1", "mult", "indepMH"),
  verbose = FALSE,
  minSample = 100,
  maxExpectedSizeBeforeSwitch = 1000 * 1e+07,
  init = NULL,
  burnIn = floor(n/4),
  filterEvery = 10,
  zeroProbZeroSamples = TRUE,
  allowSizeLessThanK = FALSE
)

sampleNMultilevelMultinomial(
  nDraws = ncol(pixelIndexMat),
  pixelIndexMat = NULL,
  urbanMat = NULL,
  areaMat = NULL,
  easpaList,
  popMat,
  stratifyByUrban = TRUE,
  verbose = TRUE,
  returnEAinfo = FALSE,
  minHHPerEA = 25,
  fixHHPerEA = NULL,
  fixPopPerHH = NULL
)

sampleNMultilevelMultinomialFixed(
  clustersPerPixel,
  nDraws = ncol(pixelIndices),
  pixelIndices = NULL,
  urbanVals = NULL,
  areaVals = NULL,
  easpa,
  popMat,
  stratifyByUrban = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{easpa}{Census frame. See \code{\link{simPopCustom}} for details}

\item{popMat}{data.frame of pixellated grid of population densities. See \code{\link{simPopCustom}} for details}

\item{level}{Whether to calculate results at the integration grid or EA level}

\item{pixelIndexMat}{Matrix of pixel indices associated with each EA and draw. Not 
required by getExpectedNperEA unless level == "EA"}

\item{i}{Index}

\item{urban}{If TRUE, calculate only for urban part of the area. If FALSE, for only rural part}

\item{stratifyByUrban}{whether or not to stratify calculations by urban/rural classification}

\item{validationPixelI}{CURRENTLY FOR TESTING PURPOSES ONLY a set of indices of pixels for which we want to simulate populations (used for pixel level validation)}

\item{n}{Number of samples}

\item{poppsub}{Population per subarea. See \code{\link{simPopCustom}} for details}

\item{min1PerSubarea}{Whether or not to ensure there is at least 1 EA per subarea. See \code{\link{simPopCustom}} for details}

\item{minSample}{The minimum number of samples per `chunk` of samples for truncated multinomial sampling. Defaults to 1}

\item{method}{If min1PerSubarea is TRUE, the sampling method for the truncated multinomial to use with rmulitnom1. rmultinom1 automatically 
        switches between them depending on the number of expected samples. The methods are:
\describe{
  \item{mult1}{rejection sampling from multinomial plus 1 in each category}
  \item{mult}{rejection sampling from multinomial if any category has zero count}
  \item{indepMH}{independent Metropolis-Hastings using multinomial plus 1 distribution as proposal}
}}

\item{easpsub}{This could either be total EAs per subarea, or subarea crossed with urban or 
rural if stratifyByUrban is TRUE}

\item{size}{Multinomial size parameter. See \code{\link[stats]{rmultinom}}}

\item{prob}{Multinomial probability vector parameter. See \code{\link[stats]{rmultinom}}}

\item{maxSize}{The maximum number of elements in a matrix drawn from the proposal distribution per sample chunk.}

\item{verbose}{Whether to print progress as the function proceeds}

\item{maxExpectedSizeBeforeSwitch}{Max expected number of samples / k, the number of categories, before switching method}

\item{init}{Initial sample if method is `indepMH`}

\item{burnIn}{Number of initial samples before samples are collected if method is `indepMH`}

\item{filterEvery}{Store only every filterEvery samples if method is i`indepMH`}

\item{zeroProbZeroSamples}{If TRUE, set samples for parts of prob vector that are zero to zero. Otherwise they are set to one.}

\item{allowSizeLessThanK}{If TRUE, then if size < the number of categories (k), returns matrix where each 
column is vector of size ones and k - size zeros. If FALSE, throws an error if size < k}

\item{nDraws}{Number of draws}

\item{urbanMat}{Matrix of urbanicities associated with each EA and draw}

\item{areaMat}{Matrix of areas associated with each EA and draw}

\item{easpaList}{A list of length n with each element being of the format of easpa 
giving the number of households and EAs 
per stratum. It is assumed that the number of EAs per stratum is 
the same in each list element. If easpaList is a data frame, 
number of households per stratum is assumed constant}

\item{returnEAinfo}{Whether a data frame at the EA level is desired}

\item{minHHPerEA}{The minimum number of households per EA (defaults to 25, since 
that is the number of households sampled per DHS cluster)}

\item{fixHHPerEA}{If not NULL, the fixed number of households per EA}

\item{fixPopPerHH}{If not NULL, the fixed target population per household}

\item{clustersPerPixel}{CURRENTLY FOR TESTING PURPOSES ONLY a vector of length nIntegrationPoints specifying the number of clusters per pixel if they are fixed}

\item{pixelIndices}{A nEA x n matrix of pixel indices associated with each EA per simulation/draw}

\item{urbanVals}{A nEA x n matrix of urbanicities associated with each EA per simulation/draw}

\item{areaVals}{A nEA x n matrix of area names associated with each EA per simulation/draw}
}
\description{
Functions for calculating valuable quantities and for drawing from important 
distributions for population simulation.
}
\section{Functions}{
\itemize{
\item \code{getExpectedNperEA()}: Calculates expected denominator per enumeration area.

\item \code{getSortIndices()}: For recombining separate multinomials into the draws over all grid points

\item \code{rStratifiedMultnomial()}: Gives nIntegrationPoints x n matrix of draws from the stratified multinomial with values 
corresponding to the value of |C^g| for each pixel, g (the number of EAs/pixel)

\item \code{rStratifiedMultnomialBySubarea()}: Gives nIntegrationPoints x n matrix of draws from the stratified multinomial with values

\item \code{rMyMultinomial()}: 

\item \code{rMyMultinomialSubarea()}: 

\item \code{rmultinom1()}: Random (truncated) multinomial draws conditional on the number of each type being at least one

\item \code{sampleNMultilevelMultinomial()}: Take multilevel multinomial draws first from joint distribution of 
number of households per EA given the total per stratum, and then from the joint 
distribution of the total target population per household given 
the total per stratum

\item \code{sampleNMultilevelMultinomialFixed()}: Same as sampleNMultilevelMultinomial, except the number of EAs per pixel is fixed

}}
