% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smart_round.R
\name{smart_round}
\alias{smart_round}
\title{Smart numerical rounding function}
\usage{
smart_round(x, rnd = 0, return_char = TRUE)
}
\arguments{
\item{x}{Vector of values to be rounded. Numeric.}

\item{rnd}{Requested number of decimal places. Default is 0. Non-negative integer.}

\item{return_char}{Return rounded values as character string? Default is TRUE. Logical.}
}
\value{
If \code{return_char=TRUE}, returns a character string of same length as \code{x}. If \code{return_char=FALSE}, returns a numerical vector of same length as \code{x}.
}
\description{
Function to round numerical values with minimal information loss (e.g. to avoid "0.000" values in tables).
}
\details{
Rounds the values in its first argument to the specified number of decimal places (default 0). If brute-force rounding produces zero values (e.g. "0.00"), the number of decimal places is expanded to include the first significant digit.
}
\examples{
# Round a vector of numbers, character string output (best for tables) 
\dontrun{
out_1 <- smart_round(c(.0013,2.3,-1,pi),rnd=2)
out_1
}

# Round a vector of numbers, numerical output 
\dontrun{
out_2 <- smart_round(c(.0013,2.3,-1,pi),rnd=2,return_char=FALSE)
out_2
}
}
