% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{get_data}
\alias{get_data}
\alias{get_weights}
\alias{get_weightsfun}
\alias{get_specs}
\title{Extracting from a Stressed Model}
\usage{
get_data(object, xCol = "all")

get_weights(object)

get_weightsfun(object)

get_specs(object)
}
\arguments{
\item{object}{A \code{SWIM} object.}

\item{xCol}{Numeric or character vector, (names of) the columns of 
the underlying data 
of the \code{object} (\code{default = "all"}).}
}
\value{
\code{get_data}: A data.frame containing the realisations of 
        the stochastic model on which the \code{object} is based.

\code{get_weights:} A data.frame containing the scenario 
    weights of the \code{object}. Columns corresponds 
    to different stresses.

\code{get_weightsfun}: A list containing functions, which, 
    when applied to a column of the data, generate the 
    scenario weights of the \code{object}. The corresponding stressed 
    columns can be obtained via \code{get_specs}.\cr
    Use \code{\link{get_weights}} if the \code{SWIM} object only contains 
    scenario weights and not a list of functions.

\code{get_specs}: A data.frame containing specifications 
        of the stresses with each row corresponding to a different 
        stress. Only a selection of the specifications is returned; 
        however, all input variables are stored in the \code{object}.
        See also \code{\link{SWIM}}.
}
\description{
Extracting the data (realisations of the stochastic model), the 
    scenario weights, the functions generating the scenario weights, 
    or the specifications of the stress from an object of class 
    \code{SWIM}.
}
\section{Functions}{
\itemize{
\item \code{get_data}: extracting data.

\item \code{get_weights}: extracting scenario weights.

\item \code{get_weightsfun}: extracting weight functions.

\item \code{get_specs}: extracting information of the stress.
}}

\examples{
## continuing example in stress_VaR
set.seed(0)
x <- as.data.frame(cbind(
     "normal" = rnorm(1000), 
     "gamma" = rgamma(1000, shape = 2)))
  res1 <- stress(type = "VaR", x = x, 
                 alpha = 0.9, q_ratio = 1.05, k = 1)

## returning the underlying data
all(get_data(res1) == x)
 ## the scenario weights
w <- get_weights(res1) 
get_weightsfun(res1)
get_specs(res1)
  
## now add a stress on the means of both variables
res1 <- stress(type = "mean", x = res1, k = 1:2, new_means = c(0.5,1.5))
get_specs(res1)
## the required moments for a stress of type "mean" are not displayed 
## the type of stress and the specs for the second stress can be 
## extracted directly from the SWIM object.
res1$type[[2]]
res1$specs[[2]]
                                             
                                                              
                                                                                                
}
\seealso{
\code{\link{SWIM}}
}
\author{
Silvana M. Pesenti
}
